/*

This is AIP device register map library.

Device Name: All Devices

File Date : 2010-04-11

By Ryan Wang

ryan-wang@ti.com

*/
#ifndef _TAS57XX_MCU_EVM_
#define _TAS57XX_MCU_EVM_



//Logic Define
#define ON 		        0x11
#define OFF 		        0x00
#define POWER_ON                0x11
#define POWER_OFF               0x00
#define UN_MUTE                 0x11
#define MUTE                    0x00



//Output Type Define
#define CH1_0 			0x10
#define CH2_0 			0x20
#define CH2_1 			0x21

#define SDA_PIN 		0x02                                  // msp430x261x UCB0SDA pin
#define SCL_PIN 		0x04                                  // msp430x261x UCB0SCL pin
#define I2C_100KHZ 		0x50
#define I2C_200KHZ  	        0x28
#define I2C_400KHZ 		0x14

//MCU I/O control define

#define TAS57xx_RST_ON		P2OUT &=~BIT0
#define TAS57xx_RST_OFF		P2OUT |= BIT0
#define TAS57xx_PDN_ON		P2OUT &=~BIT1
#define TAS57xx_PDN_OFF		P2OUT |= BIT1
#define TAS57xx_MUTE_ON		P2OUT &=~BIT2
#define TAS57xx_MUTE_OFF	P2OUT |= BIT3
#define DIR9001_RST_ON		P3OUT &=~BIT0
#define DIR9001_RST_OFF		P3OUT |= BIT0

//MCU KEY Flag define
#define POWER_KEY_FG    	0x10
#define MUTE_KEY_FG     	0x20
#define VOL_UP_KEY_FG   	0x80
#define VOL_DOWN_KEY_FG  	0x40

#define LDN_3D_KEY_FG    	0x02
#define EQ_KEY_FG       	0x04
#define DRC_KEY_FG      	0x08


//VOL Define
#define MAX_VOL		        0
#define MIN_VOL                 20
#define VOL_DEFAULT             15

//MCU LED control define

#define EQ_LED_ON		P3OUT |= BIT6
#define EQ_LED_OFF		P3OUT &=~BIT6
#define POWER_LED_ON		P2OUT |= BIT4
#define POWER_LED_OFF		P2OUT &=~BIT4
#define DRC_LED_ON		P3OUT |= BIT7
#define DRC_LED_OFF		P3OUT &=~BIT7
#define LD_3D_LED_ON		P2OUT |= BIT3
#define LD_3D_LED_OFF		P2OUT &=~BIT3


extern unsigned char Output_Type;
extern unsigned char POWER_STATUS;
extern unsigned char MUTE_STATUS;
extern unsigned char EQ_STATUS;
extern unsigned char LD_3D_STATUS;


unsigned char TI_USCI_I2C_ReadOneByte(unsigned char slave_address, unsigned char register_address);
void TI_USCI_I2C_ReadMultiBytes(unsigned char slave_address, unsigned char register_address, unsigned char read_length, unsigned char *Rx_array);
void TI_USCI_I2C_WriteMultiBytes(unsigned char slave_address, unsigned char register_address, unsigned char write_length, unsigned char *Tx_array);
void TI_USCI_I2C_WriteOneByte(unsigned char slave_address, unsigned char register_address, unsigned char register_value);
void TI_USCI_I2C_Init(unsigned char i2c_master_speed);

void TI_TAS5711_EQ_Init(unsigned char Output_Type);
void TI_TAS5711_SET_OUTPUT(unsigned char Output_Type);

void TI_EVM_BOARD_Init();

void TI_TAS5711_Init(unsigned char Device_I2C_Address);
void TI_TAS5711_DRC_Init();
unsigned char OUTPUT_CONFIG_CHECK();
void Delay_1ms(unsigned int time);

void VOL_DOWN_Key_Press();
void VOL_UP_Key_Press();
void Mute_Key_Press();
void Power_Key_Press();
void EQ_Key_Press();
void DRC_Key_Press();
void LD_3D_Key_Press();

#endif
