/************************  TAS57XX I2C CONTROL  ********************************
This programe is used to control AIP product by writing one or more bytes to its
registers. This programe is based on MSP430 USCI module and can be used on any
IT MCU with USCI module.

Version: Default_Firmware_Ver_1.0

File Date : 2010-05-03

Target Device : All TAS57xx Devices

Discription: This version is used to control all tas57xx devices. Please open
TI_TAS57XX_LIB.H file to command in/out device.

By Ryan Wang
ryan-wang@ti.com

*******************************************************************************/
#include "msp430x21x2.h"
#include "TI_TAS5711_MCU_EVM.h"
#include "TI_TAS5711_LIB.h"


void main(void)

{

  WDTCTL = WDTPW + WDTHOLD;		  // Stop WDT

  BCSCTL1 = CALBC1_8MHZ; 	

  DCOCTL = CALDCO_8MHZ;		          //Setting MCU main clk to 8MHZ

  TI_EVM_BOARD_Init();			  //Init MCU I/O and Reset Chips

  TI_USCI_I2C_Init(I2C_200KHZ);           // Init I2C ports and speed

  TI_TAS5711_Init(TI_TAS5711_I2C_ADDR);

  __bis_SR_register(GIE);

}


#pragma vector=PORT1_VECTOR
  __interrupt void Port_1(void)
{
  unsigned char P1IN_TMP;
  P1IN_TMP = P1IN;
  unsigned char i;
  
  for (i=0;i<3;i++)
  {
    if (P1IN_TMP == P1IN)
      Delay_1ms(50);
    else
      break;
  }
 
 if (i == 3)
 {
    switch (P1IFG)
   {

//POWER ON/OFF KEY PRESS-------------------------------------
    case POWER_KEY_FG:
      if(MUTE_STATUS == UN_MUTE)
	{Power_Key_Press();}
         break;

//MUTE ON/OFF KEY PRESS------------------------------------

    case MUTE_KEY_FG:
      if(POWER_STATUS == POWER_ON)
	{Mute_Key_Press();}
         break;

//VOL_+ KEY PRESS------------------------------------------
 case VOL_UP_KEY_FG:
      if((POWER_STATUS == POWER_ON)&&(MUTE_STATUS == UN_MUTE))
	{          
          do 
          {
            VOL_UP_Key_Press();
            Delay_1ms(200);
          } while ( (P1IN | 0x7F) == 0x7F); //long time press
      
        }
         break;

//VOL_- KEY PRESS------------------------------------------

    case VOL_DOWN_KEY_FG:
      if((POWER_STATUS == POWER_ON)&&(MUTE_STATUS == UN_MUTE))
	{
          do 
          {
            VOL_DOWN_Key_Press();
            Delay_1ms(200);
          } while ( (P1IN | 0xBF) == 0xBF);//long time press
                 
        }
         break;

//EQ KEY PRESS------------------------------------------

    case EQ_KEY_FG:
      if ((POWER_STATUS == POWER_ON)&&(MUTE_STATUS == UN_MUTE)&&(LD_3D_STATUS == OFF))
	{EQ_Key_Press();}
         break;


//DRC KEY PRESS------------------------------------------

    case DRC_KEY_FG:
         if ((POWER_STATUS == POWER_ON)&&(MUTE_STATUS == UN_MUTE))
         {DRC_Key_Press();}
         break;

//3D_LDN KEY PRESS------------------------------------------

    case LDN_3D_KEY_FG:
         if ((POWER_STATUS == POWER_ON)&&(MUTE_STATUS == UN_MUTE)&&(EQ_STATUS == OFF))
         {LD_3D_Key_Press();}
         break;
  }

    P1IFG = 0x00;
}
}