/** @file gio.h
*   @brief GIO Driver Definition File
*   @date 7.January.2013
*   @version 03.04.00
*   
*/

/* (c) Texas Instruments 2009-2013, All rights reserved. */

#ifndef __GIO_H__
#define __GIO_H__

#include "reg_gio.h"



/* GIO Interface Functions */
void gioInit(void);
void gioSetDirection(gioPORT_t *port, uint32 dir);
void gioSetBit(gioPORT_t *port, uint32 bit, uint32 value);
void gioSetPort(gioPORT_t *port, uint32 value);
uint32 gioGetBit(gioPORT_t *port, uint32 bit);
uint32 gioGetPort(gioPORT_t *port);
void gioToggleBit(gioPORT_t *port, uint32 bit);
void gioEnableNotification(uint32 bit);
void gioDisableNotification(uint32 bit);
void gioNotification(sint32 bit);

#endif
