/** @file mibspi.h
*   @brief MIBSPI Driver Definition File
*   @date 02-Mar-2016
*   @version 04.05.02
*
*/

/* 
* Copyright (C) 2009-2016 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/



#ifndef __MIBSPI_H__
#define __MIBSPI_H__

#include "%%MIBSPI:HDRMIBSPI_R%%"

#ifdef __cplusplus
extern "C" {
#endif

@@USERCODE

/** @enum triggerEvent
*   @brief Transfer Group Trigger Event
*/
enum triggerEvent
{
    TRG_NEVER   = 0U,
    TRG_RISING  = 1U,
    TRG_FALLING = 2U,
    TRG_BOTH    = 3U,
    TRG_HIGH    = 5U,
    TRG_LOW     = 6U,
    TRG_ALWAYS  = 7U
};

/** @enum triggerSource
*   @brief Transfer Group Trigger Source
*/
enum triggerSource
{
    TRG_DISABLED,
    TRG_GIOA0,
    TRG_GIOA1,
    TRG_GIOA2,
    TRG_GIOA3,
    TRG_GIOA4,
    TRG_GIOA5,
    TRG_GIOA6,
    TRG_GIOA7,
    TRG_HET1_8,
    TRG_HET1_10,
    TRG_HET1_12,
    TRG_HET1_14,
    TRG_HET1_16,
    TRG_HET1_18,
    TRG_TICK
};


/** @enum mibspiPinSelect
*   @brief mibspi Pin Select
*/
enum mibspiPinSelect
{
    PIN_CS0 = 0U,
    PIN_CS1 = 1U,
    PIN_CS2 = 2U,
    PIN_CS3 = 3U,
    PIN_CS4 = 4U,
    PIN_CS5 = 5U,
    PIN_CS6 = 6U,
    PIN_CS7 = 7U,
    PIN_ENA = 8U,
    PIN_CLK = 9U,
    PIN_SIMO = 10U,
    PIN_SOMI = 11U,
   PIN_SIMO_1 = 17U,
   PIN_SIMO_2 = 18U,
   PIN_SIMO_3 = 19U,
   PIN_SIMO_4 = 20U,
   PIN_SIMO_5 = 21U,
   PIN_SIMO_6 = 22U,
   PIN_SIMO_7 = 23U,
   PIN_SOMI_1 = 25U,
   PIN_SOMI_2 = 26U,
   PIN_SOMI_3 = 27U,
   PIN_SOMI_4 = 28U,
   PIN_SOMI_5 = 29U,
   PIN_SOMI_6 = 30U,
   PIN_SOMI_7 = 31U
};


/** @enum chipSelect
*   @brief Transfer Group Chip Select
*/
enum chipSelect
{
    CS_NONE = 0xFFU,
    CS_0    = 0xFEU,
    CS_1    = 0xFDU,
    CS_2    = 0xFBU,
    CS_3    = 0xF7U,
    CS_4    = 0xEFU,
    CS_5    = 0xDFU,
    CS_6    = 0xBFU,
    CS_7    = 0x7FU
};

/** @typedef mibspiPmode_t
*   @brief Mibspi Parellel mode Type Definition
*
*   This type is used to represent Mibspi Parellel mode.
*/
typedef enum mibspiPmode
{
    PMODE_NORMAL        = 0x0U,
    PMODE_2_DATALINE    = 0x1U,
    PMODE_4_DATALINE    = 0x2U,
    PMODE_8_DATALINE    = 0x3U
}mibspiPmode_t;

/** @typedef mibspiDFMT_t
*   @brief Mibspi Data format selection Type Definition
*
*   This type is used to represent Mibspi Data format selection.
*/
typedef enum mibspiDFMT
{
    DATA_FORMAT0    = 0x0U,
    DATA_FORMAT1    = 0x1U,
    DATA_FORMAT2    = 0x2U,
    DATA_FORMAT3    = 0x3U
}mibspiDFMT_t;

typedef struct mibspi_config_reg
{
    uint32 CONFIG_GCR1;
    uint32 CONFIG_INT0;
    uint32 CONFIG_LVL;
    uint32 CONFIG_PCFUN;
    uint32 CONFIG_PCDIR;
    uint32 CONFIG_PCPDR;
    uint32 CONFIG_PCDIS;
    uint32 CONFIG_PCPSL;
    uint32 CONFIG_DELAY;
    uint32 CONFIG_FMT0;
    uint32 CONFIG_FMT1;
    uint32 CONFIG_FMT2;
    uint32 CONFIG_FMT3;
    uint32 CONFIG_MIBSPIE;
    uint32 CONFIG_LTGPEND;
    uint32 CONFIG_TGCTRL[8U];
    uint32 CONFIG_UERRCTRL;
}mibspi_config_reg_t;

#if %%SYSTEM:MIBSPI1_ENABLE%%
#define MIBSPI1_GCR1_CONFIGVALUE     (0x01000000U | (uint32)((uint32)%%MIBSPI1:MIBSPI1_CLKMOD%%U << 1U) | %%MIBSPI1:MIBSPI1_MASTER%%U)
#define MIBSPI1_INT0_CONFIGVALUE     ((uint32)((uint32)%%MIBSPI1:MIBSPI1_ENABLEHIGHZ%%U << 24U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TXINTENA%%U << 9U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_RXINTENA%%U << 8U)  | (uint32)((uint32)%%MIBSPI1:MIBSPI1_OVRNINTENA%%U << 6U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_BITERRENA%%U << 4U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_DEYSNCENA%%U << 3U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PARERRENA%%U << 2U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TIMEOUTENA%%U << 1U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_DLENERRENA%%U << 0U))
#define MIBSPI1_LVL_CONFIGVALUE      ((uint32)((uint32)%%MIBSPI1:MIBSPI1_TXINTLVL%%U << 9U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_RXINTLVL%%U << 8U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_OVRNINTLVL%%U << 6U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_BITERRLVL%%U << 4U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_DEYSNCLVL%%U << 3U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PARERRLVL%%U << 2U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TIMEOUTLVL%%U << 1U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_DLENERRLVL%%U << 0U))

#define MIBSPI1_PCFUN_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT0_FUN%%U << 0U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT1_FUN%%U << 1U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT2_FUN%%U << 2U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT3_FUN%%U << 3U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT4_FUN%%U << 4U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT5_FUN%%U << 5U) |  (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT8_FUN%%U << 8U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT9_FUN%%U << 9U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT10_FUN%%U << 10U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT10_FUN%%U << 16U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT11_FUN%%U << 11U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT11_FUN%%U << 24U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT17_FUN%%U << 17U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT25_FUN%%U << 25U))
#define MIBSPI1_PCDIR_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT0_DIR%%U << 0U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT1_DIR%%U << 1U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT2_DIR%%U << 2U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT3_DIR%%U << 3U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT4_DIR%%U << 4U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT5_DIR%%U << 5U) |  (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT8_DIR%%U << 8U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT9_DIR%%U << 9U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT10_DIR%%U << 10U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT10_DIR%%U << 16U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT11_DIR%%U << 11U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT11_DIR%%U << 24U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT17_DIR%%U << 17U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT25_DIR%%U << 25U))
#define MIBSPI1_PCPDR_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT0_PDR%%U << 0U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT1_PDR%%U << 1U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT2_PDR%%U << 2U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT3_PDR%%U << 3U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT4_PDR%%U << 4U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT5_PDR%%U << 5U) |  (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT8_PDR%%U << 8U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT9_PDR%%U << 9U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT10_PDR%%U << 10U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT10_PDR%%U << 16U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT11_PDR%%U << 11U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT11_PDR%%U << 24U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT17_PDR%%U << 17U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT25_PDR%%U << 25U))
#define MIBSPI1_PCDIS_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT0_PULDIS%%U << 0U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT1_PULDIS%%U << 1U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT2_PULDIS%%U << 2U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT3_PULDIS%%U << 3U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT4_PULDIS%%U << 4U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT5_PULDIS%%U << 5U) |  (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT8_PULDIS%%U << 8U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT9_PULDIS%%U << 9U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT10_PULDIS%%U << 10U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT10_PULDIS%%U << 16U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT11_PULDIS%%U << 11U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT11_PULDIS%%U << 24U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT17_PULDIS%%U << 17U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT25_PULDIS%%U << 25U))
#define MIBSPI1_PCPSL_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT0_PSL%%U << 0U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT1_PSL%%U << 1U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT2_PSL%%U << 2U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT3_PSL%%U << 3U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT4_PSL%%U << 4U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT5_PSL%%U << 5U) |  (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT8_PSL%%U << 8U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT9_PSL%%U << 9U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT10_PSL%%U << 10U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT10_PSL%%U << 16U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT11_PSL%%U << 11U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT11_PSL%%U << 24U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT17_PSL%%U << 17U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PORT_BIT25_PSL%%U << 25U))

#define MIBSPI1_DELAY_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI1:MIBSPI1_C2TDELAY%%U << 24U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_T2CDELAY%%U << 16U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_T2EDELAY%%U << 8U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_C2EDELAY%%U << 0U))

#define MIBSPI1_FMT0_CONFIGVALUE     ((uint32)((uint32)%%MIBSPI1:MIBSPI1_WDELAY0%%U << 24U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PARPOL0%%U << 23U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PARITYENA0%%U << 22U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_WAITENA0%%U << 21U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_SHIFTDIR0%%U << 20U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_POLARITY0%%U << 17U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PHASE0%%U << 16U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PRESCALE0%%U << 8U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_CHARLEN0%%U << 0U))
#define MIBSPI1_FMT1_CONFIGVALUE     ((uint32)((uint32)%%MIBSPI1:MIBSPI1_WDELAY1%%U << 24U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PARPOL1%%U << 23U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PARITYENA1%%U << 22U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_WAITENA1%%U << 21U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_SHIFTDIR1%%U << 20U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_POLARITY1%%U << 17U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PHASE1%%U << 16U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PRESCALE1%%U << 8U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_CHARLEN1%%U << 0U))
#define MIBSPI1_FMT2_CONFIGVALUE     ((uint32)((uint32)%%MIBSPI1:MIBSPI1_WDELAY2%%U << 24U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PARPOL2%%U << 23U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PARITYENA2%%U << 22U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_WAITENA2%%U << 21U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_SHIFTDIR2%%U << 20U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_POLARITY2%%U << 17U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PHASE2%%U << 16U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PRESCALE2%%U << 8U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_CHARLEN2%%U << 0U))
#define MIBSPI1_FMT3_CONFIGVALUE     ((uint32)((uint32)%%MIBSPI1:MIBSPI1_WDELAY3%%U << 24U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PARPOL3%%U << 23U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PARITYENA3%%U << 22U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_WAITENA3%%U << 21U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_SHIFTDIR3%%U << 20U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_POLARITY3%%U << 17U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PHASE3%%U << 16U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_PRESCALE3%%U << 8U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_CHARLEN3%%U << 0U))

#define MIBSPI1_MIBSPIE_CONFIGVALUE  1U
#define MIBSPI1_LTGPEND_CONFIGVALUE  ((uint32)((uint32)((%%MIBSPI1:MIBSPI1_TG0_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG1_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG2_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG3_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG4_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG5_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG6_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG7_LENGTH%%U)-1U) << 8U))

#define MIBSPI1_TGCTRL0_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI1:MIBSPI1_TG0_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG0_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG0_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG0_TRGSRC%% << 16U) | (uint32)((uint32)0U << 8U)))
#define MIBSPI1_TGCTRL1_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI1:MIBSPI1_TG1_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG1_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG1_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG1_TRGSRC%% << 16U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG0_LENGTH%%U << 8U)))
#define MIBSPI1_TGCTRL2_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI1:MIBSPI1_TG2_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG2_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG2_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG2_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI1:MIBSPI1_TG0_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG1_LENGTH%%U) << 8U)))
#define MIBSPI1_TGCTRL3_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI1:MIBSPI1_TG3_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG3_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG3_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG3_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI1:MIBSPI1_TG0_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG1_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG2_LENGTH%%U) << 8U)))
#define MIBSPI1_TGCTRL4_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI1:MIBSPI1_TG4_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG4_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG4_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG4_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI1:MIBSPI1_TG0_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG1_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG2_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG3_LENGTH%%U) << 8U)))
#define MIBSPI1_TGCTRL5_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI1:MIBSPI1_TG5_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG5_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG5_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG5_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI1:MIBSPI1_TG0_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG1_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG2_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG3_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG4_LENGTH%%U) << 8U)))
#define MIBSPI1_TGCTRL6_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI1:MIBSPI1_TG6_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG6_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG6_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG6_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI1:MIBSPI1_TG0_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG1_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG2_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG3_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG4_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG5_LENGTH%%U) << 8U)))
#define MIBSPI1_TGCTRL7_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI1:MIBSPI1_TG7_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG7_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG7_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI1:MIBSPI1_TG7_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI1:MIBSPI1_TG0_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG1_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG2_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG3_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG4_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG5_LENGTH%%U+%%MIBSPI1:MIBSPI1_TG6_LENGTH%%U) << 8U)))

#define MIBSPI1_UERRCTRL_CONFIGVALUE (%%MIBSPI1:MIBSPI1_RAM_PARITY_ENA%%U)
#endif


#if %%SYSTEM:MIBSPI3_ENABLE%%
#define MIBSPI3_GCR1_CONFIGVALUE     (0x01000000U | (uint32)((uint32)%%MIBSPI3:MIBSPI3_CLKMOD%%U << 1U) | %%MIBSPI3:MIBSPI3_MASTER%%U)
#define MIBSPI3_INT0_CONFIGVALUE     ((uint32)((uint32)%%MIBSPI3:MIBSPI3_ENABLEHIGHZ%%U << 24U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TXINTENA%%U << 9U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_RXINTENA%%U << 8U)  | (uint32)((uint32)%%MIBSPI3:MIBSPI3_OVRNINTENA%%U << 6U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_BITERRENA%%U << 4U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_DEYSNCENA%%U << 3U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PARERRENA%%U << 2U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TIMEOUTENA%%U << 1U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_DLENERRENA%%U << 0U))
#define MIBSPI3_LVL_CONFIGVALUE      ((uint32)((uint32)%%MIBSPI3:MIBSPI3_TXINTLVL%%U << 9U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_RXINTLVL%%U << 8U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_OVRNINTLVL%%U << 6U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_BITERRLVL%%U << 4U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_DEYSNCLVL%%U << 3U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PARERRLVL%%U << 2U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TIMEOUTLVL%%U << 1U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_DLENERRLVL%%U << 0U))

#define MIBSPI3_PCFUN_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT0_FUN%%U << 0U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT1_FUN%%U << 1U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT2_FUN%%U << 2U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT3_FUN%%U << 3U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT4_FUN%%U << 4U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT5_FUN%%U << 5U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT8_FUN%%U << 8U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT9_FUN%%U << 9U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT10_FUN%%U << 10U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT10_FUN%%U << 16U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT11_FUN%%U << 11U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT11_FUN%%U << 24U))
#define MIBSPI3_PCDIR_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT0_DIR%%U << 0U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT1_DIR%%U << 1U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT2_DIR%%U << 2U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT3_DIR%%U << 3U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT4_DIR%%U << 4U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT5_DIR%%U << 5U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT8_DIR%%U << 8U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT9_DIR%%U << 9U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT10_DIR%%U << 10U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT10_DIR%%U << 16U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT11_DIR%%U << 11U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT11_DIR%%U << 24U))
#define MIBSPI3_PCPDR_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT0_PDR%%U << 0U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT1_PDR%%U << 1U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT2_PDR%%U << 2U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT3_PDR%%U << 3U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT4_PDR%%U << 4U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT5_PDR%%U << 5U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT8_PDR%%U << 8U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT9_PDR%%U << 9U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT10_PDR%%U << 10U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT10_PDR%%U << 16U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT11_PDR%%U << 11U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT11_PDR%%U << 24U))
#define MIBSPI3_PCDIS_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT0_PULDIS%%U << 0U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT1_PULDIS%%U << 1U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT2_PULDIS%%U << 2U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT3_PULDIS%%U << 3U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT4_PULDIS%%U << 4U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT5_PULDIS%%U << 5U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT8_PULDIS%%U << 8U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT9_PULDIS%%U << 9U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT10_PULDIS%%U << 10U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT10_PULDIS%%U << 16U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT11_PULDIS%%U << 11U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT11_PULDIS%%U << 24U))
#define MIBSPI3_PCPSL_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT0_PSL%%U << 0U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT1_PSL%%U << 1U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT2_PSL%%U << 2U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT3_PSL%%U << 3U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT4_PSL%%U << 4U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT5_PSL%%U << 5U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT8_PSL%%U << 8U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT9_PSL%%U << 9U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT10_PSL%%U << 10U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT10_PSL%%U << 16U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT11_PSL%%U << 11U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PORT_BIT11_PSL%%U << 24U))

#define MIBSPI3_DELAY_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI3:MIBSPI3_C2TDELAY%%U << 24U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_T2CDELAY%%U << 16U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_T2EDELAY%%U << 8U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_C2EDELAY%%U << 0U))

#define MIBSPI3_FMT0_CONFIGVALUE     ((uint32)((uint32)%%MIBSPI3:MIBSPI3_WDELAY0%%U << 24U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PARPOL0%%U << 23U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PARITYENA0%%U << 22U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_WAITENA0%%U << 21U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_SHIFTDIR0%%U << 20U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_POLARITY0%%U << 17U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PHASE0%%U << 16U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PRESCALE0%%U << 8U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_CHARLEN0%%U << 0U))
#define MIBSPI3_FMT1_CONFIGVALUE     ((uint32)((uint32)%%MIBSPI3:MIBSPI3_WDELAY1%%U << 24U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PARPOL1%%U << 23U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PARITYENA1%%U << 22U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_WAITENA1%%U << 21U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_SHIFTDIR1%%U << 20U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_POLARITY1%%U << 17U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PHASE1%%U << 16U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PRESCALE1%%U << 8U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_CHARLEN1%%U << 0U))
#define MIBSPI3_FMT2_CONFIGVALUE     ((uint32)((uint32)%%MIBSPI3:MIBSPI3_WDELAY2%%U << 24U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PARPOL2%%U << 23U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PARITYENA2%%U << 22U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_WAITENA2%%U << 21U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_SHIFTDIR2%%U << 20U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_POLARITY2%%U << 17U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PHASE2%%U << 16U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PRESCALE2%%U << 8U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_CHARLEN2%%U << 0U))
#define MIBSPI3_FMT3_CONFIGVALUE     ((uint32)((uint32)%%MIBSPI3:MIBSPI3_WDELAY3%%U << 24U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PARPOL3%%U << 23U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PARITYENA3%%U << 22U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_WAITENA3%%U << 21U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_SHIFTDIR3%%U << 20U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_POLARITY3%%U << 17U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PHASE3%%U << 16U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_PRESCALE3%%U << 8U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_CHARLEN3%%U << 0U))

#define MIBSPI3_MIBSPIE_CONFIGVALUE  1U
#define MIBSPI3_LTGPEND_CONFIGVALUE  ((uint32)((uint32)((%%MIBSPI3:MIBSPI3_TG0_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG1_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG2_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG3_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG4_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG5_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG6_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG7_LENGTH%%U)-1U) << 8U))

#define MIBSPI3_TGCTRL0_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI3:MIBSPI3_TG0_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG0_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG0_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG0_TRGSRC%% << 16U) | (uint32)((uint32)0U << 8U)))
#define MIBSPI3_TGCTRL1_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI3:MIBSPI3_TG1_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG1_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG1_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG1_TRGSRC%% << 16U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG0_LENGTH%%U << 8U)))
#define MIBSPI3_TGCTRL2_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI3:MIBSPI3_TG2_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG2_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG2_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG2_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI3:MIBSPI3_TG0_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG1_LENGTH%%U) << 8U)))
#define MIBSPI3_TGCTRL3_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI3:MIBSPI3_TG3_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG3_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG3_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG3_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI3:MIBSPI3_TG0_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG1_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG2_LENGTH%%U) << 8U)))
#define MIBSPI3_TGCTRL4_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI3:MIBSPI3_TG4_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG4_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG4_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG4_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI3:MIBSPI3_TG0_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG1_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG2_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG3_LENGTH%%U) << 8U)))
#define MIBSPI3_TGCTRL5_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI3:MIBSPI3_TG5_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG5_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG5_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG5_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI3:MIBSPI3_TG0_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG1_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG2_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG3_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG4_LENGTH%%U) << 8U)))
#define MIBSPI3_TGCTRL6_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI3:MIBSPI3_TG6_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG6_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG6_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG6_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI3:MIBSPI3_TG0_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG1_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG2_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG3_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG4_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG5_LENGTH%%U) << 8U)))
#define MIBSPI3_TGCTRL7_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI3:MIBSPI3_TG7_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG7_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG7_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI3:MIBSPI3_TG7_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI3:MIBSPI3_TG0_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG1_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG2_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG3_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG4_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG5_LENGTH%%U+%%MIBSPI3:MIBSPI3_TG6_LENGTH%%U) << 8U)))

#define MIBSPI3_UERRCTRL_CONFIGVALUE (%%MIBSPI3:MIBSPI3_RAM_PARITY_ENA%%U)
#endif

#if %%SYSTEM:MIBSPI5_ENABLE%%
#define MIBSPI5_GCR1_CONFIGVALUE     (0x01000000U | (uint32)((uint32)%%MIBSPI5:MIBSPI5_CLKMOD%%U << 1U) | %%MIBSPI5:MIBSPI5_MASTER%%U)
#define MIBSPI5_INT0_CONFIGVALUE     ((uint32)((uint32)%%MIBSPI5:MIBSPI5_ENABLEHIGHZ%%U << 24U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TXINTENA%%U << 9U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_RXINTENA%%U << 8U)  | (uint32)((uint32)%%MIBSPI5:MIBSPI5_OVRNINTENA%%U << 6U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_BITERRENA%%U << 4U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_DEYSNCENA%%U << 3U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PARERRENA%%U << 2U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TIMEOUTENA%%U << 1U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_DLENERRENA%%U << 0U))
#define MIBSPI5_LVL_CONFIGVALUE      ((uint32)((uint32)%%MIBSPI5:MIBSPI5_TXINTLVL%%U << 9U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_RXINTLVL%%U << 8U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_OVRNINTLVL%%U << 6U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_BITERRLVL%%U << 4U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_DEYSNCLVL%%U << 3U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PARERRLVL%%U << 2U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TIMEOUTLVL%%U << 1U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_DLENERRLVL%%U << 0U))

#define MIBSPI5_PCFUN_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT0_FUN%%U << 0U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT1_FUN%%U << 1U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT2_FUN%%U << 2U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT3_FUN%%U << 3U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT8_FUN%%U << 8U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT9_FUN%%U << 9U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT10_FUN%%U << 10U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT10_FUN%%U << 16U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT11_FUN%%U << 11U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT11_FUN%%U << 24U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT17_FUN%%U << 17U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT18_FUN%%U << 18U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT19_FUN%%U << 19U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT25_FUN%%U << 25U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT26_FUN%%U << 26U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT27_FUN%%U << 27U))
#define MIBSPI5_PCDIR_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT0_DIR%%U << 0U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT1_DIR%%U << 1U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT2_DIR%%U << 2U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT3_DIR%%U << 3U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT8_DIR%%U << 8U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT9_DIR%%U << 9U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT10_DIR%%U << 10U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT10_DIR%%U << 16U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT11_DIR%%U << 11U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT11_DIR%%U << 24U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT17_DIR%%U << 17U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT18_DIR%%U << 18U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT19_DIR%%U << 19U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT25_DIR%%U << 25U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT26_DIR%%U << 26U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT27_DIR%%U << 27U))
#define MIBSPI5_PCPDR_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT0_PDR%%U << 0U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT1_PDR%%U << 1U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT2_PDR%%U << 2U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT3_PDR%%U << 3U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT8_PDR%%U << 8U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT9_PDR%%U << 9U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT10_PDR%%U << 10U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT10_PDR%%U << 16U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT11_PDR%%U << 11U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT11_PDR%%U << 24U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT17_PDR%%U << 17U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT18_PDR%%U << 18U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT19_PDR%%U << 19U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT25_PDR%%U << 25U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT26_PDR%%U << 26U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT27_PDR%%U << 27U))
#define MIBSPI5_PCDIS_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT0_PULDIS%%U << 0U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT1_PULDIS%%U << 1U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT2_PULDIS%%U << 2U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT3_PULDIS%%U << 3U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT8_PULDIS%%U << 8U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT9_PULDIS%%U << 9U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT10_PULDIS%%U << 10U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT10_PULDIS%%U << 16U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT11_PULDIS%%U << 11U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT11_PULDIS%%U << 24U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT17_PULDIS%%U << 17U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT18_PULDIS%%U << 18U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT19_PULDIS%%U << 19U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT25_PULDIS%%U << 25U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT26_PULDIS%%U << 26U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT27_PULDIS%%U << 27U))
#define MIBSPI5_PCPSL_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT0_PSL%%U << 0U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT1_PSL%%U << 1U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT2_PSL%%U << 2U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT3_PSL%%U << 3U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT8_PSL%%U << 8U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT9_PSL%%U << 9U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT10_PSL%%U << 10U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT10_PSL%%U << 16U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT11_PSL%%U << 11U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT11_PSL%%U << 24U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT17_PSL%%U << 17U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT18_PSL%%U << 18U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT19_PSL%%U << 19U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT25_PSL%%U << 25U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT26_PSL%%U << 26U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PORT_BIT27_PSL%%U << 27U))

#define MIBSPI5_DELAY_CONFIGVALUE    ((uint32)((uint32)%%MIBSPI5:MIBSPI5_C2TDELAY%%U << 24U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_T2CDELAY%%U << 16U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_T2EDELAY%%U << 8U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_C2EDELAY%%U << 0U))

#define MIBSPI5_FMT0_CONFIGVALUE     ((uint32)((uint32)%%MIBSPI5:MIBSPI5_WDELAY0%%U << 24U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PARPOL0%%U << 23U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PARITYENA0%%U << 22U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_WAITENA0%%U << 21U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_SHIFTDIR0%%U << 20U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_POLARITY0%%U << 17U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PHASE0%%U << 16U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PRESCALE0%%U << 8U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_CHARLEN0%%U << 0U))
#define MIBSPI5_FMT1_CONFIGVALUE     ((uint32)((uint32)%%MIBSPI5:MIBSPI5_WDELAY1%%U << 24U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PARPOL1%%U << 23U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PARITYENA1%%U << 22U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_WAITENA1%%U << 21U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_SHIFTDIR1%%U << 20U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_POLARITY1%%U << 17U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PHASE1%%U << 16U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PRESCALE1%%U << 8U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_CHARLEN1%%U << 0U))
#define MIBSPI5_FMT2_CONFIGVALUE     ((uint32)((uint32)%%MIBSPI5:MIBSPI5_WDELAY2%%U << 24U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PARPOL2%%U << 23U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PARITYENA2%%U << 22U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_WAITENA2%%U << 21U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_SHIFTDIR2%%U << 20U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_POLARITY2%%U << 17U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PHASE2%%U << 16U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PRESCALE2%%U << 8U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_CHARLEN2%%U << 0U))
#define MIBSPI5_FMT3_CONFIGVALUE     ((uint32)((uint32)%%MIBSPI5:MIBSPI5_WDELAY3%%U << 24U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PARPOL3%%U << 23U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PARITYENA3%%U << 22U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_WAITENA3%%U << 21U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_SHIFTDIR3%%U << 20U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_POLARITY3%%U << 17U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PHASE3%%U << 16U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_PRESCALE3%%U << 8U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_CHARLEN3%%U << 0U))

#define MIBSPI5_MIBSPIE_CONFIGVALUE  1U
#define MIBSPI5_LTGPEND_CONFIGVALUE  ((uint32)((uint32)((%%MIBSPI5:MIBSPI5_TG0_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG1_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG2_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG3_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG4_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG5_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG6_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG7_LENGTH%%U)-1U) << 8U))

#define MIBSPI5_TGCTRL0_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI5:MIBSPI5_TG0_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG0_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG0_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG0_TRGSRC%% << 16U) | (uint32)((uint32)0U << 8U)))
#define MIBSPI5_TGCTRL1_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI5:MIBSPI5_TG1_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG1_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG1_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG1_TRGSRC%% << 16U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG0_LENGTH%%U << 8U)))
#define MIBSPI5_TGCTRL2_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI5:MIBSPI5_TG2_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG2_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG2_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG2_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI5:MIBSPI5_TG0_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG1_LENGTH%%U) << 8U)))
#define MIBSPI5_TGCTRL3_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI5:MIBSPI5_TG3_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG3_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG3_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG3_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI5:MIBSPI5_TG0_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG1_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG2_LENGTH%%U) << 8U)))
#define MIBSPI5_TGCTRL4_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI5:MIBSPI5_TG4_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG4_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG4_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG4_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI5:MIBSPI5_TG0_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG1_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG2_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG3_LENGTH%%U) << 8U)))
#define MIBSPI5_TGCTRL5_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI5:MIBSPI5_TG5_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG5_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG5_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG5_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI5:MIBSPI5_TG0_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG1_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG2_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG3_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG4_LENGTH%%U) << 8U)))
#define MIBSPI5_TGCTRL6_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI5:MIBSPI5_TG6_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG6_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG6_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG6_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI5:MIBSPI5_TG0_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG1_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG2_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG3_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG4_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG5_LENGTH%%U) << 8U)))
#define MIBSPI5_TGCTRL7_CONFIGVALUE  (0xFFFF7FFFU & ((uint32)((uint32)%%MIBSPI5:MIBSPI5_TG7_ONESHOT%%U << 30U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG7_PRST%%U << 29U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG7_TRGEVT%% << 20U) | (uint32)((uint32)%%MIBSPI5:MIBSPI5_TG7_TRGSRC%% << 16U) | (uint32)((uint32)(%%MIBSPI5:MIBSPI5_TG0_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG1_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG2_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG3_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG4_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG5_LENGTH%%U+%%MIBSPI5:MIBSPI5_TG6_LENGTH%%U) << 8U)))

#define MIBSPI5_UERRCTRL_CONFIGVALUE (%%MIBSPI5:MIBSPI5_RAM_PARITY_ENA%%U)
#endif

/**
 *  @defgroup MIBSPI MIBSPI
 *  @brief Multi-Buffered Serial Peripheral Interface Module.
 *
 *  The MibSPI/MibSPIP is a high-speed synchronous serial input/output port that allows a serial bit stream of
 *  programmed length (2 to 16 bits) to be shifted in and out of the device at a programmed bit-transfer rate.
 *  The MibSPI has a programmable buffer memory that enables programmed transmission to be completed
 *  without CPU intervention
 *
 *    Related Files
 *   - reg_mibspi.h
 *   - mibspi.h
 *   - mibspi.c
 *  @addtogroup MIBSPI
 *  @{
 */

/* MIBSPI Interface Functions */
void mibspiInit(void);
void mibspiSetFunctional(mibspiBASE_t *mibspi, uint32 port);
void mibspiSetData(mibspiBASE_t *mibspi, uint32 group, uint16 * data);
uint32 mibspiGetData(mibspiBASE_t *mibspi, uint32 group, uint16 * data);
void mibspiTransfer(mibspiBASE_t *mibspi, uint32 group);
boolean mibspiIsTransferComplete(mibspiBASE_t *mibspi, uint32 group);
void mibspiEnableGroupNotification(mibspiBASE_t *mibspi, uint32 group, uint32 level);
void mibspiDisableGroupNotification(mibspiBASE_t *mibspi, uint32 group);
void mibspiEnableLoopback(mibspiBASE_t *mibspi, loopBackType_t Loopbacktype);
void mibspiDisableLoopback(mibspiBASE_t *mibspi);
void mibspiPmodeSet(mibspiBASE_t *mibspi, mibspiPmode_t Pmode, mibspiDFMT_t DFMT);
#if %%SYSTEM:MIBSPI1_ENABLE%%
void mibspi1GetConfigValue(mibspi_config_reg_t *config_reg, config_value_type_t type);
#endif
#if %%SYSTEM:MIBSPI3_ENABLE%%
void mibspi3GetConfigValue(mibspi_config_reg_t *config_reg, config_value_type_t type);
#endif
#if %%SYSTEM:MIBSPI5_ENABLE%%
void mibspi5GetConfigValue(mibspi_config_reg_t *config_reg, config_value_type_t type);
#endif

/** @fn void mibspiNotification(mibspiBASE_t *mibspi, uint32 flags)
*   @brief Error interrupt callback
*   @param[in] mibspi   - mibSpi module base address
*   @param[in] flags - Copy of error interrupt flags
*
* This is a error callback that is provided by the application and is call upon
* an error interrupt.  The paramer passed to the callback is a copy of the error
* interrupt flag register.
*/
void mibspiNotification(mibspiBASE_t *mibspi, uint32 flags);


/** @fn void mibspiGroupNotification(mibspiBASE_t *mibspi, uint32 group)
*   @brief Transfer complete notification callback
*   @param[in] mibspi   - mibSpi module base address
*   @param[in] group - Transfer group
*
* This is a callback function provided by the application.  It is call when
* a transfer is complete.  The parameter is the transfer group that triggered
* the interrupt.
*/
void mibspiGroupNotification(mibspiBASE_t *mibspi, uint32 group);

@@USERCODE

/**@}*/
#ifdef __cplusplus
}
#endif

#endif
