//#include <stdio.h>
//#include <intrinsics.h>
#include "sys_common.h"
#include "sys_core.h"
#include "system.h"
#include "gio.h"
#include "mibspi.h"

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

uint16 TG0_TX_DATA[8] = {0x1000, 0x1111, 0x1222, 0x1333, 0x1444, 0x1555, 0x1666, 0x1777};
uint16 TG0_RX_DATA[8]= {0};

uint16 TG1_TX_DATA[8] = {0x2000, 0x2111, 0x2222, 0x2333, 0x2444, 0x2555, 0x2666, 0x2777};
uint16 TG1_RX_DATA[8]= {0};

uint16 TG2_TX_DATA[8] = {0x3000, 0x3111, 0x3222, 0x3333, 0x3444, 0x3555, 0x3666, 0x3777};
uint16 TG2_RX_DATA[8]= {0};

uint16 TG3_TX_DATA[8] = {0x4000, 0x4111, 0x4222, 0x4333, 0x4444, 0x4555, 0x4666, 0x4777};
uint16 TG3_RX_DATA[8]= {0};

uint32_t TG3_IS_Complete;

void main(void)
{
        int a = 0;
  
        TG3_IS_Complete = 0x55555555;
  
        //spiInit();
        gioInit();

	/* Enable IRQ Interrupt in Cortex R4 CPU */
	_enable_interrupt_();

	/* - initializing mibspi - enabling tg 0,1,2,3 , length 8 bytes each
	 * TG 0 - Configured for TICK Trigger
	 * TG 1, 2, 3, are SOftware Triggered
	 * CS 0 is used. - CS0 is in HOLD Mode,
	 * CS 0 Toggles only after Each TG ( Every 8 byte) is complete
	 * Trigger is One Shot, so only once the TG will transmit.
	 */
	mibspiInit();

	/* - enabling loopback ( this is to emulate data transfer without external wires */
	//mibspiEnableLoopback(mibspiREG1,Digital_Lbk);//Analog_Lbk);
        mibspiDisableLoopback(mibspiREG1);


	/* Enable TG 0,1,2,3 complete interrupt to INT 0 */
	mibspiEnableGroupNotification(mibspiREG1,0,0);
	mibspiEnableGroupNotification(mibspiREG1,1,0);
	mibspiEnableGroupNotification(mibspiREG1,2,0);
	mibspiEnableGroupNotification(mibspiREG1,3,0);

	/* Fill the transfer Groups */
        mibspiSetData(mibspiREG1,0,TG0_TX_DATA);
        mibspiSetData(mibspiREG1,1,TG1_TX_DATA);
        mibspiSetData(mibspiREG1,2,TG2_TX_DATA);
        mibspiSetData(mibspiREG1,3,TG3_TX_DATA);

	/* Enable TG0 to start, once tickCNT triggers */
        gioSetBit(gioPORTA,2,1);
        gioSetBit(gioPORTA,2,0);
        
        
        
        for (a=0; a<1; a++){}
        
        
        mibspiTransfer(mibspiREG1,0 );
        while(TRUE!=mibspiIsTransferComplete(mibspiREG1, 0));
        gioSetBit(gioPORTA,2,1);

	/* Configure TICKCNT
	 * DATA FORMAT 0 is selected which has SPICLK set as 1000KHz
	 * So tick is 0xFFFF * (1/1000KHz) = 65.5535 msec*/
	mibspiREG1->TICKCNT = 0x8000FFFF;

	/* Wait until this flag is set in TG3 ISR */
	//while(TG3_IS_Complete != 0xA5A5A5A5);
               

	mibspiGetData(mibspiREG1,0,TG0_RX_DATA);
	mibspiGetData(mibspiREG1,1,TG1_RX_DATA);
	mibspiGetData(mibspiREG1,2,TG2_RX_DATA);
	mibspiGetData(mibspiREG1,3,TG3_RX_DATA);

	while(1);
}
#if 0
void mibspiGroupNotification(mibspiBASE_t *mibspi, uint32 group)
{
	switch (group){
		case 0 :
			/* Enable TG1 to start, SW Trigger */
			mibspiTransfer(mibspiREG1,1);
			break;
		case 1 :
			/* Enable TG1 to start, SW Trigger */
			mibspiTransfer(mibspiREG1,2);
			break;
		case 2 :
			/* Enable TG1 to start, SW Trigger */
			mibspiTransfer(mibspiREG1,3);
			break;
		case 3 :
			/* Enable TG0 to start, SW Trigger */
			//mibspiTransfer(mibspiREG1,0);
			TG3_IS_Complete = 0xA5A5A5A5;
			break;
		default :
			while(1);
			break;
	}
}
#endif