#include <stdio.h>
#include <intrinsics.h>
#include "sys_common.h"
#include "system.h"
#include "gio.h"
#include "sci.h"
#include "spi.h"
int fputc(int ch, FILE *f)
{
  sciSendByte(scilinREG,ch);
  return 0;
}

uint16 TX_Data_Master[16] = { 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10 };
uint16 RX_Data_Master[16] = { 0 };
uint16 done=0;

void main(void)
{
  int a = 0, b = 0;
  
  uint32 counter=0;
  spiDAT1_t dataconfig1_t;

  dataconfig1_t.CS_HOLD = FALSE;
  dataconfig1_t.WDEL    = TRUE;
  dataconfig1_t.DFSEL   = SPI_FMT_0;
  dataconfig1_t.CSNR    = 0xFD; // chip select CS1 
  
  gioInit();
  sciInit();
  spiInit();
  printf("----------\r\n");
  //gioSetDirection(gioPORTA,);
//  while(1)
//  {
//    gioSetBit(gioPORTA,2,1);
//    for (a=0;a<1000000;a++);
//    gioSetBit(gioPORTA,2,0);
//    for (a=0;a<1000000;a++); 
//    printf("hello %d\n",b++);
//  }


  /* Enable CPU Interrupt through CPSR */
  //_enable_IRQ();
  //__enable_irq();
  //printf("IRQ interrupt are now enabled\n");
  //spiInit();
  //printf("SPI2 is now initialized\n");
  //spiEnableLoopback(spiREG1,Analog_Lbk);
  //printf("SPI is setup in loopback mode (Analog)\n");
  /* Initiate SPI2 Transmit and Receive through Interrupt Mode */
  //spiSendAndGetData(spiREG1, &dataconfig1_t, 16, TX_Data_Master,RX_Data_Master);
  //spiTransmitAndReceiveData(spiREG1, &dataconfig1_t, 16, TX_Data_Master,RX_Data_Master);
  //spiTransmitData(spiREG1, &dataconfig1_t, 16, TX_Data_Master);
  //printf("TX_Data_Master has been sent out and should be received in RX_Data_Master\n");
//  while(done==0)
//  {
//          counter++;
//  }
  gioSetBit(gioPORTA,0,0);
  for (a=0;a<10000000;a++);
  gioSetBit(gioPORTA,0,1);
  for (a=0;a<10000000;a++); 
        
  uint16 tx = 0;
  uint16 rx = 0;
  
  tx = 0x8061; // THR: 61 'a'
  spiTransmitData(spiREG1, &dataconfig1_t, 1, &tx);
  spiTransmitData(spiREG1, &dataconfig1_t, 1, &tx);
  spiTransmitData(spiREG1, &dataconfig1_t, 1, &tx);
  spiTransmitData(spiREG1, &dataconfig1_t, 1, &tx);
  spiTransmitData(spiREG1, &dataconfig1_t, 1, &tx);
#if 0  
  
  tx = 0x1F00; // id
  rx = 0;
  spiTransmitAndReceiveData(spiREG1, &dataconfig1_t, 1, &tx,&rx);
  printf("read id 0x%x\r\n", rx);
  
  
  /*
  Clock source: address=0x1E
  ClockEn=1, 
  UsePLL(PLLBypass=0), 
  PLLEN=1, 
  Use ExternalClock(CrystalEn=0), 
  disable CLKtoRTS
  */
  tx = 0x9E14; 
  spiTransmitData(spiREG1, &dataconfig1_t, 1, &tx);
  printf("write clock source 0x%x\r\n", tx);
  
  /* PLLConfig: address=0x1A
  external source=3.6864MHz
  target baudrate about 11MHz
  PLLFactor = 2
  PreDiv = 4
  */
  tx = 0x9A84; 
  spiTransmitData(spiREG1, &dataconfig1_t, 1, &tx);
  printf("write PLLConfig 0x%x\r\n", tx);  
  
  /* BRGConfig: address=0x1B
  2xMode=1, 8 multi sample
  FRACT = 0
  */
  tx = 0x9B10; 
  spiTransmitData(spiREG1, &dataconfig1_t, 1, &tx);
  printf("write BRGConfig 0x%x\r\n", tx);
  
  /* DIVLSB: address=0x1C
  Div[7:0]=1 11.0592Mbps
  */
  tx = 0x9C01; 
  spiTransmitData(spiREG1, &dataconfig1_t, 1, &tx);
  printf("write DIVLSB 0x%x\r\n", tx);
  
  tx = 0x0200; // ISR 
  rx = 0;
  spiTransmitAndReceiveData(spiREG1, &dataconfig1_t, 1, &tx,&rx);
  printf("read ISR 0x%x\r\n", rx);
  
  tx = 0x0400; // LSR
  rx = 0;
  spiTransmitAndReceiveData(spiREG1, &dataconfig1_t, 1, &tx,&rx);
  printf("read LSR 0x%x\r\n", rx); 
 
  tx = 0x8A00; // MODE2
  spiTransmitData(spiREG1, &dataconfig1_t, 1, &tx);
  printf("write MODE2 0x%x\r\n", tx);
  
  tx = 0x8B03; // LCR: 8 N 1
  spiTransmitData(spiREG1, &dataconfig1_t, 1, &tx);
  printf("write LCR 0x%x\r\n", tx);

  tx = 0x8913; // MODE1 - enable Tx and enable Rx, enable TrnscvCtrl
  spiTransmitData(spiREG1, &dataconfig1_t, 1, &tx);
  printf("write MODE1 0x%x\r\n", tx);
  
#if 0
  tx = 0x0B00;
  spiTransmitAndReceiveData(spiREG1, &dataconfig1_t, 1, &tx, &rx);
  printf("read LCR 0x%x\r\n", rx);
  
  tx = 0x8B80 | rx;    // LCR set RTS bit7 high
  spiTransmitData(spiREG1, &dataconfig1_t, 1, &tx);
  printf("write LCR 0x%x\r\n", tx);
#endif
  for (a=0;a<10;a++)
  {
    tx = 0x8061; // THR: 61 'a'
    spiTransmitAndReceiveData(spiREG1, &dataconfig1_t, 1, &tx, &rx);
    //printf("THR 0x%x\r\n", tx);
  }
#if 0 
  tx = 0x0B00;
  spiTransmitAndReceiveData(spiREG1, &dataconfig1_t, 1, &tx, &rx);
  printf("read LCR 0x%x\r\n", rx);
   
  tx = 0x8B00 | (rx & ~0x80);    // LCR set RTS bit7 low
  spiTransmitData(spiREG1, &dataconfig1_t, 1, &tx);
  printf("write LCR 0x%x\r\n", tx);
  
#endif
#if 1  
  tx = 0x8910; // MODE1 - enable Tx and Rx
  spiTransmitData(spiREG1, &dataconfig1_t, 1, &tx);
  printf("write MODE1 0x%x\r\n", tx);  
#endif  
  
#endif
  while(1);
}