/** @file HL_sys_main.c 
*   @brief Application main file
*   @date 02-Mar-2016
*   @version 04.05.02
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2016 Texas Instruments Incorporated - www.ti.com  
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "HL_sys_common.h"

/* USER CODE BEGIN (1) */
#include "HL_mibspi.h"
#include "HL_sys_dma.h"

/* example data Pattern configuration */
#define D_SIZE      128

void loadDataPattern(uint32 psize, uint16* pptr);
void mibspiEnableInternalLoopback(mibspiBASE_t *mibspi);
void dmaConfigCtrlPacket(uint32 sadd,uint32 dadd,uint32 dsize);
void mibspiDmaConfig(mibspiBASE_t *mibspi,uint32 channel, uint32 txchannel, uint32 rxchannel);

#pragma SET_DATA_SECTION(".sharedRAM")
uint16 TXDATA[D_SIZE];         /* transmit buffer in sys ram */
uint16 RXDATA[D_SIZE]= {0};    /* receive  buffer in sys ram */
#pragma SET_DATA_SECTION()

g_dmaCTRL g_dmaCTRLPKT1, g_dmaCTRLPKT2;    /* dma control packet configuration stack */
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
/* USER CODE END */

void main(void)
{
/* USER CODE BEGIN (3) */

   /* - creating a data chunk in system ram to start with ... */
   loadDataPattern(D_SIZE,&TXDATA[0]);

   /* - initializing mibspi - enabling tg 0 , length 127 (halcogen file)*/
   mibspiInit();

   /* - enabling loopback ( this is to emulate data transfer without external wires */
   mibspiEnableInternalLoopback(mibspiREG1);

   /* - configuring dma control packets   */
   g_dmaCTRLPKT1.SADD      = (uint32)TXDATA;    /* source address             */
   g_dmaCTRLPKT1.DADD      = (uint32)&(mibspiRAM1->tx[0].data);    /* destination  address       */
   g_dmaCTRLPKT1.CHCTRL    = 0;                 /* channel control            */
   g_dmaCTRLPKT1.FRCNT	   = 1;                 /* frame count                */
   g_dmaCTRLPKT1.ELCNT     = D_SIZE;            /* element count              */
   g_dmaCTRLPKT1.ELDOFFSET = 4;                 /* element destination offset */
   g_dmaCTRLPKT1.ELSOFFSET = 0;		            /* element destination offset */
   g_dmaCTRLPKT1.FRDOFFSET = 0;		            /* frame destination offset   */
   g_dmaCTRLPKT1.FRSOFFSET = 0;                 /* frame destination offset   */
   g_dmaCTRLPKT1.PORTASGN  = PORTA_READ_PORTB_WRITE;
   g_dmaCTRLPKT1.RDSIZE    = ACCESS_16_BIT;	    /* read size                  */
   g_dmaCTRLPKT1.WRSIZE    = ACCESS_16_BIT; 	/* write size                 */
   g_dmaCTRLPKT1.TTYPE     = FRAME_TRANSFER ;   /* transfer type              */
   g_dmaCTRLPKT1.ADDMODERD = ADDR_INC1;         /* address mode read          */
   g_dmaCTRLPKT1.ADDMODEWR = ADDR_OFFSET;       /* address mode write         */
   g_dmaCTRLPKT1.AUTOINIT  = AUTOINIT_ON;       /* autoinit                   */

   g_dmaCTRLPKT2.SADD      = (uint32)&(mibspiRAM1->rx[0].data);    /* source address             */
   g_dmaCTRLPKT2.DADD      = (uint32)RXDATA;    /* destination  address       */
   g_dmaCTRLPKT2.CHCTRL    = 0;                 /* channel control            */
   g_dmaCTRLPKT2.FRCNT	   = 1;                 /* frame count                */
   g_dmaCTRLPKT2.ELCNT     = D_SIZE;             /* element count              */
   g_dmaCTRLPKT2.ELDOFFSET = 0;                 /* element destination offset */
   g_dmaCTRLPKT2.ELSOFFSET = 4;		            /* element destination offset */
   g_dmaCTRLPKT2.FRDOFFSET = 0;		            /* frame destination offset   */
   g_dmaCTRLPKT2.FRSOFFSET = 0;                 /* frame destination offset   */
   g_dmaCTRLPKT2.PORTASGN  = PORTB_READ_PORTA_WRITE;
   g_dmaCTRLPKT2.RDSIZE    = ACCESS_16_BIT;	    /* read size                  */
   g_dmaCTRLPKT2.WRSIZE    = ACCESS_16_BIT; 	/* write size                 */
   g_dmaCTRLPKT2.TTYPE     = FRAME_TRANSFER ;   /* transfer type              */
   g_dmaCTRLPKT2.ADDMODERD = ADDR_OFFSET;         /* address mode read          */
   g_dmaCTRLPKT2.ADDMODEWR = ADDR_INC1;       /* address mode write         */
   g_dmaCTRLPKT2.AUTOINIT  = AUTOINIT_ON;       /* autoinit                   */

   /* upto 32 control packets are supported. */

   /* - setting dma control packets */
   dmaSetCtrlPacket(DMA_CH0,g_dmaCTRLPKT2);
   dmaSetCtrlPacket(DMA_CH1,g_dmaCTRLPKT1);

   /* - setting the dma channel to trigger on h/w request */
   dmaSetChEnable(DMA_CH0, DMA_HW);
   dmaSetChEnable(DMA_CH1, DMA_HW);

   /* - configuring the mibspi dma , channel 0 , tx line -0 , rxline -1     */
   /* - refer to the device data sheet dma request source for mibspi tx/rx  */
   mibspiDmaConfig(mibspiREG1,0,0,1);

   dmaEnable();

   /* - start the mibspi transfer tg 0 */
   mibspiTransfer(mibspiREG1,0 );

   while(1); /* loop forever */

/* USER CODE END */
}

/* USER CODE BEGIN (4) */
/** void mibspiEnableLoopback(mibspiBASE_t *mibspi )
*
*   enabling internal loopback on mibspix
*/
void mibspiEnableInternalLoopback(mibspiBASE_t *mibspi )
{
	/* enabling internal loopback */
    mibspi->GCR1 |= 1U << 16U;
}

/** void mibspiDmaConfig(mibspiBASE_t *mibspi,uint32 channel, uint32 txchannel, uint32 rxchannel)
*
*   configuring mibspi dma with
*
*       channel   > mibspi dma channel number
*       txchannel > transmit channel dedicated for mibspi
*       rxchannel > receive  channel dedicated for mibspi
*/
void mibspiDmaConfig(mibspiBASE_t *mibspi,uint32 channel, uint32 txchannel, uint32 rxchannel)
{
	uint32 bufid  = D_SIZE - 1;
	uint32 icount = 0;

	/* setting transmit and receive channels */
	mibspi->DMACTRL[channel] |= (((rxchannel<<4)|txchannel) << 16);

	/* enabling transmit and receive dma */
	mibspi->DMACTRL[channel] |=  0x8000C000;

	/* setting Initial Count of DMA transfers and the buffer utilized for DMA transfer */
	mibspi->DMACTRL[channel] |=  (icount << 8) |(bufid<<24);

}


/** void loadDataPattern(uint32 psize, uint16* pptr)
*
*   loading a randam data chunk into system ram
*
*     pptr  > sys ram address
*     psize > chunkl size
*
*/
void loadDataPattern(uint32 psize, uint16* pptr)
{
	int i;
	for(i=0;i<psize;i++)
	{
		TXDATA[i] = i;
	}
 }
/* USER CODE END */
