/** @file sys_main.c 
*   @brief Application main file
*   @date 15.Mar.2012
*   @version 03.01.00
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* (c) Texas Instruments 2009-2012, All rights reserved. */

/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "sys_common.h"
#include "system.h"

/* USER CODE BEGIN (1) */
#include "mibspi.h"
/* USER CODE END */


/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
uint16_t spi_data[10];
uint16_t spi_read[10];

void delay(unsigned int);
/* USER CODE END */



void main(void)
{
/* USER CODE BEGIN (3) */
    unsigned char i;

    mibspiInit();
    mibspiEnableLoopback(mibspiREG1, Analog);
    for(i = 0; i < 10; i++)                                 /* initialize data in the array */
    {
        spi_data[i] = 0x1111 * i;
    }

    mibspiSetData(mibspiREG1, 0, spi_data);                 /* set spi1 data        */

    while(1)
    {
        mibspiTransfer(mibspiREG1, 0);                          /* start spi1 transfer  */

        while(!mibspiIsTransferComplete(mibspiREG1, 0));        /* waiting for SPI transfer to complete */

        mibspiGetData(mibspiREG1, 0, spi_read);                 /* get received data */

    }


/* USER CODE END */
}

void delay(unsigned int para)
{
    unsigned int i;
    for(i = 0; i < para; i++)
    {
        asm("NOP");
    }
}

/* USER CODE BEGIN (4) */
/* USER CODE END */
