/** @file dmm.h
*   @brief DMM Driver Definition File
*   @date 25.July.2013
*   @version 03.06.00
*   
*/

/* (c) Texas Instruments 2009-2013, All rights reserved. */


#ifndef __DMM_H__
#define __DMM_H__

#include "reg_dmm.h"

/* Configuration registers */
typedef struct dmm_config_reg
{
    uint32 CONFIG_PC0;
    uint32 CONFIG_PC1;
    uint32 CONFIG_PC3;
    uint32 CONFIG_PC6;
    uint32 CONFIG_PC7;
    uint32 CONFIG_PC8;
} dmm_config_reg_t;


#define DMM_PC3_CONFIGVALUE         0U \
                                 | (0U << 1U)\
                                 | (0U << 2U)\
                                 | (0U << 3U)\
                                 | (0U << 4U)\
                                 | (0U << 5U)\
                                 | (0U << 6U)\
                                 | (0U << 7U)\
                                 | (0U << 8U)\
                                 | (0U << 9U)\
                                 | (0U << 10U)\
                                 | (0U << 11U)\
                                 | (0U << 12U)\
                                 | (0U << 13U)\
                                 | (0U << 14U)\
                                 | (0U << 15U)\
                                 | (0U << 16U)\
                                 | (0U << 17U)\
                                 | (0U << 18U)
								 
#define DMM_PC1_CONFIGVALUE         1U \
                                 | (1U << 1U)\
                                 | (1U << 2U)\
                                 | (1U << 3U)\
                                 | (0U << 4U)\
                                 | (1U << 5U)\
                                 | (1U << 6U)\
                                 | (0U << 7U)\
                                 | (0U << 8U)\
                                 | (1U << 9U)\
                                 | (1U << 10U)\
                                 | (0U << 11U)\
                                 | (0U << 12U)\
                                 | (1U << 13U)\
                                 | (1U << 14U)\
                                 | (0U << 15U)\
                                 | (0U << 16U)\
                                 | (1U << 17U)\
                                 | (1U << 18U)

#define DMM_PC6_CONFIGVALUE         0U \
                                 | (0U << 1U)\
                                 | (0U << 2U)\
                                 | (0U << 3U)\
                                 | (0U << 4U)\
                                 | (0U << 5U)\
                                 | (0U << 6U)\
                                 | (0U << 7U)\
                                 | (0U << 8U)\
                                 | (0U << 9U)\
                                 | (0U << 10U)\
                                 | (0U << 11U)\
                                 | (0U << 12U)\
                                 | (0U << 13U)\
                                 | (0U << 14U)\
                                 | (0U << 15U)\
                                 | (0U << 16U)\
                                 | (0U << 17U)\
                                 | (0U << 18U)
								 
#define DMM_PC8_CONFIGVALUE         1U \
                                 | (1U << 1U)\
                                 | (1U << 2U)\
                                 | (1U << 3U)\
                                 | (1U << 4U)\
                                 | (1U << 5U)\
                                 | (1U << 6U)\
                                 | (1U << 7U)\
                                 | (1U << 8U)\
                                 | (1U << 9U)\
                                 | (1U << 10U)\
                                 | (1U << 11U)\
                                 | (1U << 12U)\
                                 | (1U << 13U)\
                                 | (1U << 14U)\
                                 | (1U << 15U)\
                                 | (1U << 16U)\
                                 | (1U << 17U)\
                                 | (1U << 18U)
								 
#define DMM_PC7_CONFIGVALUE         0U \
                                 | (0U << 1U)\
                                 | (0U << 2U)\
                                 | (0U << 3U)\
                                 | (0U << 4U)\
                                 | (0U << 5U)\
                                 | (0U << 6U)\
                                 | (0U << 7U)\
                                 | (0U << 8U)\
                                 | (0U << 9U)\
                                 | (0U << 10U)\
                                 | (0U << 11U)\
                                 | (0U << 12U)\
                                 | (0U << 13U)\
                                 | (0U << 14U)\
                                 | (0U << 15U)\
                                 | (0U << 16U)\
                                 | (0U << 17U)\
                                 | (0U << 18U)

#define DMM_PC0_CONFIGVALUE         1U \
                                 | (1U << 1U)\
                                 | (1U << 2U)\
                                 | (1U << 3U)\
                                 | (1U << 4U)\
                                 | (1U << 5U)\
                                 | (1U << 6U)\
                                 | (1U << 7U)\
                                 | (1U << 8U)\
                                 | (1U << 9U)\
                                 | (1U << 10U)\
                                 | (1U << 11U)\
                                 | (1U << 12U)\
                                 | (1U << 13U)\
                                 | (1U << 14U)\
                                 | (1U << 15U)\
                                 | (1U << 16U)\
                                 | (1U << 17U)\
                                 | (1U << 18U)
								 

/** 
 *  @defgroup DMM DMM
 *  @brief Data Modification Module.
 *  
 *  The DMM module provides the capability to modify data in the entire 4 GB address space of the device from an external peripheral,
 *  with minimal interruption of the application.
 *
 *	Related Files
 *   - reg_dmm.h
 *   - dmm.h
 *   - dmm.c
 *  @addtogroup DMM
 *  @{
 */
/* DMM Interface Functions */

void dmmInit(void);
void dmmGetConfigValue(dmm_config_reg_t *config_reg, config_value_type_t type);

/**@}*/
#endif
