/** @file rtp.h
*   @brief RTP Driver Definition File
*   @date 25.July.2013
*   @version 03.06.00
*   
*/

/* (c) Texas Instruments 2009-2013, All rights reserved. */


#ifndef __RTP_H__
#define __RTP_H__

#include "reg_rtp.h"


/* Configuration registers */
typedef struct rtp_config_reg
{
    uint32 CONFIG_PC0;
    uint32 CONFIG_PC1;
    uint32 CONFIG_PC3;
    uint32 CONFIG_PC6;
    uint32 CONFIG_PC7;
    uint32 CONFIG_PC8;
} rtp_config_reg_t;


#define RTP_PC3_CONFIGVALUE         0U \
                                 | (0U << 1U)\
                                 | (0U << 2U)\
                                 | (0U << 3U)\
                                 | (0U << 4U)\
                                 | (0U << 5U)\
                                 | (0U << 6U)\
                                 | (0U << 7U)\
                                 | (0U << 8U)\
                                 | (0U << 9U)\
                                 | (0U << 10U)\
                                 | (0U << 11U)\
                                 | (0U << 12U)\
                                 | (0U << 13U)\
                                 | (0U << 14U)\
                                 | (0U << 15U)\
                                 | (0U << 16U)\
                                 | (0U << 17U)\
                                 | (0U << 18U)
								 
#define RTP_PC1_CONFIGVALUE         1U \
                                 | (1U << 1U)\
                                 | (1U << 2U)\
                                 | (1U << 3U)\
                                 | (0U << 4U)\
                                 | (1U << 5U)\
                                 | (1U << 6U)\
                                 | (0U << 7U)\
                                 | (0U << 8U)\
                                 | (1U << 9U)\
                                 | (1U << 10U)\
                                 | (0U << 11U)\
                                 | (0U << 12U)\
                                 | (1U << 13U)\
                                 | (1U << 14U)\
                                 | (0U << 15U)\
                                 | (0U << 16U)\
                                 | (1U << 17U)\
                                 | (1U << 18U)

#define RTP_PC6_CONFIGVALUE         0U \
                                 | (0U << 1U)\
                                 | (0U << 2U)\
                                 | (0U << 3U)\
                                 | (0U << 4U)\
                                 | (0U << 5U)\
                                 | (0U << 6U)\
                                 | (0U << 7U)\
                                 | (0U << 8U)\
                                 | (0U << 9U)\
                                 | (0U << 10U)\
                                 | (0U << 11U)\
                                 | (0U << 12U)\
                                 | (0U << 13U)\
                                 | (0U << 14U)\
                                 | (0U << 15U)\
                                 | (0U << 16U)\
                                 | (0U << 17U)\
                                 | (0U << 18U)
								 
#define RTP_PC8_CONFIGVALUE         1U \
                                 | (1U << 1U)\
                                 | (1U << 2U)\
                                 | (1U << 3U)\
                                 | (1U << 4U)\
                                 | (1U << 5U)\
                                 | (1U << 6U)\
                                 | (1U << 7U)\
                                 | (1U << 8U)\
                                 | (1U << 9U)\
                                 | (1U << 10U)\
                                 | (1U << 11U)\
                                 | (1U << 12U)\
                                 | (1U << 13U)\
                                 | (1U << 14U)\
                                 | (1U << 15U)\
                                 | (1U << 16U)\
                                 | (1U << 17U)\
                                 | (1U << 18U)
								 
#define RTP_PC7_CONFIGVALUE         0U \
                                 | (0U << 1U)\
                                 | (0U << 2U)\
                                 | (0U << 3U)\
                                 | (0U << 4U)\
                                 | (0U << 5U)\
                                 | (0U << 6U)\
                                 | (0U << 7U)\
                                 | (0U << 8U)\
                                 | (0U << 9U)\
                                 | (0U << 10U)\
                                 | (0U << 11U)\
                                 | (0U << 12U)\
                                 | (0U << 13U)\
                                 | (0U << 14U)\
                                 | (0U << 15U)\
                                 | (0U << 16U)\
                                 | (0U << 17U)\
                                 | (0U << 18U)

#define RTP_PC0_CONFIGVALUE         1U \
                                 | (1U << 1U)\
                                 | (1U << 2U)\
                                 | (1U << 3U)\
                                 | (1U << 4U)\
                                 | (1U << 5U)\
                                 | (1U << 6U)\
                                 | (1U << 7U)\
                                 | (1U << 8U)\
                                 | (1U << 9U)\
                                 | (1U << 10U)\
                                 | (1U << 11U)\
                                 | (1U << 12U)\
                                 | (1U << 13U)\
                                 | (1U << 14U)\
                                 | (1U << 15U)\
                                 | (1U << 16U)\
                                 | (1U << 17U)\
                                 | (1U << 18U)


/** 
 *  @defgroup RTP RTP
 *  @brief RAM Trace Port.
 *  
 *  RAM Trace Port (RTP) module provides the features to datalog the RAM contents of the devices 
 *  or accesses to peripherals without program intrusion. It can trace all data write or read accesses to internal RAM.
 *
 *	Related Files
 *   - reg_rtp.h
 *   - rtp.h
 *   - rtp.c
 *  @addtogroup RTP
 *  @{
 */
 
/* RTP Interface Functions */
void rtpInit(void);
void rtpGetConfigValue(rtp_config_reg_t *config_reg, config_value_type_t type);

/**@}*/
#endif
