/** @file dcc.c 
*   @brief DCC Driver Implementation File
*   @date 25.July.2013
*   @version 03.06.00
*
*/

/* (c) Texas Instruments 2009-2013, All rights reserved. */

/* USER CODE BEGIN (0) */
/* USER CODE END */

#include "dcc.h"
#include "sys_vim.h"

/* USER CODE BEGIN (1) */
/* USER CODE END */

/** @fn void dccInit(void)
*   @brief Initializes the DCC Driver
*
*   This function initializes the DCC module.
*/
void dccInit(void)
{

/* USER CODE BEGIN (2) */
/* USER CODE END */

    /** @b initialize @b DCC1 */
       
    /** DCC1 Clock0 Counter Seed value configuration */
    dccREG1->CNT0SEED   = 39204U;
    
    /** DCC1 Clock0 Valid Counter Seed value configuration */
    dccREG1->VALID0SEED = 792U;          
    
    /** DCC1 Clock1 Counter Seed value configuration */
    dccREG1->CNT1SEED   = 495000U;

    /** DCC1 Global Control register configuration */
    dccREG1->GCTRL      = 0xAU |       /** Enable DCC1 */
                         (0xAU << 4U) | /** Error Interrupt */
                         (0x5U << 8U) | /** Single Shot mode */
                         (0xAU << 12U); /** Done Interrupt */

    /** DCC1 Clock1 Source 1 Select */
    dccREG1->CNT1CLKSRC    = (10U << 12U) |     /** DCC Enable Key */
                          DCC1_CNT1_PLL1;  /** DCC1 Clock Source 1 */
   
    dccREG1->CNT0CLKSRC    = DCC1_CNT0_OSCIN;  /** DCC1 Clock Source 0 */


    /** @b initialize @b DCC2 */

    /** DCC2 Clock0 Counter Seed value configuration */
    dccREG2->CNT0SEED   = 0U;
    
    /** DCC2 Clock0 Valid Counter Seed value configuration */
    dccREG2->VALID0SEED = 0U;          
    
    /** DCC2 Clock1 Counter Seed value configuration */
    dccREG2->CNT1SEED   = 0U;

    /** DCC2 Global Control register configuration */
    dccREG2->GCTRL      = 0xAU |       /** Enable DCC2 */
                         (0xAU << 4U) | /** Error Interrupt */
                         (0x5U << 8U) | /** Single Shot mode */
                         (0xAU << 12U); /** Done Interrupt */

    /** DCC2 Clock1 Source 1 Select */
    dccREG2->CNT1CLKSRC    = (0x5U << 12U) |     /** DCC Enable Key */
                          DCC2_CNT1_VCLK;  /** DCC2 Clock Source 1 */
   
    dccREG2->CNT0CLKSRC    = DCC2_CNT0_OSCIN;  /** DCC2 Clock Source 0 */


/* USER CODE BEGIN (3) */
/* USER CODE END */

}

/** @fn void dccSetCounter0Seed(dccBASE_t  *dcc, uint32 cnt0seed)
*   @brief Set dcc Clock source 0 counter seed value
*   @param[in] dcc Pointer to DCC module:
*              - dccREG1: DCC1 module pointer
*              - dccREG2: DCC2 module pointer
*   @param[in] cnt0seed - Clock Source 0 Counter seed value
*
*   This function sets the seed value for Clock source 0 counter.
*
*/
void dccSetCounter0Seed(dccBASE_t  *dcc, uint32 cnt0seed)
{
/* USER CODE BEGIN (4) */
/* USER CODE END */

    dcc->CNT0SEED     = cnt0seed;

/* USER CODE BEGIN (5) */
/* USER CODE END */
}

/** @fn void dccSetTolerance(dccBASE_t  *dcc, uint32 valid0seed)
*   @brief Set dcc Clock source 0 counter seed value
*   @param[in] dcc Pointer to DCC module:
*              - dccREG1: DCC1 module pointer
*              - dccREG2: DCC2 module pointer
*   @param[in] valid0seed - Clock Source 0 Counter tolerance value
*
*   This function sets the seed value for Clock source 0 tolerance or 
*    valid counter.
*
*/
void dccSetTolerance(dccBASE_t  *dcc, uint32 valid0seed)
{
/* USER CODE BEGIN (6) */
/* USER CODE END */

    dcc->VALID0SEED = valid0seed;

/* USER CODE BEGIN (7) */
/* USER CODE END */
}

/** @fn void dccSetCounter1Seed(dccBASE_t  *dcc, uint32 cnt1seed)
*   @brief Set dcc Clock source 1 counter seed value
*   @param[in] dcc Pointer to DCC module:
*              - dccREG1: DCC1 module pointer
*              - dccREG2: DCC2 module pointer
*   @param[in] cnt1seed - Clock Source 1 Counter seed value
*
*   This function sets the seed value for Clock source 1 counter.
*
*/

void dccSetCounter1Seed(dccBASE_t  *dcc, uint32 cnt1seed)
{
/* USER CODE BEGIN (8) */
/* USER CODE END */

    dcc->CNT1SEED     = cnt1seed;

/* USER CODE BEGIN (9) */
/* USER CODE END */
}

/** @fn void dccSetSeed(dccBASE_t  *dcc, uint32 cnt0seed, uint32 valid0seed, uint32 cnt1seed)
*   @brief Set dcc Clock source 0 counter seed value
*   @param[in] dcc Pointer to DCC module:
*              - dccREG1: DCC1 module pointer
*              - dccREG2: DCC2 module pointer
*   @param[in] cnt0seed        - Clock Source 0 Counter seed value.
*   @param[in] valid0seed    - Clock Source 0 Counter tolerance value.
*   @param[in] cnt1seed        - Clock Source 1 Counter seed value.
*
*   This function sets the seed value for clock source 0, clock source 1 
*    and tolerance counter.
*
*/
void dccSetSeed(dccBASE_t  *dcc, uint32 cnt0seed, uint32 valid0seed, uint32 cnt1seed)
{
/* USER CODE BEGIN (10) */
/* USER CODE END */

    dcc->CNT0SEED   = cnt0seed;
    dcc->VALID0SEED = valid0seed;
    dcc->CNT1SEED   = cnt1seed;

/* USER CODE BEGIN (11) */
/* USER CODE END */
}

/** @fn void dccSelectClockSource(dccBASE_t  *dcc, uint32 cnt0_Clock_Source, uint32 cnt1_Clock_Source)
*   @brief Set dcc counter Clock sources
*   @param[in] dcc Pointer to DCC module:
*              - dccREG1: DCC1 module pointer
*              - dccREG2: DCC2 module pointer
*   @param[in] cnt0_Clock_Source - Clock source for counter 0.
*   @param[in] cnt1_Clock_Source - Clock source for counter 1.
*
*   This function sets the dcc counter 0 and counter 1 clock sources.
*
*/
void dccSelectClockSource(dccBASE_t  *dcc, uint32 cnt0_Clock_Source, uint32 cnt1_Clock_Source)
{
/* USER CODE BEGIN (12) */
/* USER CODE END */

    dcc->CNT1CLKSRC = cnt1_Clock_Source;
    dcc->CNT0CLKSRC = cnt0_Clock_Source;

/* USER CODE BEGIN (13) */
/* USER CODE END */
}

/** @fn void dccEnable(dccBASE_t  *dcc)
*   @brief Enable dcc module to begin counting
*   @param[in] dcc Pointer to DCC module:
*              - dccREG1: DCC1 module pointer
*              - dccREG2: DCC2 module pointer
*
*   This function enables the dcc counters to begin counting.
*
*/
void dccEnable(dccBASE_t  *dcc)
{
/* USER CODE BEGIN (14) */
/* USER CODE END */
/*SAFETYMCUSW 134 S MR:12.2 <APPROVED> "Hardware status bit read check" */
    dcc->GCTRL = (dcc->GCTRL & 0xFFFFFFF0U) | 0xAU; 

/* USER CODE BEGIN (15) */
/* USER CODE END */
}

/** @fn void dccDisable(dccBASE_t  *dcc)
*   @brief Make selected dcc module to stop counting
*   @param[in] dcc Pointer to DCC module:
*              - dccREG1: DCC1 module pointer
*              - dccREG2: DCC2 module pointer
*
*   This function stops the dcc counters from counting.
*
*/
void dccDisable(dccBASE_t  *dcc)
{
/* USER CODE BEGIN (16) */
/* USER CODE END */
/*SAFETYMCUSW 134 S MR:12.2 <APPROVED> "Hardware status bit read check" */
    dcc->GCTRL = (dcc->GCTRL & 0xFFFFFFF0U) | 0x5U; 

/* USER CODE BEGIN (17) */
/* USER CODE END */
}

/** @fn uint32 dccGetErrStatus(dccBASE_t  *dcc)
*   @brief Get error status from selected dcc module
*   @param[in] dcc Pointer to DCC module:
*              - dccREG1: DCC1 module pointer
*              - dccREG2: DCC2 module pointer
*
*   @return The Error status of selected dcc module
*
*   Returns the error status of selected dcc module.
*
*/
uint32 dccGetErrStatus(dccBASE_t  *dcc)
{
/* USER CODE BEGIN (18) */
/* USER CODE END */

    return(dcc->STAT & 0x00000001U); 
}

/** @fn void dccEnableNotification(dccBASE_t  *dcc, uint32 notification)
*   @brief Enable notification of selected DCC module
*   @param[in] dcc Pointer to DCC module:
*              - dccREG1: DCC1 module pointer
*              - dccREG2: DCC2 module pointer
*   @param[in] notification Select notification of DCC module:
*              - dccNOTIFICATION_DONE:    DCC DONE notification
*              - dccNOTIFICATION_ERROR: DCC ERROR notification
*
*   This function will enable the selected notification of a DCC module.
*   It is possible to enable multiple notifications masked.
*/

void dccEnableNotification(dccBASE_t  *dcc, uint32 notification)
{
/* USER CODE BEGIN (19) */
/* USER CODE END */
/*SAFETYMCUSW 134 S MR:12.2 <APPROVED> "Hardware status bit read check" */
    dcc->GCTRL = ((dcc->GCTRL & 0xFFFF0FF0U) | notification); 

/* USER CODE BEGIN (20) */
/* USER CODE END */
}

/** @fn void dccDisableNotification(dccBASE_t  *dcc, uint32 notification)
*   @brief Disable notification of selected DCC module
*   @param[in] dcc Pointer to DCC module:
*              - dccREG1: DCC1 module pointer
*              - dccREG2: DCC2 module pointer
*   @param[in] notification Select notification of DCC module:
*              - dccNOTIFICATION_DONE:    DCC DONE notification
*              - dccNOTIFICATION_ERROR: DCC ERROR notification
*
*   This function will enable the selected notification of a DCC module.
*   It is possible to enable multiple notifications masked.
*/

void dccDisableNotification(dccBASE_t  *dcc, uint32 notification)
{
/* USER CODE BEGIN (21) */
/* USER CODE END */
/*SAFETYMCUSW 134 S MR:12.2 <APPROVED> "Hardware status bit read check" */
    dcc->GCTRL = ((dcc->GCTRL & 0xFFFF0FF0U) | ((~notification) & 0x0000F00FU)); 

/* USER CODE BEGIN (22) */
/* USER CODE END */
}

/** @fn void dcc1GetConfigValue(dcc_config_reg_t *config_reg, config_value_type_t type)
*   @brief Get the initial or current values of the configuration registers
*
*    @param[in] *config_reg: pointer to the struct to which the initial or current value of the configuration registers need to be stored
*    @param[in] type:     whether initial or current value of the configuration registers need to be stored
*                        - InitialValue: initial value of the configuration registers will be stored in the struct pointed by config_reg
*                        - CurrentValue: initial value of the configuration registers will be stored in the struct pointed by config_reg
*
*   This function will copy the initial or current value (depending on the parameter 'type') of the configuration registers to the struct pointed by config_reg
*
*/

void dcc1GetConfigValue(dcc_config_reg_t *config_reg, config_value_type_t type)
{
    if (type == InitialValue)
    {
        config_reg->CONFIG_GCTRL = DCC1_GCTRL_CONFIGVALUE;
        config_reg->CONFIG_CNT0SEED = DCC1_CNT0SEED_CONFIGVALUE;
        config_reg->CONFIG_VALID0SEED = DCC1_VALID0SEED_CONFIGVALUE;
        config_reg->CONFIG_CNT1SEED = DCC1_CNT1SEED_CONFIGVALUE;
        config_reg->CONFIG_CNT1CLKSRC = DCC1_CNT1CLKSRC_CONFIGVALUE;
        config_reg->CONFIG_CNT0CLKSRC = DCC1_CNT0CLKSRC_CONFIGVALUE;
    }
    else
    {
	/*SAFETYMCUSW 134 S MR:12.2 <APPROVED> "Hardware status bit read check" */
        config_reg->CONFIG_GCTRL = dccREG1->GCTRL;
        config_reg->CONFIG_CNT0SEED = dccREG1->CNT0SEED;
        config_reg->CONFIG_VALID0SEED = dccREG1->VALID0SEED;
        config_reg->CONFIG_CNT1SEED = dccREG1->CNT1SEED;
        config_reg->CONFIG_CNT1CLKSRC = dccREG1->CNT1CLKSRC;
        config_reg->CONFIG_CNT0CLKSRC = dccREG1->CNT0CLKSRC;
    }
}

/** @fn void dcc2GetConfigValue(rti_config_reg_t *config_reg, config_value_type_t type)
*   @brief Get the initial or current values of the configuration registers
*
*    @param[in] *config_reg: pointer to the struct to which the initial or current value of the configuration registers need to be stored
*    @param[in] type:     whether initial or current value of the configuration registers need to be stored
*                        - InitialValue: initial value of the configuration registers will be stored in the struct pointed by config_reg
*                        - CurrentValue: initial value of the configuration registers will be stored in the struct pointed by config_reg
*
*   This function will copy the initial or current value (depending on the parameter 'type') of the configuration registers to the struct pointed by config_reg
*
*/

void dcc2GetConfigValue(dcc_config_reg_t *config_reg, config_value_type_t type)
{
    if (type == InitialValue)
    {
        config_reg->CONFIG_GCTRL = DCC2_GCTRL_CONFIGVALUE;
        config_reg->CONFIG_CNT0SEED = DCC2_CNT0SEED_CONFIGVALUE;
        config_reg->CONFIG_VALID0SEED = DCC2_VALID0SEED_CONFIGVALUE;
        config_reg->CONFIG_CNT1SEED = DCC2_CNT1SEED_CONFIGVALUE;
        config_reg->CONFIG_CNT1CLKSRC = DCC2_CNT1CLKSRC_CONFIGVALUE;
        config_reg->CONFIG_CNT0CLKSRC = DCC2_CNT0CLKSRC_CONFIGVALUE;
    }
    else
    {
	/*SAFETYMCUSW 134 S MR:12.2 <APPROVED> "Hardware status bit read check" */
        config_reg->CONFIG_GCTRL = dccREG2->GCTRL;
        config_reg->CONFIG_CNT0SEED = dccREG2->CNT0SEED;
        config_reg->CONFIG_VALID0SEED = dccREG2->VALID0SEED;
        config_reg->CONFIG_CNT1SEED = dccREG2->CNT1SEED;
        config_reg->CONFIG_CNT1CLKSRC = dccREG2->CNT1CLKSRC;
        config_reg->CONFIG_CNT0CLKSRC = dccREG2->CNT0CLKSRC;
    }
}




