/** @file dmm.c 
*   @brief DMM Driver Implementation File
*   @date 25.July.2013
*   @version 03.06.00
*
*/

/* (c) Texas Instruments 2009-2013, All rights reserved. */

/* USER CODE BEGIN (0) */
/* USER CODE END */

#include "dmm.h"

/* USER CODE BEGIN (1) */
/* USER CODE END */

/** @fn void dmmInit(void)
*   @brief Initializes the DMM Driver
*
*   This function initializes the DMM module.
*/
void dmmInit(void)
{

/* USER CODE BEGIN (2) */
/* USER CODE END */

    /** @b intalise @b DMM */

    /** @b initialize @b DMM @b Port */
    dmmREG->PC3 =  0U            /* DMM SYNC */
                | (0U << 1U)     /* DMM CLK */
                | (0U << 2U)     /* DATA[0] */
                | (0U << 3U)     /* DATA[1] */
                | (0U << 4U)     /* DATA[2] */
                | (0U << 5U)     /* DATA[3] */
                | (0U << 6U)     /* DATA[4] */
                | (0U << 7U)     /* DATA[5] */
                | (0U << 8U)     /* DATA[6] */
                | (0U << 9U)     /* DATA[7] */
                | (0U << 10U)   /* DATA[8] */
                | (0U << 11U)   /* DATA[9] */
                | (0U << 12U)   /* DATA[10] */
                | (0U << 13U)   /* DATA[11] */
                | (0U << 14U)   /* DATA[12] */
                | (0U << 15U)   /* DATA[13] */
                | (0U << 16U)   /* DATA[14] */
                | (0U << 17U)   /* DATA[15] */
                | (0U << 18U);  /* DMM ENA */

    /** - DMM Port direction */
    dmmREG->PC1 =  1U             /* DMM SYNC */
                | (1U << 1U)      /* DMM CLK */
                | (1U << 2U)      /* DATA[0] */
                | (1U << 3U)      /* DATA[1] */
                | (0U << 4U)      /* DATA[2] */
                | (1U << 5U)      /* DATA[3] */
                | (1U << 6U)      /* DATA[4] */
                | (0U << 7U)      /* DATA[5] */
                | (0U << 8U)      /* DATA[6] */
                | (1U << 9U)      /* DATA[7] */
                | (1U << 10U)    /* DATA[8] */
                | (0U << 11U)    /* DATA[9] */
                | (0U << 12U)    /* DATA[10] */
                | (1U << 13U)    /* DATA[11] */
                | (1U << 14U)    /* DATA[12] */
                | (0U << 15U)    /* DATA[13] */
                | (0U << 16U)    /* DATA[14] */
                | (1U << 17U)    /* DATA[15] */
                | (1U << 18U);   /* DMM ENA */

    /** - DMM Port open drain enable */
    dmmREG->PC6 =  0U             /* DMM SYNC */
                | (0U << 1U)      /* DMM CLK */
                | (0U << 2U)      /* DATA[0] */
                | (0U << 3U)      /* DATA[1] */
                | (0U << 4U)      /* DATA[2] */
                | (0U << 5U)      /* DATA[3] */
                | (0U << 6U)      /* DATA[4] */
                | (0U << 7U)      /* DATA[5] */
                | (0U << 8U)      /* DATA[6] */
                | (0U << 9U)      /* DATA[7] */
                | (0U << 10U)    /* DATA[8] */
                | (0U << 11U)    /* DATA[9] */
                | (0U << 12U)    /* DATA[10] */
                | (0U << 13U)    /* DATA[11] */
                | (0U << 14U)    /* DATA[12] */
                | (0U << 15U)    /* DATA[13] */
                | (0U << 16U)    /* DATA[14] */
                | (0U << 17U)    /* DATA[15] */
                | (0U << 18U);   /* DMM ENA */


    /** - DMM Port pullup / pulldown selection */
    dmmREG->PC8 =  1U             /* DMM SYNC */
                | (1U << 1U)      /* DMM CLK */
                | (1U << 2U)      /* DATA[0] */
                | (1U << 3U)      /* DATA[1] */
                | (1U << 4U)      /* DATA[2] */
                | (1U << 5U)      /* DATA[3] */
                | (1U << 6U)      /* DATA[4] */
                | (1U << 7U)      /* DATA[5] */
                | (1U << 8U)      /* DATA[6] */
                | (1U << 9U)      /* DATA[7] */
                | (1U << 10U)    /* DATA[8] */
                | (1U << 11U)    /* DATA[9] */
                | (1U << 12U)    /* DATA[10] */
                | (1U << 13U)    /* DATA[11] */
                | (1U << 14U)    /* DATA[12] */
                | (1U << 15U)    /* DATA[13] */
                | (1U << 16U)    /* DATA[14] */
                | (1U << 17U)    /* DATA[15] */
                | (1U << 18U);   /* DMM ENA */


    /** - DMM Port pullup / pulldown enable*/
    dmmREG->PC7 =  0U          /* DMM SYNC */
                | (0U << 1U)   /* DMM CLK */
                | (0U << 2U)   /* DATA[0] */
                | (0U << 3U)   /* DATA[1] */
                | (0U << 4U)   /* DATA[2] */
                | (0U << 5U)   /* DATA[3] */
                | (0U << 6U)   /* DATA[4] */
                | (0U << 7U)   /* DATA[5] */
                | (0U << 8U)   /* DATA[6] */
                | (0U << 9U)   /* DATA[7] */
                | (0U << 10U) /* DATA[8] */
                | (0U << 11U) /* DATA[9] */
                | (0U << 12U) /* DATA[10] */
                | (0U << 13U) /* DATA[11] */
                | (0U << 14U) /* DATA[12] */
                | (0U << 15U) /* DATA[13] */
                | (0U << 16U) /* DATA[14] */
                | (0U << 17U) /* DATA[15] */
                | (0U << 18U);/* DMM ENA */

    /* DMM set all pins to functional */
    dmmREG->PC0 =  1U           /* DMM SYNC */
                | (1U << 1U)    /* DMM CLK */
                | (1U << 2U)    /* DATA[0] */
                | (1U << 3U)    /* DATA[1] */
                | (1U << 4U)    /* DATA[2] */
                | (1U << 5U)    /* DATA[3] */
                | (1U << 6U)    /* DATA[4] */
                | (1U << 7U)    /* DATA[5] */
                | (1U << 8U)    /* DATA[6] */
                | (1U << 9U)    /* DATA[7] */
                | (1U << 10U)  /* DATA[8] */  
                | (1U << 11U)  /* DATA[9] */  
                | (1U << 12U)  /* DATA[10] */  
                | (1U << 13U)  /* DATA[11] */  
                | (1U << 14U)  /* DATA[12] */  
                | (1U << 15U)  /* DATA[13] */  
                | (1U << 16U)  /* DATA[14] */  
                | (1U << 17U)  /* DATA[15] */  
                | (1U << 18U); /* DMM ENA */  

/* USER CODE BEGIN (3) */
/* USER CODE END */

}

/** @fn void dmmGetConfigValue(dmm_config_reg_t *config_reg, config_value_type_t type)
*   @brief Get the initial or current values of the DMM configuration registers
*
*	@param[in] *config_reg: pointer to the struct to which the initial or current 
*                           value of the configuration registers need to be stored
*	@param[in] type: 	whether initial or current value of the configuration registers need to be stored
*						- InitialValue: initial value of the configuration registers will be stored 
*                                       in the struct pointed by config_reg
*						- CurrentValue: initial value of the configuration registers will be stored 
*                                       in the struct pointed by config_reg
*
*   This function will copy the initial or current value (depending on the parameter 'type') 
*   of the configuration registers to the struct pointed by config_reg
*
*/

void dmmGetConfigValue(dmm_config_reg_t *config_reg, config_value_type_t type)
{
	if (type == InitialValue)
	{
		config_reg->CONFIG_PC0 = DMM_PC0_CONFIGVALUE;
		config_reg->CONFIG_PC1 = DMM_PC1_CONFIGVALUE;
		config_reg->CONFIG_PC3 = DMM_PC3_CONFIGVALUE;
		config_reg->CONFIG_PC6 = DMM_PC6_CONFIGVALUE;
		config_reg->CONFIG_PC7 = DMM_PC7_CONFIGVALUE;
		config_reg->CONFIG_PC8 = DMM_PC8_CONFIGVALUE;
	}
	else
	{
	/*SAFETYMCUSW 134 S MR:12.2 <APPROVED> "Register read back support" */
		config_reg->CONFIG_PC0 = dmmREG->PC0;
		config_reg->CONFIG_PC1 = dmmREG->PC1;
		config_reg->CONFIG_PC3 = dmmREG->PC3;
		config_reg->CONFIG_PC6 = dmmREG->PC6;
		config_reg->CONFIG_PC7 = dmmREG->PC7; 
		config_reg->CONFIG_PC8 = dmmREG->PC8;
	}
}
