/** @file emif.c
*   @brief emif Driver Implementation File
*   @date 25.July.2013
*   @version 03.06.00
*
*/

/* (c) Texas Instruments 2009-2013, All rights reserved. */

/* USER CODE BEGIN (0) */
/* USER CODE END */

#include "emif.h"

/* USER CODE BEGIN (1) */
/* USER CODE END */
/** @fn void emif_SDRAMInit(void)
*   @brief Initializes the emif Driver for SDRAM
*
*   This function initializes the emif driver for SDRAM (SDRAM initialization function).
*/


void emif_SDRAMInit(void)
{
/* USER CODE BEGIN (2) */
/* USER CODE END */

   uint32 buffer;

   emifREG->SDTIMR  = (0U << 27U)|
                      (0U << 24U)|
                      (0U << 23U)|
                      (0U << 20U)|
                      (0U << 19U)|
                      (0U << 16U)|
                      (0U << 12U)|
                      (0U << 8U)|
                      (0U << 7U)|
                      (0U << 4U)|
                      (0U << 3U);

 /* configure refresh rate*/
   emifREG->SDSRETR = (uint32)0U;  
   emifREG->SDRCR   = 2500U;	

/**  -general clearing of register
*    -for NM for setting 16 bit data bus
*    -cas latency
*    -BIT11_9CLOCK to allow the cl field to be written
*    -selecting the banks
*    -setting the pagesize
*/   
    emifREG->SDCR    = (0U << 31U)|                               	
                      (1U << 14U)|                               	
                      (0U << 9U)|  	
                      (1U << 8U)|                                	
                      (0U << 4U)|              	
                      (elements_256);         	
/* wait for a read to happen*/
   buffer             = *PTR;                                	
   buffer             = buffer;
   emifREG->SDRCR   = 0U;	

/* USER CODE BEGIN (3) */
/* USER CODE END */
}

/** @fn void emif_ASYNC1Init(void)
*   @brief Initializes the emif Driver for ASYNC memories
*
*   This function initializes the emif driver for Asynchronous memories like Nor and Nand Flashes,Asynchronous RAM.
*/
void emif_ASYNC1Init(void)
{
/* USER CODE BEGIN (4) */
/* USER CODE END */
    emifREG->CE2CFG = 0x00000000U;
    emifREG->CE2CFG = (0U << 31U)|
                      (0U << 30U)|
                      (15U << 26U)|
                      (63U << 20U)|
                      (7U << 17U)|
                      (15U << 13U)|
                      (63U << 7U)|
                      (7U << 4U)|
                      (0U << 2U)|
                      (emif_8_bit_port) ;
	                  
    emifREG->AWCC  = (emifREG->AWCC)|
	     			 (emif_pin_high << 29U)|
		    		 (emif_pin_low << 28U)|
			    	 (emif_wait_pin0 << 16U)|
			    	 (0U);
					
    emifREG->PMCR  = (emifREG->PMCR)|
	    			 (0U << 2U)|
		    		 (emif_4_words << 1U)|
			    	 (0U);
/* USER CODE BEGIN (5) */
/* USER CODE END */
}

/** @fn void emif_ASYNC2Init(void)
*   @brief Initializes the emif Driver for ASYNC memories
*
*   This function initializes the emif driver for Asynchronous memories like Nor and Nand Flashes,Asynchronous RAM.
*/
void emif_ASYNC2Init(void)
{
/* USER CODE BEGIN (6) */
/* USER CODE END */

    emifREG->CE3CFG = 0x00000000U;
    emifREG->CE3CFG = (0U << 31U)|
                      (0U << 30U)|
                      (15U << 26U)|
                      (63U << 20U)|
                      (7U << 17U)|
                      (15U << 13U)|
                      (63U << 7U)|
                      (7U << 4U)|
                      (0U << 2U)|
                      (emif_8_bit_port) ;
	                  
    emifREG->AWCC  = (emifREG->AWCC)|
	     			 (emif_pin_high << 29U)|
		    		 (emif_pin_low << 28U)|
			    	 (emif_wait_pin0 << 18U)|
			    	 (0U);
					
    emifREG->PMCR  = (emifREG->PMCR)|
	    			 (0U << 10U)|
		    		 (emif_4_words << 9U)|
			    	 (0U << 8U);
/* USER CODE BEGIN (7) */
/* USER CODE END */
	                  
}


/** @fn void emif_ASYNC3Init(void)
*   @brief Initializes the emif Driver for ASYNC memories
*
*   This function initializes the emif driver for Asynchronous memories like Nor and Nand Flashes,Asynchronous RAM.
*/
void emif_ASYNC3Init(void)
{
/* USER CODE BEGIN (8) */
/* USER CODE END */

    emifREG->CE4CFG = 0x00000000U;
    emifREG->CE4CFG = (0U << 31U)|
                      (0U << 30U)|
                      (15U << 26U)|
                      (63U << 20U)|
                      (7U << 17U)|
                      (15U << 13U)|
                      (63U << 7U)|
                      (7U << 4U)|
                      (0U << 2U)|
                      (emif_8_bit_port) ;
	                  
    emifREG->AWCC  = (emifREG->AWCC)|
	     			 (emif_pin_high << 29U)|
		    		 (emif_pin_low << 28U)|
			    	 (emif_wait_pin0 << 20U)|
			    	 (0U);
					
    emifREG->PMCR  = (emifREG->PMCR) |
	    			 (0U << 18U)|
		    		 (emif_4_words << 17U)|
			    	 (0U << 16U);
					 
/* USER CODE BEGIN (9) */
/* USER CODE END */
}

/* USER CODE BEGIN (10) */
/* USER CODE END */

/** @fn void emifGetConfigValue(emif_config_reg_t *config_reg, config_value_type_t type)
*   @brief Get the initial or current values of the EMIF configuration registers
*
*	@param[in] *config_reg: pointer to the struct to which the initial or current 
*                           value of the configuration registers need to be stored
*	@param[in] type: 	whether initial or current value of the configuration registers need to be stored
*						- InitialValue: initial value of the configuration registers will be stored 
*                                       in the struct pointed by config_reg
*						- CurrentValue: initial value of the configuration registers will be stored 
*                                       in the struct pointed by config_reg
*
*   This function will copy the initial or current value (depending on the parameter 'type') 
*   of the configuration registers to the struct pointed by config_reg
*
*/

void emifGetConfigValue(emif_config_reg_t *config_reg, config_value_type_t type)
{
	if (type == InitialValue)
	{
		config_reg->CONFIG_AWCC    = EMIF_AWCC_CONFIGVALUE;  
		config_reg->CONFIG_SDCR    = EMIF_SDCR_CONFIGVALUE;  
		config_reg->CONFIG_SDRCR   = EMIF_SDRCR_CONFIGVALUE;
		config_reg->CONFIG_CE2CFG  = EMIF_CE2CFG_CONFIGVALUE;
		config_reg->CONFIG_CE3CFG  = EMIF_CE3CFG_CONFIGVALUE;
		config_reg->CONFIG_CE4CFG  = EMIF_CE4CFG_CONFIGVALUE;
		config_reg->CONFIG_CE5CFG  = EMIF_CE5CFG_CONFIGVALUE;
		config_reg->CONFIG_SDTIMR  = EMIF_SDTIMR_CONFIGVALUE;
		config_reg->CONFIG_SDSRETR = EMIF_SDSRETR_CONFIGVALUE;
		config_reg->CONFIG_INTRAW  = EMIF_INTRAW_CONFIGVALUE;
		config_reg->CONFIG_INTMSK  = EMIF_INTMSK_CONFIGVALUE;
		config_reg->CONFIG_PMCR    = EMIF_PMCR_CONFIGVALUE;
	}
	else
	{
	/*SAFETYMCUSW 134 S MR:12.2 <APPROVED> "Register read back support" */
		config_reg->CONFIG_AWCC     = emifREG->AWCC;  
		config_reg->CONFIG_SDCR     = emifREG->SDCR;  
		config_reg->CONFIG_SDRCR    = emifREG->SDRCR ;
		config_reg->CONFIG_CE2CFG   = emifREG->CE2CFG;
		config_reg->CONFIG_CE3CFG   = emifREG->CE3CFG;
		config_reg->CONFIG_CE4CFG   = emifREG->CE4CFG;
		config_reg->CONFIG_CE5CFG   = emifREG->CE5CFG;
		config_reg->CONFIG_SDTIMR   = emifREG->SDTIMR;
		config_reg->CONFIG_SDSRETR  = emifREG->SDSRETR;
		config_reg->CONFIG_INTRAW   = emifREG->INTRAW;
		config_reg->CONFIG_INTMSK   = emifREG->INTMSK;
		config_reg->CONFIG_PMCR     = emifREG->PMCR;
	}
}


