/** @file mibspi.c 
*   @brief MIBSPI Driver Implementation File
*   @date 25.July.2013
*   @version 03.06.00
*
*/

/* (c) Texas Instruments 2009-2013, All rights reserved. */

/* USER CODE BEGIN (0) */
/* USER CODE END */

#include "mibspi.h"
#include "sys_vim.h"
/* USER CODE BEGIN (1) */
/* USER CODE END */

/** @fn void mibspiInit(void)
*   @brief Initializes the MIBSPI Driver
*
*   This function initializes the MIBSPI module.
*/
void mibspiInit(void)
{
sint32 i ;

/* USER CODE BEGIN (2) */
/* USER CODE END */




    /** @b initialize @b MIBSPI5 */

    /** bring MIBSPI out of reset */
    mibspiREG5->GCR0 = 1U;
    
    /** enable MIBSPI RAM Parity */
    mibspiREG5->UERRCTRL = (mibspiREG5->UERRCTRL & 0xFFFFFFF0U) | (0x00000005U);

    /** enable MIBSPI5 multibuffered mode and enable buffer RAM */
    mibspiREG5->MIBSPIE = (mibspiREG5->MIBSPIE & 0xFFFFFFFEU) | 1U;

    /** MIBSPI5 master mode and clock configuration */
    mibspiREG5->GCR1 = (mibspiREG5->GCR1 & 0xFFFFFFFCU) | ((1U << 1U)  /* CLOKMOD */
                  | 1U);  /* MASTER */

    /** MIBSPI5 enable pin configuration */
    mibspiREG5->INT0 = (mibspiREG5->INT0 & 0xFEFFFFFFU) | (0U << 24U);  /* ENABLE HIGHZ */

    /** - Delays */
    mibspiREG5->DELAY = (0U << 24U)  /* C2TDELAY */
                   | (0U << 16U)  /* T2CDELAY */
                   | (0U << 8U)  /* T2EDELAY */
                   | 0U;  /* C2EDELAY */

    /** - Data Format 0 */
    mibspiREG5->FMT0 = (0U << 24U)  /* wdelay */
                  | (0U << 23U)  /* parity Polarity */
                  | (0U << 22U)  /* parity enable */
                  | (0U << 21U)  /* wait on enable */
                  | (0U << 20U)  /* shift direction */
                  | (0U << 17U)  /* clock polarity */
                  | (0U << 16U)  /* clock phase */
                  | (99U << 8U) /* baudrate prescale */
                  | 16U;  /* data word length */

    /** - Data Format 1 */
    mibspiREG5->FMT1 = (0U << 24U)  /* wdelay */
                  | (0U << 23U)  /* parity Polarity */
                  | (0U << 22U)  /* parity enable */
                  | (0U << 21U)  /* wait on enable */
                  | (0U << 20U)  /* shift direction */
                  | (0U << 17U)  /* clock polarity */
                  | (0U << 16U)  /* clock phase */
                  | (99U << 8U) /* baudrate prescale */
                  | 16U;  /* data word length */

    /** - Data Format 2 */
    mibspiREG5->FMT2 = (0U << 24U)  /* wdelay */
                  | (0U << 23U)  /* parity Polarity */
                  | (0U << 22U)  /* parity enable */
                  | (0U << 21U)  /* wait on enable */
                  | (0U << 20U)  /* shift direction */
                  | (0U << 17U)  /* clock polarity */
                  | (0U << 16U)  /* clock phase */
                  | (99U << 8U) /* baudrate prescale */
                  | 16U;  /* data word length */

    /** - Data Format 3 */
    mibspiREG5->FMT3 = (0U << 24U)  /* wdelay */
                  | (0U << 23U)  /* parity Polarity */
                  | (0U << 22U)  /* parity enable */
                  | (0U << 21U)  /* wait on enable */
                  | (0U << 20U)  /* shift direction */
                  | (0U << 17U)  /* clock polarity */
                  | (0U << 16U)  /* clock phase */
                  | (99U << 8U) /* baudrate prescale */
                  | 16U;  /* data word length */
			  
    /** - Default Chip Select */
    mibspiREG5->DEF = (uint32)(0xFFU);
	
    /** - wait for buffer initialization complete before accessing MibSPI registers */
    /*SAFETYMCUSW 28 D MR:NA <APPROVED> "Hardware status bit read check" */
    while ((mibspiREG5->FLG & 0x01000000U) != 0U) 
    { 
    } /* Wait */

    /** - initialize transfer groups */
    mibspiREG5->TGCTRL[0U] = (1U << 30U)  /* oneshot */
                       | (0U << 29U)  /* pcurrent reset */
                       | (TRG_ALWAYS << 20U)  /* trigger event */
                       | (TRG_DISABLED << 16U)  /* trigger source */
                       | (0U << 8U);  /* start buffer */

    mibspiREG5->TGCTRL[1U] = (1U << 30U)  /* oneshot */
                       | (0U << 29U)  /* pcurrent reset */
                       | (TRG_ALWAYS << 20U)  /* trigger event */
                       | (TRG_DISABLED << 16U)  /* trigger source */
                       | (8U << 8U);  /* start buffer */

    mibspiREG5->TGCTRL[2U] = (1U << 30U)  /* oneshot */
                       | (0U << 29U)  /* pcurrent reset */
                       | (TRG_ALWAYS << 20U)  /* trigger event */
                       | (TRG_DISABLED << 16U)  /* trigger source */
                       | ((8U+0U) << 8U);  /* start buffer */

    mibspiREG5->TGCTRL[3U] = (1U << 30U)  /* oneshot */
                       | (0U << 29U)  /* pcurrent reset */
                       | (TRG_ALWAYS << 20U)  /* trigger event */
                       | (TRG_DISABLED << 16U)  /* trigger source */
                       | ((8U+0U+0U) << 8U);  /* start buffer */

    mibspiREG5->TGCTRL[4U] = (1U << 30U)  /* oneshot */
                       | (0U << 29U)  /* pcurrent reset */
                       | (TRG_ALWAYS << 20U)  /* trigger event */
                       | (TRG_DISABLED << 16U)  /* trigger source */
                       | ((8U+0U+0U+0U) << 8U);  /* start buffer */

    mibspiREG5->TGCTRL[5U] = (1U << 30U)  /* oneshot */
                       | (0U << 29U)  /* pcurrent reset */
                       | (TRG_ALWAYS << 20U)  /* trigger event */
                       | (TRG_DISABLED << 16U)  /* trigger source */
                       | ((8U+0U+0U+0U+0U) << 8U);  /* start buffer */

    mibspiREG5->TGCTRL[6U] = (1U << 30U)  /* oneshot */
                       | (0U << 29U)  /* pcurrent reset */
                       | (TRG_ALWAYS << 20U)  /* trigger event */
                       | (TRG_DISABLED << 16U)  /* trigger source */
                       | ((8U+0U+0U+0U+0U+0U) << 8U);  /* start buffer */

    mibspiREG5->TGCTRL[7U] = (1U << 30U)  /* oneshot */
                       | (0U << 29U)  /* pcurrent reset */
                       | (TRG_ALWAYS << 20U)  /* trigger event */
                       | (TRG_DISABLED << 16U)  /* trigger source */
                       | ((8U+0U+0U+0U+0U+0U+0U) << 8U);  /* start buffer */

    
    mibspiREG5->TGCTRL[8U] = (8U+0U+0U+0U+0U+0U+0U+0U) << 8U;

    mibspiREG5->LTGPEND = (mibspiREG5->LTGPEND & 0xFFFF00FFU) | (((8U+0U+0U+0U+0U+0U+0U+0U)-1U) << 8U);

    /** - initialize buffer ram */
    {   i = 0U;
        /*SAFETYMCUSW 139 S MR: 13.7 REVIEWED " If condition cannot be removed as the LHS depends on GUI configuraion " */
        if (8U > 0U)
        {
            while (i < (8U-1U))
            {
                mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                         | (0U << 12U)  /* chip select hold */
                                         | (0U << 11U)  /* lock transmission */
                                         | (0U << 8U)  /* data format */
                                         |(uint32)((~(uint32)((0xFFU) ^ CS_0) & 0xFFU));  /* chip select */
                i++;
            }
            mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                     | (0U << 12U) /* chip select hold must be zero for last buffer */
                                     | (0U << 10U)  /* enable WDELAY */
                                     | (0U << 8U)  /* data format */
                                     |(uint32)((~(uint32)((0xFFU) ^ CS_0) & 0xFFU));  /* chip select */
            i++;
        }
        /*SAFETYMCUSW 139 S MR: 13.7 REVIEWED " If condition cannot be removed as the LHS depends on GUI configuraion " */
        if (0U > 0U)
        {
            while (i < ((8U+0U)-1U))
            {
                mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                         | (0U << 12U)  /* chip select hold */
                                         | (0U << 11U)  /* lock transmission */
                                         | (0U << 8U)  /* data format */
                                         |(uint32)((~(uint32)((0xFFU) ^ CS_1) & 0xFFU));  /* chip select */
                i++;
            }
            mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                     | (0U << 12U) /* chip select hold must be zero for last buffer */
                                     | (0U << 10U)  /* enable WDELAY */
                                     | (0U << 8U)  /* data format */
                                     |(uint32)((~(uint32)((0xFFU) ^ CS_1) & 0xFFU));  /* chip select */
            i++;
        }
        /*SAFETYMCUSW 139 S MR: 13.7 REVIEWED " If condition cannot be removed as the LHS depends on GUI configuraion " */
        if (0U > 0U)
        {
            while (i < ((8U+0U+0U)-1U))
            {
                mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                         | (0U << 12U)  /* chip select hold */
                                         | (0U << 11U)  /* lock transmission */
                                         | (0U << 8U)  /* data format */
                                         |(uint32)((~(uint32)((0xFFU) ^ CS_2) & 0xFFU));  /* chip select */
                i++;
            }
            mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                     | (0U << 12U) /* chip select hold must be zero for last buffer */
                                     | (0U << 10U)  /* enable WDELAY */
                                     | (0U << 8U)  /* data format */
                                     |(uint32)((~(uint32)((0xFFU) ^ CS_2) & 0xFFU));  /* chip select */
            i++;
        }
        /*SAFETYMCUSW 139 S MR: 13.7 REVIEWED " If condition cannot be removed as the LHS depends on GUI configuraion " */
        if (0U > 0U)
        {
            while (i < ((8U+0U+0U+0U)-1U))
            {
                mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                         | (0U << 12U)  /* chip select hold */
                                         | (0U << 11U)  /* lock transmission */
                                         | (0U << 8U)  /* data format */
                                         |(uint32)((~(uint32)((0xFFU) ^ CS_3) & 0xFFU));  /* chip select */
                i++;
            }
            mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                     | (0U << 12U) /* chip select hold must be zero for last buffer */
                                     | (0U << 10U)  /* enable WDELAY */
                                     | (0U << 8U)  /* data format */
                                     |(uint32)((~(uint32)((0xFFU) ^ CS_3) & 0xFFU));  /* chip select */
            i++;
        }
        /*SAFETYMCUSW 139 S MR: 13.7 REVIEWED " If condition cannot be removed as the LHS depends on GUI configuraion " */
        if (0U > 0U)
        {
            while (i < ((8U+0U+0U+0U+0U)-1U))
            {
                mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                         | (0U << 12U)  /* chip select hold */
                                         | (0U << 11U)  /* lock transmission */
                                         | (0U << 8U)  /* data format */
                                         |(uint32)((~(uint32)((0xFFU) ^ CS_4) & 0xFFU));  /* chip select */
                i++;
            }
            mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                     | (0U << 12U) /* chip select hold must be zero for last buffer */
                                     | (0U << 10U)  /* enable WDELAY */
                                     | (0U << 8U)  /* data format */
                                     |(uint32)((~(uint32)((0xFFU) ^ CS_4) & 0xFFU));  /* chip select */
            i++;
        }
        /*SAFETYMCUSW 139 S MR: 13.7 REVIEWED " If condition cannot be removed as the LHS depends on GUI configuraion " */
        if (0U > 0U)
        {
            while (i < ((8U+0U+0U+0U+0U+0U)-1U))
            {
                mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                         | (0U << 12U)  /* chip select hold */
                                         | (0U << 11U)  /* lock transmission */
                                         | (0U << 8U)  /* data format */
                                         |(uint32)((~(uint32)((0xFFU) ^ CS_5) & 0xFFU));  /* chip select */
                i++;
            }
            mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                     | (0U << 12U) /* chip select hold must be zero for last buffer */
                                     | (0U << 10U)  /* enable WDELAY */
                                     | (0U << 8U)  /* data format */
                                     |(uint32)((~(uint32)((0xFFU) ^ CS_5) & 0xFFU));  /* chip select */
            i++;
        }
        /*SAFETYMCUSW 139 S MR: 13.7 REVIEWED " If condition cannot be removed as the LHS depends on GUI configuraion " */
        if (0U > 0U)
        {
            while (i < ((8U+0U+0U+0U+0U+0U+0U)-1U))
            {
                mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                         | (0U << 12U)  /* chip select hold */
                                         | (0U << 11U)  /* lock transmission */
                                         | (0U << 8U)  /* data format */
                                         |(uint32)((~(uint32)((0xFFU) ^ CS_6) & 0xFFU));  /* chip select */
                i++;
            }
            mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                     | (0U << 12U) /* chip select hold must be zero for last buffer */
                                     | (0U << 10U)  /* enable WDELAY */
                                     | (0U << 8U)  /* data format */
                                     |(uint32)((~(uint32)((0xFFU) ^ CS_6) & 0xFFU));  /* chip select */
            i++;
        }
        /*SAFETYMCUSW 139 S MR: 13.7 REVIEWED " If condition cannot be removed as the LHS depends on GUI configuraion " */
        if (0U > 0U)
        {
            while (i < ((8U+0U+0U+0U+0U+0U+0U+0U)-1U))
            {
                mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                         | (0U << 12U)  /* chip select hold */
                                         | (0U << 11U)  /* lock transmission */
                                         | (0U << 8U)  /* data format */
                                         |(uint32)((~(uint32)((0xFFU) ^ CS_7) & 0xFFU));  /* chip select */
                i++;
            }
            mibspiRAM5->tx[i].control = (4U << 13U)  /* buffer mode */
                                     | (0U << 12U) /* chip select hold must be zero for last buffer */
                                     | (0U << 10U)  /* enable WDELAY */
                                     | (0U << 8U)  /* data format */
                                     |(uint32)((~(uint32)((0xFFU) ^ CS_7) & 0xFFU));  /* chip select */
            i++;
        }
    }

    /** - set interrupt levels */
    mibspiREG5->LVL = (0U << 9U)  /* TXINT */
                 | (0U << 8U)  /* RXINT */
                 | (0U << 6U)  /* OVRNINT */
                 | (0U << 4U)  /* BITERR */
                 | (0U << 3U)  /* DESYNC */
                 | (0U << 2U)  /* PARERR */
                 | (0U << 1U) /* TIMEOUT */
                 | (0U);  /* DLENERR */

    /** - clear any pending interrupts */
    mibspiREG5->FLG |= 0xFFFFU;

    /** - enable interrupts */
    mibspiREG5->INT0 = (mibspiREG5->INT0 & 0xFFFF0000U) 
                  | (0U << 9U)  /* TXINT */
                  | (0U << 8U)  /* RXINT */
                  | (0U << 6U)  /* OVRNINT */
                  | (0U << 4U)  /* BITERR */
                  | (0U << 3U)  /* DESYNC */
                  | (0U << 2U)  /* PARERR */
                  | (0U << 1U) /* TIMEOUT */
                  | (0U);  /* DLENERR */

    /** @b initialize @b MIBSPI5 @b Port */

    /** - MIBSPI5 Port output values */
    mibspiREG5->PC3 =  1U        /* SCS[0] */
                    | (1U << 1U)  /* SCS[1] */
                    | (1U << 2U)  /* SCS[2] */
                    | (1U << 3U)  /* SCS[3] */
                    | (0U << 8U)  /* ENA */
                    | (0U << 9U)  /* CLK */
                    | (0U << 10U)  /* SIMO */
                    | (0U << 19U)
                    | (0U << 25U) 
                    | (0U << 26U) 
                    | (0U << 27U)
                    | (0U << 17U)  
                    | (0U << 18U)
                    | (0U << 11U); /* SOMI */

    /** - MIBSPI5 Port direction */
    mibspiREG5->PC1  =  1U        /* SCS[0] */
                    | (1U << 1U)  /* SCS[1] */
                    | (1U << 2U)  /* SCS[2] */
                    | (1U << 3U)  /* SCS[3] */
                    | (0U << 8U)  /* ENA */
                    | (1U << 9U)  /* CLK */
                    | (1U << 10U)  /* SIMO */
                    | (0U << 19U)
                    | (0U << 25U) 
                    | (0U << 26U) 
                    | (0U << 27U)
                    | (0U << 17U)  
                    | (0U << 18U)
                    | (0U << 11U); /* SOMI */

    /** - MIBSPI5 Port open drain enable */
    mibspiREG5->PC6  =  0U        /* SCS[0] */
                    | (0U << 1U)  /* SCS[1] */
                    | (0U << 2U)  /* SCS[2] */
                    | (0U << 3U)  /* SCS[3] */
                    | (0U << 8U)  /* ENA */
                    | (0U << 9U)  /* CLK */
                    | (0U << 10U)  /* SIMO */
                    | (0U << 19U)
                    | (0U << 25U) 
                    | (0U << 26U) 
                    | (0U << 27U)
                    | (0U << 17U)  
                    | (0U << 18U)
                    | (0U << 11U); /* SOMI */

    /** - MIBSPI5 Port pullup / pulldown selection */
    mibspiREG5->PC8  =  1U        /* SCS[0] */
                    | (1U << 1U)  /* SCS[1] */
                    | (1U << 2U)  /* SCS[2] */
                    | (1U << 3U)  /* SCS[3] */
                    | (1U << 8U)  /* ENA */
                    | (1U << 9U)  /* CLK */
                    | (1U << 10U)  /* SIMO */
                    | (1U << 19U)
                    | (1U << 25U) 
                    | (1U << 26U) 
                    | (1U << 27U)
                    | (1U << 17U)  
                    | (1U << 18U)
                    | (1U << 11U); /* SOMI */

    /** - MIBSPI5 Port pullup / pulldown enable*/
    mibspiREG5->PC7  =  0U        /* SCS[0] */
                    | (0U << 1U)  /* SCS[1] */
                    | (0U << 2U)  /* SCS[2] */
                    | (0U << 3U)  /* SCS[3] */
                    | (0U << 8U)  /* ENA */
                    | (0U << 9U)  /* CLK */
                    | (0U << 10U)  /* SIMO */
                    | (0U << 19U)
                    | (0U << 25U) 
                    | (0U << 26U) 
                    | (0U << 27U)
                    | (0U << 17U)  
                    | (0U << 18U)
                    | (0U << 11U); /* SOMI */

    /* MIBSPI5 set all pins to functional */
    mibspiREG5->PC0  =  1U        /* SCS[0] */
                    | (1U << 1U)  /* SCS[1] */
                    | (1U << 2U)  /* SCS[2] */
                    | (1U << 3U)  /* SCS[3] */
                    | (1U << 8U)  /* ENA */
                    | (1U << 9U)  /* CLK */
                    | (1U << 10U)  /* SIMO */
                    | (1U << 19U)
                    | (1U << 25U) 
                    | (1U << 26U) 
                    | (1U << 27U)
                    | (1U << 17U)  
                    | (1U << 18U)
                    | (1U << 11U); /* SOMI */
       


  /** - Finally start MIBSPI5 */
    mibspiREG5->GCR1 = (mibspiREG5->GCR1 & 0xFEFFFFFFU) | (1U << 24U);

/* USER CODE BEGIN (3) */
/* USER CODE END */

}


/** @fn void mibspiSetFunctional(mibspiBASE_t *mibspi, uint32 port)
*   @brief Change functional behavior of pins at runtime.
*   @param[in] mibspi   - mibspi module base address
*   @param[in] port  - Value to write to PC0 register
*
*   Change the value of the PC0 register at runtime, this allows to
*   dynamically change the functionality of the MIBSPI pins between functional
*   and GIO mode.
*/
void mibspiSetFunctional(mibspiBASE_t *mibspi, uint32 port)
{
/* USER CODE BEGIN (4) */
/* USER CODE END */

    mibspi->PC0 = port;

/* USER CODE BEGIN (5) */
/* USER CODE END */
}


/** @fn void mibspiSetData(mibspiBASE_t *mibspi, uint32 group, uint16 * data)
*   @brief Set Buffer Data
*   @param[in] mibspi   - Spi module base address
*   @param[in] group - Transfer group (0..7)
*   @param[in] data  - new data for transfer group
*
*   This function updates the data for the specified transfer group,
*   the length of the data must match the length of the transfer group.
*/
void mibspiSetData(mibspiBASE_t *mibspi, uint32 group, uint16 * data)
{
/* USER CODE BEGIN (6) */
/* USER CODE END */

    mibspiRAM_t *ram    = mibspi == mibspiREG1 ? mibspiRAM1 : (mibspi == mibspiREG3 ? mibspiRAM3 : mibspiRAM5);
    uint32 start  = (mibspi->TGCTRL[group] >> 8U) & 0xFFU;
    uint32 end    = group == 7U ? (((mibspi->LTGPEND & 0x00007F00U) >> 8U) + 1U) : ((mibspi->TGCTRL[group+1U] >> 8U) & 0xFFU);

    if (end < start) {end = 128U;}

    while (start < end)
    {
    /*SAFETYMCUSW 45 D MR:21.1 <APPROVED> "Valid non NULL input parameters are only allowed in this driver" */
        ram->tx[start].data = *data;
        data++;
        start++;
    }
/* USER CODE BEGIN (7) */
/* USER CODE END */
}


/** @fn void mibspiGetData(mibspiBASE_t *mibspi, uint32 group, uint16 * data)
*   @brief Retrieves Buffer Data from receive buffer
*   @param[in]  mibspi   - Spi module base address
*   @param[in]  group - Transfer group (0..7)
*   @param[out] data  - pointer to data array
*
*   @return error flags from data buffer, if there was a receive error on
*           one of the buffers this will be reflected in the return value.
*
*   This function transfers the data from the specified transfer group receive
*   buffers to the data array,  the length of the data must match the length 
*   of the transfer group.
*/
uint32 mibspiGetData(mibspiBASE_t *mibspi, uint32 group, uint16 * data)
{
/* USER CODE BEGIN (8) */
/* USER CODE END */

    mibspiRAM_t *ram    = mibspi == mibspiREG1 ? mibspiRAM1 : (mibspi == mibspiREG3 ? mibspiRAM3 : mibspiRAM5);
    uint32 start  = (mibspi->TGCTRL[group] >> 8U) & 0xFFU;
    uint32 end    = group == 7U ? (((mibspi->LTGPEND & 0x00007F00U) >> 8U) + 1U) : ((mibspi->TGCTRL[group+1U] >> 8U) & 0xFFU);
    uint32 mibspiFlags  = 0U;

    if (end < start) {end = 128U;}

    while (start < end)
    {
        mibspiFlags  |= ram->rx[start].flags;
        /*SAFETYMCUSW 45 D MR:21.1 <APPROVED> "Valid non NULL input parameters are only allowed in this driver" */
        *data = ram->rx[start].data;
        data++;
        start++;
    }

/* USER CODE BEGIN (9) */
/* USER CODE END */

    return (mibspiFlags >> 8U) & 0x5FU;
}


/** @fn void mibspiTransfer(mibspiBASE_t *mibspi, uint32 group)
*   @brief Transmit Transfer Group
*   @param[in] mibspi   - Spi module base address
*   @param[in] group - Transfer group (0..7)
*
*   Initiates a transfer for the specified transfer group.
*/
void mibspiTransfer(mibspiBASE_t *mibspi, uint32 group)
{
/* USER CODE BEGIN (10) */
/* USER CODE END */

    mibspi->TGCTRL[group] |= 0x80000000U;

/* USER CODE BEGIN (11) */
/* USER CODE END */
}


/** @fn boolean mibspiIsTransferComplete(mibspiBASE_t *mibspi, uint32 group)
*   @brief Check for Transfer Group Ready
*   @param[in] mibspi   - Spi module base address
*   @param[in] group - Transfer group (0..7)
*
*   @return TRUE is transfer complete, otherwise FALSE.
*
*   Checks to see if the transfer for the specified transfer group
*   has finished.
*/
boolean mibspiIsTransferComplete(mibspiBASE_t *mibspi, uint32 group)
{
    boolean status;

/* USER CODE BEGIN (12) */
/* USER CODE END */

    if(((((mibspi->TGINTFLG & 0xFFFF0000U) >> 16U)>> group) & 1U) == 1U)
    {
       mibspi->TGINTFLG = (mibspi->TGINTFLG & 0x0000FFFFU) | (( 1U << group ) << 16U);
       status = TRUE;
    }
    else
    {
       status = FALSE;
    }
    
/* USER CODE BEGIN (13) */
/* USER CODE END */
    
    return (status);
}


/** @fn void mibspiEnableLoopback(mibspiBASE_t *mibspi, loopBackType_t Loopbacktype)
*   @brief Enable Loopback mode for self test
*   @param[in] mibspi        - Mibspi module base address
*   @param[in] Loopbacktype  - Digital or Analog
*
*   This function enables the Loopback mode for self test.
*/
void mibspiEnableLoopback(mibspiBASE_t *mibspi, loopBackType_t Loopbacktype)
{
/* USER CODE BEGIN (14) */
/* USER CODE END */
    
    /* Clear Loopback incase enabled already */
    mibspi->IOLPKTSTCR = 0U;
    
    /* Enable Loopback either in Analog or Digital Mode */
    mibspi->IOLPKTSTCR = 0x00000A00U
                       | (Loopbacktype << 1U);
    
/* USER CODE BEGIN (15) */
/* USER CODE END */
}

/** @fn void mibspiDisableLoopback(mibspiBASE_t *mibspi)
*   @brief Enable Loopback mode for self test
*   @param[in] mibspi        - Mibspi module base address
*
*   This function disable the Loopback mode.
*/
void mibspiDisableLoopback(mibspiBASE_t *mibspi)
{
/* USER CODE BEGIN (16) */
/* USER CODE END */
    
    /* Disable Loopback Mode */
    mibspi->IOLPKTSTCR = 0x00000500U;
    
/* USER CODE BEGIN (17) */
/* USER CODE END */
}

/** @fn void mibspiPmodeSet(mibspiBASE_t *mibspi, mibspiPmode_t Pmode, mibspiDFMT_t DFMT)
*   @brief Set the Pmode for the selected Data Format register
*   @param[in] mibspi   - Mibspi module base address
*   @param[in] Pmode    - Mibspi Parellel mode
*                            PMODE_NORMAL    
*                            PMODE_2_DATALINE
*                            PMODE_4_DATALINE
*                            PMODE_8_DATALINE
*   @param[in] DFMT     - Mibspi Data Format register
*                            DATA_FORMAT0
*                            DATA_FORMAT1
*                            DATA_FORMAT2
*                            DATA_FORMAT3
*
*   This function sets the Pmode for the selected Data Format register.
*/
void mibspiPmodeSet(mibspiBASE_t *mibspi, mibspiPmode_t Pmode, mibspiDFMT_t DFMT)
{
    uint32 pmctrl_reg;
    /* Set the Pmode for the selected Data Format register */
    pmctrl_reg     = (mibspi->PMCTRL & (uint32)(~(0xFFU << (8U * DFMT))));
    mibspi->PMCTRL = (pmctrl_reg | (uint32)(Pmode <<  ((8U * DFMT))));
    
}

/** @fn void mibspiEnableGroupNotification(mibspiBASE_t *mibspi, uint32 group, uint32 level)
*   @brief Enable Transfer Group interrupt
*   @param[in] mibspi   - Spi module base address
*   @param[in] group - Transfer group (0..7)
*   @param[in] level - Interrupt level
*
*   This function enables the transfer group finished interrupt.
*/
void mibspiEnableGroupNotification(mibspiBASE_t *mibspi, uint32 group, uint32 level)
{
/* USER CODE BEGIN (18) */
/* USER CODE END */

    if (level != 0U)
    {
        mibspi->TGITLVST = (mibspi->TGITLVST & 0x0000FFFFU) | ((1U << group) << 16U);
    }
    else
    {
        mibspi->TGITLVCR = (mibspi->TGITLVCR & 0x0000FFFFU) | ((1U << group) << 16U);
    }
    mibspi->TGITENST = (mibspi->TGITENST & 0x0000FFFFU) | ((1U << group) << 16U);

/* USER CODE BEGIN (19) */
/* USER CODE END */
}


/** @fn void mibspiDisableGroupNotification(mibspiBASE_t *mibspi, uint32 group)
*   @brief Disable Transfer Group interrupt
*   @param[in] mibspi   - Spi module base address
*   @param[in] group - Transfer group (0..7)
*
*   This function disables the transfer group finished interrupt.
*/
void mibspiDisableGroupNotification(mibspiBASE_t *mibspi, uint32 group)
{
/* USER CODE BEGIN (20) */
/* USER CODE END */

    mibspi->TGITENCR = (mibspi->TGITENCR & 0x0000FFFFU) | ((1U << group) << 16U);

/* USER CODE BEGIN (21) */
/* USER CODE END */
}



/** @fn void mibspi5GetConfigValue(mibspi_config_reg_t *config_reg, config_value_type_t type)
*   @brief Get the initial or current values of the configuration registers
*
*    @param[in] *config_reg: pointer to the struct to which the initial or current 
*                           value of the configuration registers need to be stored
*    @param[in] type:     whether initial or current value of the configuration registers need to be stored
*                        - InitialValue: initial value of the configuration registers will be stored 
*                                       in the struct pointed by config_reg
*                        - CurrentValue: initial value of the configuration registers will be stored 
*                                       in the struct pointed by config_reg
*
*   This function will copy the initial or current value (depending on the parameter 'type') 
*   of the configuration registers to the struct pointed by config_reg
*
*/
void mibspi5GetConfigValue(mibspi_config_reg_t *config_reg, config_value_type_t type)
{
    if (type == InitialValue)
    {
        config_reg->CONFIG_GCR1       = MIBSPI5_GCR1_CONFIGVALUE; 
        config_reg->CONFIG_INT0       = MIBSPI5_INT0_CONFIGVALUE; 
        config_reg->CONFIG_LVL        = MIBSPI5_LVL_CONFIGVALUE; 
        config_reg->CONFIG_PCFUN      = MIBSPI5_PCFUN_CONFIGVALUE; 
        config_reg->CONFIG_PCDIR      = MIBSPI5_PCDIR_CONFIGVALUE; 
        config_reg->CONFIG_PCPDR      = MIBSPI5_PCPDR_CONFIGVALUE; 
        config_reg->CONFIG_PCDIS      = MIBSPI5_PCDIS_CONFIGVALUE; 
        config_reg->CONFIG_PCPSL      = MIBSPI5_PCPSL_CONFIGVALUE; 
        config_reg->CONFIG_DELAY      = MIBSPI5_DELAY_CONFIGVALUE; 
        config_reg->CONFIG_FMT0       = MIBSPI5_FMT0_CONFIGVALUE; 
        config_reg->CONFIG_FMT1       = MIBSPI5_FMT1_CONFIGVALUE; 
        config_reg->CONFIG_FMT2       = MIBSPI5_FMT2_CONFIGVALUE; 
        config_reg->CONFIG_FMT3       = MIBSPI5_FMT3_CONFIGVALUE; 
        config_reg->CONFIG_MIBSPIE    = MIBSPI5_MIBSPIE_CONFIGVALUE; 
        config_reg->CONFIG_LTGPEND    = MIBSPI5_LTGPEND_CONFIGVALUE; 
        config_reg->CONFIG_TGCTRL[0U] = MIBSPI5_TGCTRL0_CONFIGVALUE;
        config_reg->CONFIG_TGCTRL[1U] = MIBSPI5_TGCTRL1_CONFIGVALUE;
        config_reg->CONFIG_TGCTRL[2U] = MIBSPI5_TGCTRL2_CONFIGVALUE;
        config_reg->CONFIG_TGCTRL[3U] = MIBSPI5_TGCTRL3_CONFIGVALUE;
        config_reg->CONFIG_TGCTRL[4U] = MIBSPI5_TGCTRL4_CONFIGVALUE;
        config_reg->CONFIG_TGCTRL[5U] = MIBSPI5_TGCTRL5_CONFIGVALUE;
        config_reg->CONFIG_TGCTRL[6U] = MIBSPI5_TGCTRL6_CONFIGVALUE;
        config_reg->CONFIG_TGCTRL[7U] = MIBSPI5_TGCTRL7_CONFIGVALUE;
        config_reg->CONFIG_UERRCTRL   = MIBSPI5_UERRCTRL_CONFIGVALUE; 
    }
    else
    {
    /*SAFETYMCUSW 134 S MR:12.2 <APPROVED> "Register read back support" */
        config_reg->CONFIG_GCR1       = mibspiREG5->GCR1;
        config_reg->CONFIG_INT0       = mibspiREG5->INT0;
        config_reg->CONFIG_LVL        = mibspiREG5->LVL;
        config_reg->CONFIG_PCFUN      = mibspiREG5->PC0;
        config_reg->CONFIG_PCDIR      = mibspiREG5->PC1;
        config_reg->CONFIG_PCPDR      = mibspiREG5->PC6;
        config_reg->CONFIG_PCDIS      = mibspiREG5->PC7;
        config_reg->CONFIG_PCPSL      = mibspiREG5->PC8;
        config_reg->CONFIG_DELAY      = mibspiREG5->DELAY;
        config_reg->CONFIG_FMT0       = mibspiREG5->FMT0;
        config_reg->CONFIG_FMT1       = mibspiREG5->FMT1;
        config_reg->CONFIG_FMT2       = mibspiREG5->FMT2;
        config_reg->CONFIG_FMT3       = mibspiREG5->FMT3;
        config_reg->CONFIG_MIBSPIE    = mibspiREG5->MIBSPIE;
        config_reg->CONFIG_LTGPEND    = mibspiREG5->LTGPEND;
        config_reg->CONFIG_TGCTRL[0U] = mibspiREG5->TGCTRL[0U];
        config_reg->CONFIG_TGCTRL[1U] = mibspiREG5->TGCTRL[1U];
        config_reg->CONFIG_TGCTRL[2U] = mibspiREG5->TGCTRL[2U];
        config_reg->CONFIG_TGCTRL[3U] = mibspiREG5->TGCTRL[3U];
        config_reg->CONFIG_TGCTRL[4U] = mibspiREG5->TGCTRL[4U];
        config_reg->CONFIG_TGCTRL[5U] = mibspiREG5->TGCTRL[5U];
        config_reg->CONFIG_TGCTRL[6U] = mibspiREG5->TGCTRL[6U];
        config_reg->CONFIG_TGCTRL[7U] = mibspiREG5->TGCTRL[7U];
        config_reg->CONFIG_UERRCTRL   = mibspiREG5->UERRCTRL;
    }
}





