/** @file rtp.c
*   @brief RTP Driver Implementation File
*   @date 25.July.2013
*   @version 03.06.00
*
*/

/* (c) Texas Instruments 2009-2013, All rights reserved. */

/* USER CODE BEGIN (0) */
/* USER CODE END */

#include "rtp.h"

/* USER CODE BEGIN (1) */
/* USER CODE END */

/** @fn void rtpInit(void)
*   @brief Initializes the RTP Driver
*
*   This function initializes the RTP module.
*/
void rtpInit(void)
{

/* USER CODE BEGIN (2) */
/* USER CODE END */

    /** @b intalise @b RTP */

    /** @b initialize @b RTP @b Port */

    /** - RTP Port output values */
    rtpREG->PC3 =  0U            /* DATA[0] */
                | (0U << 1U)     /* DATA[1] */
                | (0U << 2U)     /* DATA[2] */
                | (0U << 3U)     /* DATA[3] */
                | (0U << 4U)     /* DATA[4] */
                | (0U << 5U)     /* DATA[5] */
                | (0U << 6U)     /* DATA[6] */
                | (0U << 7U)     /* DATA[7] */
                | (0U << 8U)     /* DATA[8] */
                | (0U << 9U)     /* DATA[9] */
                | (0U << 10U)   /* DATA[10] */
                | (0U << 11U)   /* DATA[11] */
                | (0U << 12U)   /* DATA[12] */
                | (0U << 13U)   /* DATA[13] */
                | (0U << 14U)   /* DATA[14] */
                | (0U << 15U)   /* DATA[15] */
                | (0U << 16U)   /* RTP SYNC */
                | (0U << 17U)   /* RTP CLK */
                | (0U << 18U);  /* RTP ENA */

    /** - RTP Port direction */
    rtpREG->PC1 =  1U             /* DATA[0] */
                | (1U << 1U)      /* DATA[1] */
                | (1U << 2U)      /* DATA[2] */
                | (1U << 3U)      /* DATA[3] */
                | (0U << 4U)      /* DATA[4] */
                | (1U << 5U)      /* DATA[5] */
                | (1U << 6U)      /* DATA[6] */
                | (0U << 7U)      /* DATA[7] */
                | (0U << 8U)      /* DATA[8] */
                | (1U << 9U)      /* DATA[9] */
                | (1U << 10U)    /* DATA[10] */
                | (0U << 11U)    /* DATA[11] */
                | (0U << 12U)    /* DATA[12] */
                | (1U << 13U)    /* DATA[13] */
                | (1U << 14U)    /* DATA[14] */
                | (0U << 15U)    /* DATA[15] */
                | (0U << 16U)    /* RTP SYNC */
                | (1U << 17U)    /* RTP CLK */
                | (1U << 18U);   /* RTP ENA */

    /** - RTP Port open drain enable */
    rtpREG->PC6 =  0U             /* DATA[0] */
                | (0U << 1U)      /* DATA[1] */
                | (0U << 2U)      /* DATA[2] */
                | (0U << 3U)      /* DATA[3] */
                | (0U << 4U)      /* DATA[4] */
                | (0U << 5U)      /* DATA[5] */
                | (0U << 6U)      /* DATA[6] */
                | (0U << 7U)      /* DATA[7] */
                | (0U << 8U)      /* DATA[8] */
                | (0U << 9U)      /* DATA[9] */
                | (0U << 10U)    /* DATA[10] */
                | (0U << 11U)    /* DATA[11] */
                | (0U << 12U)    /* DATA[12] */
                | (0U << 13U)    /* DATA[13] */
                | (0U << 14U)    /* DATA[14] */
                | (0U << 15U)    /* DATA[15] */
                | (0U << 16U)    /* RTP SYNC */
                | (0U << 17U)    /* RTP CLK */
                | (0U << 18U);   /* RTP ENA */


    /** - RTP Port pullup / pulldown selection */
    rtpREG->PC8 =  1U             /* DATA[0] */
                | (1U << 1U)      /* DATA[1] */
                | (1U << 2U)      /* DATA[2] */
                | (1U << 3U)      /* DATA[3] */
                | (1U << 4U)      /* DATA[4] */
                | (1U << 5U)      /* DATA[5] */
                | (1U << 6U)      /* DATA[6] */
                | (1U << 7U)      /* DATA[7] */
                | (1U << 8U)      /* DATA[8] */
                | (1U << 9U)      /* DATA[9] */
                | (1U << 10U)    /* DATA[10] */
                | (1U << 11U)    /* DATA[11] */
                | (1U << 12U)    /* DATA[12] */
                | (1U << 13U)    /* DATA[13] */
                | (1U << 14U)    /* DATA[14] */
                | (1U << 15U)    /* DATA[15] */
                | (1U << 16U)    /* RTP SYNC */
                | (1U << 17U)    /* RTP CLK */
                | (1U << 18U);   /* RTP ENA */


    /** - RTP Port pullup / pulldown enable*/
    rtpREG->PC7 =  0U            /* DATA[0] */
                | (0U << 1U)     /* DATA[1] */
                | (0U << 2U)     /* DATA[2] */
                | (0U << 3U)     /* DATA[3] */
                | (0U << 4U)     /* DATA[4] */
                | (0U << 5U)     /* DATA[5] */
                | (0U << 6U)     /* DATA[6] */
                | (0U << 7U)     /* DATA[7] */
                | (0U << 8U)     /* DATA[8] */
                | (0U << 9U)     /* DATA[9] */
                | (0U << 10U)   /* DATA[10] */
                | (0U << 11U)   /* DATA[11] */
                | (0U << 12U)   /* DATA[12] */
                | (0U << 13U)   /* DATA[13] */
                | (0U << 14U)   /* DATA[14] */
                | (0U << 15U)   /* DATA[15] */
                | (0U << 16U)   /* RTP SYNC */
                | (0U << 17U)   /* RTP CLK */
                | (0U << 18U);  /* RTP ENA */

    /* RTP set all pins to functional */
    rtpREG->PC0 =  1U             /* DATA[0] */
                | (1U << 1U)      /* DATA[1] */
                | (1U << 2U)      /* DATA[2] */
                | (1U << 3U)      /* DATA[3] */
                | (1U << 4U)      /* DATA[4] */
                | (1U << 5U)      /* DATA[5] */
                | (1U << 6U)      /* DATA[6] */
                | (1U << 7U)      /* DATA[7] */
                | (1U << 8U)      /* DATA[8] */
                | (1U << 9U)      /* DATA[9] */
                | (1U << 10U)    /* DATA[10] */
                | (1U << 11U)    /* DATA[11] */
                | (1U << 12U)    /* DATA[12] */
                | (1U << 13U)    /* DATA[13] */
                | (1U << 14U)    /* DATA[14] */
                | (1U << 15U)    /* DATA[15] */
                | (1U << 16U)    /* RTP SYNC */
                | (1U << 17U)    /* RTP CLK */
                | (1U << 18U);   /* RTP ENA */

/* USER CODE BEGIN (3) */
/* USER CODE END */

}


/** @fn void rtpGetConfigValue(rtp_config_reg_t *config_reg, config_value_type_t type)
*   @brief Get the initial or current values of the RTP configuration registers
*
*	@param[in] *config_reg: pointer to the struct to which the initial or current 
*                           value of the configuration registers need to be stored
*	@param[in] type: 	whether initial or current value of the configuration registers need to be stored
*						- InitialValue: initial value of the configuration registers will be stored 
*                                       in the struct pointed by config_reg
*						- CurrentValue: initial value of the configuration registers will be stored 
*                                       in the struct pointed by config_reg
*
*   This function will copy the initial or current value (depending on the parameter 'type') 
*   of the configuration registers to the struct pointed by config_reg
*
*/

void rtpGetConfigValue(rtp_config_reg_t *config_reg, config_value_type_t type)
{
	if (type == InitialValue)
	{
		config_reg->CONFIG_PC0 = RTP_PC0_CONFIGVALUE;
		config_reg->CONFIG_PC1 = RTP_PC1_CONFIGVALUE;
		config_reg->CONFIG_PC3 = RTP_PC3_CONFIGVALUE;
		config_reg->CONFIG_PC6 = RTP_PC6_CONFIGVALUE;
		config_reg->CONFIG_PC7 = RTP_PC7_CONFIGVALUE;
		config_reg->CONFIG_PC8 = RTP_PC8_CONFIGVALUE;
	}
	else
	{
	/*SAFETYMCUSW 134 S MR:12.2 <APPROVED> "Register read back support" */
		config_reg->CONFIG_PC0 = rtpREG->PC0;
		config_reg->CONFIG_PC1 = rtpREG->PC1;
		config_reg->CONFIG_PC3 = rtpREG->PC3;
		config_reg->CONFIG_PC6 = rtpREG->PC6;
		config_reg->CONFIG_PC7 = rtpREG->PC7; 
		config_reg->CONFIG_PC8 = rtpREG->PC8;
	}
}

 
