/*----------------------------------------------------------------------------*/
/* sys_link.cmd                                                               */
/*                                                                            */
/* (c) Texas Instruments 2009-2013, All rights reserved.                      */
/*                                                                            */
/*----------------------------------------------------------------------------*/
define memory mem with size = 4G;

define region VECTORS = mem:[from 0x00000000 size 0x00000020];
define region FLASH   = mem:[from 0x00000020 size 0x0013FFE0];
define region STACK   = mem:[from 0x08000000 size 0x00001500];
define region RAM     = mem:[from 0x08001500 size 0x0002EB00];
define block HEAP with size = 0x800, alignment = 8{ };

initialize by copy {readwrite};
do not initialize  {section .noinit};

place in VECTORS {readonly section .intvecs};
place in FLASH   {readonly};
place in RAM     {readwrite};
place in RAM     {block HEAP};
/*----------------------------------------------------------------------------*/
