/*******************************************************************
 *
 *    DESCRIPTION: FlexRay configuration and Initialization of buffers
 *
 *    Changes History:
 *    1. V1.1: AAROR, 12/05/2011
 *    2. V1.2: QJ Wang, 4/4/2012, updated the project for 5 nodes
 *
 *******************************************************************/


#include "Fr.h"
	wrhs Fr_LPdu;
	cfg Fr_Config;
	bc Fr_LSdu1;
	bc Fr_LSdu2;

void configure_initialize_node_c(FRAY_ST *Fray_PST)
{
	wrhs *Fr_LPduPtr=&Fr_LPdu;
	cfg *Fr_ConfigPtr=&Fr_Config;
	bc *Fr_LSduPtr=&Fr_LSdu1;

	// GTUs, PRTC configuration
	// PRTC1[15:14] (BRP), Baud rate prescaler. These bits configure the baud rate on the FlexRay bus. The baud rates listed below are valid with a sample clock of 80 MHz. One bit
	// time always consists of 8 samples independent of the configured baud rate.
	// BRP=0h: 10 MBit/s (Sample Clock Period = 12.5ns; 1 T = 25ns; Samples per T = 2)
	// BRP=1h: 5 MBit/s (Sample Clock Period = 25ns; 1 T = 25ns; Samples per T = 1)
	// BRP=2h or 3h: 2.5 MBit/s (Sample Clock Period = 50ns; 1 T = 50ns; Samples per T = 1)

	Fr_ConfigPtr->gtu1  = 0x00036B00; // UT[19:0], pMicroPerCycle = 224000d = 36B00h; Microtick per communication cycle (in microticks).
                                      // so 1 communication cycle is 5.6ms (224000*25ns)

	Fr_ConfigPtr->gtu2  = 0x000F15E0; // SNM[19:16], gSyncodeMax = Fh;  Sync node max (in frames).
	                                  // MPC[13:0], gMacroPerCycle = 5600d = 15E0h; Macrotick per communication cycle (in macroticks).
	                                  // So, 1 Macrotick = 40 microticks = 1uS. (224000/5600)

	Fr_ConfigPtr->gtu3  = 0x00061818; // MIOA[22:16], gMacroInitialOffset = 6h, Macrotick initial offset channel A (in macroticks).
	                                  // UIOA[7:0],   pMicroInitialOffset = 24d = 18h, Microtick initial offset channel A (in microticks).


	Fr_ConfigPtr->gtu4  = 0x0AE40AE3; // OCS[29:16], gOffsetCorrectionStart - 1 = 2788d = AE4h, Offset correction start (in macroticks).
	                                  // NIT[13:0],  gMacroPerCycle - gdNIT - 1 = 2787d = AE3h, Network idle time start (in macroticks).
                                      // For this FlexRay module the offset correction start is required to be GTUC4.OCS >= GTUC4.NIT + 1 = k+1
                                      // symbol window length=GTUC4.NIT-(static L+Dynamic L+dynamic offset-1)
	                                  //                     =2787-(86*8+346*4+4-2-1)=714 macroticks
	                                  // NIT length = m+1-k = GTUC2.MPC+1-k=5600+1-2787=2815 macroticks

	Fr_ConfigPtr->gtu5  = 0x33010303; // DEC[31:24], pDecodingCorrection = 51d = 33h, Decoding correction (in microticks).
	                                  // CDD[20:16], pClusterDriftDamping = 1h, Cluster drift damping (in microticks).
	                                  // DCA[7:0],   pDelayCompensation = 3h, Delay compensation channel A (in microticks).


	Fr_ConfigPtr->gtu6  = 0x01510081; // MOD[26:16], pdMaxDrift = 337d = 151h, Maximum oscillator drift (in microticks). Maximum drift offset between two nodes
	                                  // ASR[10:0],pdAcceptedStartupRange = 129d = 81h, Accepted startup range (in microticks). Number of microticks

	/*Static segments */
	Fr_ConfigPtr->gtu7  = 0x00080056; // NSS[25:16], gNumberOfStaticSlots = 8h (in macroticks); These bits configure the number of static slots in a cycle
	                                  // SSL[9:0],   gdStaticSlot = 86d = 56h (in macroticks); These bits configure the duration of a static slot.
	                                  // Static segment length = 86 * 8 = 688 macroticks
	/*Dynamic segments */
	Fr_ConfigPtr->gtu8  = 0x02B80004; // NMS[28:16], gNumberOfMinislots = 346d = 15Ah; Number of minislots in the dynamic segment of a cycle.
	                                  // MSL[5:0],   gdMinislot = 4h;  Minislot length (in macroticks).
	                                  // Dynamic segment length = 346 * 4 = 1384 macroticks

    /* Action piont for Static, Dynamic and symbol window */
	Fr_ConfigPtr->gtu9  = 0x00010204; // DSI[17:16}, gdDynamicSlotIdlePhase = 1; Dynamic slot idle phase (in minislots).
	                                  // MAPO[12:8], gdMinislotActionPointOffset = 2; Minislot action point offset (in macroticks).
	                                  // APO[5:0],   gdActionPointOffset = 4h; Action point offset (in macroticks)
	                                  // dynamic segment offset is ActionPointOffset - MinislotActionPointOffset
    /*Clock Synchronization */
	Fr_ConfigPtr->gtu10 = 0x015100CD; // MRC[26:16], pRateCorrectionOut = 337d = 151h, Maximum rate correction (in microticks).
	                                  // MOC[13:0],  pOffsetCorrectionOut = 205d = CDh, Maximum offset correction (in microticks).

	Fr_ConfigPtr->gtu11 = 0x00000000; // pExternRateCorrection = 0, pExternOffsetCorrection = 0, no ext. clk. corr.

	Fr_ConfigPtr->succ2 = 0x0F036DA2; // gListenNoise = Fh, pdListenTimeout = 224674d = 36DA2h

	Fr_ConfigPtr->succ3 = 0x000000FF; // gMaxWithoutClockCorrectionFatal = Fh , passive = Fh

	//
	Fr_ConfigPtr->prtc1 = 0x084C000A; // pWakeupPattern = 2h, gdWakeupSymbolRxWindow = 76d,
	                                  // BRP[15:14], Baud rate prescaler. BRP = 0: 10 MBit/s (Sample Clock Period = 12.5ns; 1 T = 25ns; Samples per T = 2)
	                                  // TSST(3-0), gdTSSTransmitter = Ah; These bits configure the duration of the transmission start sequence (TSS) in terms of bit times
	                                  // (1	bit time = 4uT = 100ns @ 10Mbps).

	Fr_ConfigPtr->prtc2 = 0x3CB41212; // gdWakeupSymbolTxLow = 60d, gdWakeupSymbolTxIdle = 180d, gdWakeupSymbolRxLow = 18d, gdWakeupSymbolRxIdle = 18d

	Fr_ConfigPtr->mhdc  = 0x01590009; // SLT(12-0), pLatestTransmit = 269d = 010Dh; Start of latest transmit (in minislots).
	                                  // These bits configure the maximum minislot value allowed before inhibiting new frame transmissions in the
	                                  // Dynamic Segment of the cycle. There is no transmission in dynamic segment if SLT(12-0) is set to zero.
	                                  // SFDL(6-0), gPayloadLengthStatic = 9h; Static frame data length in double bytes.

	Fr_ConfigPtr->mrc   = 0x00174008; // LCB=0x17=23d: Last config buffer,# of msg buffer=0x17+1=24.  >=80h, no message buffer configured; The maximum number of message buffers is 128
	                                  // FFB=64d: First buffer of FIFO; 64 buffers are assigned to FIFO.  >80h, No message buffer assigned to the FIFO
	                                  // FDB=4d (0..3..7 static, 8..23 dyn., 0 fifo); First dynamic buffer, 0~(4-1) for static segment



	// Wait for PBSY bit to clear - POC not busy
	while(((Fray_PST->SUCC1_UN.SUCC1_UL) & 0x00000080) != 0);
	
	// Initialize
	Fr_Init(Fray_PST, Fr_ConfigPtr);

	// Buffer config initialization 
	Fr_LPduPtr->mbi  = 1;   // message buffer interrupt
	Fr_LPduPtr->txm  = 0;   // transmission mode - continuous mode
	Fr_LPduPtr->ppit = 0;   // network management Enable
	Fr_LPduPtr->cfg  = 0;   // message buffer configuration bit (0=RX, 1 = TX)
	Fr_LPduPtr->chb  = 1;   // Ch B
	Fr_LPduPtr->cha  = 1;   // Ch A
	Fr_LPduPtr->cyc  = 0;   // Cycle Filtering Code (no cycle filtering)
	Fr_LPduPtr->fid  = 0;   // Frame ID
	Fr_LPduPtr->pl   = 0;   // Payload Length
	Fr_LPduPtr->dp   = 0;   // Pointer to start of data in message RAM
	Fr_LPduPtr->sfi  = 0;   // startup frame indicator
	Fr_LPduPtr->sync = 0;   // sync frame indicator

	Fr_LSduPtr->ibrh = 0;  // input buffer number
	Fr_LSduPtr->stxrh= 0;  // set transmission request
	Fr_LSduPtr->ldsh = 0;  // load data section
	Fr_LSduPtr->lhsh = 0;  // load header section
	Fr_LSduPtr->ibsyh = 1; // check for input buffer busy shadow
	Fr_LSduPtr->ibsys = 1; // check for input buffer busy host
	Fr_LSduPtr->obrs = 0;  // output buffer number
	Fr_LSduPtr->rdss = 0;  // read data section
	Fr_LSduPtr->rhss = 0;  // read header section


	// Message buffers

	// Buffer #0, Node C
	Fr_LPduPtr->fid  = 3;    // frame ID, Node C
	Fr_LPduPtr->dp   = 0x80; // Pointer to start of data in message RAM
	Fr_LPduPtr->cfg  = 1;    // TX frame
	Fr_LPduPtr->sync = 1;    // sync frame indicator
	Fr_LPduPtr->sfi  = 1;    // startup frame indicator
	Fr_LPduPtr->pl   = 9;	 // 18 byte payload
	Fr_LPduPtr->crc  = header_crc_calc(Fr_LPduPtr);

	Fr_LSduPtr->lhsh = 1;  // load header section
	Fr_LSduPtr->ibrh = 0;  // input buffer number

	Fr_PrepareLPdu(Fray_PST, Fr_LPduPtr);
	Fr_TransmitTxLPdu(Fray_PST, Fr_LSduPtr);

	// Buffer #1,  receive from node A
	Fr_LPduPtr->fid  = 1;    // frame ID
	Fr_LPduPtr->dp   = 0x85; // Pointer to start of data in message RAM
	Fr_LPduPtr->cfg  = 0;    // RX frame
	Fr_LPduPtr->sync = 0;    // sync frame indicator
	Fr_LPduPtr->sfi  = 0;    // startup frame indicator
	Fr_LPduPtr->crc  = 0;

	Fr_LSduPtr->ibrh = 1;  // input buffer number

	Fr_PrepareLPdu(Fray_PST, Fr_LPduPtr);
	Fr_TransmitTxLPdu(Fray_PST, Fr_LSduPtr);

	// Buffer #2, Node B
	Fr_LPduPtr->fid  = 2;    // frame ID,  receive from node B
	Fr_LPduPtr->dp   = 0x8A; // Pointer to start of data in message RAM
	Fr_LPduPtr->cfg  = 0;    // RX frame
	Fr_LPduPtr->sync = 0;    // sync frame indicator
	Fr_LPduPtr->sfi  = 0;    // startup frame indicator
	Fr_LPduPtr->crc  = 0;

	Fr_LSduPtr->ibrh = 2;  // input buffer number

	Fr_PrepareLPdu(Fray_PST, Fr_LPduPtr);
	Fr_TransmitTxLPdu(Fray_PST, Fr_LSduPtr);

	// Buffer #3, Node D
	Fr_LPduPtr->fid  = 4;    // frame ID of Node D
	Fr_LPduPtr->dp   = 0x8F; // Pointer to start of data in message RAM
	Fr_LPduPtr->cfg  = 0;    // RX frame
	Fr_LPduPtr->sync = 0;    // sync frame indicator
	Fr_LPduPtr->sfi  = 0;    // startup frame indicator
	Fr_LPduPtr->crc  = 0;

	Fr_LSduPtr->ibrh = 3;  // input buffer number

	Fr_PrepareLPdu(Fray_PST, Fr_LPduPtr);
	Fr_TransmitTxLPdu(Fray_PST, Fr_LSduPtr);

	// Buffer #5, Node E
	Fr_LPduPtr->fid  = 5;    // frame ID of Node E
	Fr_LPduPtr->dp   = 0x94; // Pointer to start of data in message RAM
	Fr_LPduPtr->cfg  = 0;    // RX frame
	Fr_LPduPtr->sync = 0;    // sync frame indicator
	Fr_LPduPtr->sfi  = 0;    // startup frame indicator
	Fr_LPduPtr->crc  = 0;

	Fr_LSduPtr->ibrh = 4;  // input buffer number

	Fr_PrepareLPdu(Fray_PST, Fr_LPduPtr);
	Fr_TransmitTxLPdu(Fray_PST, Fr_LSduPtr);


    // buffer #8, node C
	Fr_LPduPtr->fid  = 12;   // frame ID, Node C
	Fr_LPduPtr->dp   = 0x200; // Pointer to start of data in message RAM
	Fr_LPduPtr->cfg  = 1;    // TX frame
	Fr_LPduPtr->chb  = 0;    // No transmission on Ch B
	Fr_LPduPtr->pl   = 127;	 // 254 byte payload
	Fr_LPduPtr->crc  = header_crc_calc(Fr_LPduPtr);

	Fr_LSduPtr->ibrh = 10;  // input buffer number

	Fr_PrepareLPdu(Fray_PST, Fr_LPduPtr);
	Fr_TransmitTxLPdu(Fray_PST, Fr_LSduPtr);

	// buffer #9,  receive from node A
	Fr_LPduPtr->fid  = 10;     // frame ID
	Fr_LPduPtr->dp   = 0x240; // Pointer to start of data in message RAM
	Fr_LPduPtr->cfg  = 0;    // RX frame
	Fr_LPduPtr->crc  = 0;

	Fr_LSduPtr->ibrh = 11;  // input buffer number

	Fr_PrepareLPdu(Fray_PST, Fr_LPduPtr);
	Fr_TransmitTxLPdu(Fray_PST, Fr_LSduPtr);

	// buffer #10, receive from node B
	Fr_LPduPtr->fid  = 11;    // frame ID
	Fr_LPduPtr->dp   = 0x280; // Pointer to start of data in message RAM
	Fr_LPduPtr->cfg  = 0;    // RX frame
	Fr_LPduPtr->crc  = 0;

	Fr_LSduPtr->ibrh = 12;  // input buffer number

	Fr_PrepareLPdu(Fray_PST, Fr_LPduPtr);
	Fr_TransmitTxLPdu(Fray_PST, Fr_LSduPtr);

	// buffer #11, Node D
	Fr_LPduPtr->fid  = 13;     // frame ID of Node D
	Fr_LPduPtr->dp   = 0x2C0; // Pointer to start of data in message RAM
	Fr_LPduPtr->cfg  = 0;    // RX frame
	Fr_LPduPtr->crc  = 0;

	Fr_LSduPtr->ibrh = 13;  // input buffer number

	Fr_PrepareLPdu(Fray_PST, Fr_LPduPtr);
	Fr_TransmitTxLPdu(Fray_PST, Fr_LSduPtr);

	// buffer #12, Node E
	Fr_LPduPtr->fid  = 14;     // frame ID of Node E
	Fr_LPduPtr->dp   = 0x300; // Pointer to start of data in message RAM
	Fr_LPduPtr->cfg  = 0;    // RX frame
	Fr_LPduPtr->crc  = 0;

	Fr_LSduPtr->ibrh = 14;  // input buffer number

	Fr_PrepareLPdu(Fray_PST, Fr_LPduPtr);
	Fr_TransmitTxLPdu(Fray_PST, Fr_LSduPtr);

	Fr_ControllerInit(Fray_PST);
	// Initialize Interrupts
	Fray_PST->EIR_UN.EIR_UL       = 0xFFFFFFFF; // Clear Error Int.
	Fray_PST->SIR_UN.SIR_UL       = 0xFFFFFFFF; // Clear Status Int.
	Fray_PST->SILS_UN.SILS_UL     = 0x00000000; // all Status Int. to eray_int0
	Fray_PST->SIER_UN.SIER_UL     = 0xFFFFFFFF; // Disable all Status Int.
	Fray_PST->SIES_UN.SIES_UL     = 0x00000004; // Enable CYCSE Int.
	Fray_PST->ILE_UN.ILE_UL       = 0x00000002; // enable eray_int1

	Fr_AllowColdStart(Fray_PST);
}
	

int transmit_check_node_c(FRAY_ST *Fray_PST)
{
	bc *write_buffer=&Fr_LSdu1;
	bc *read_buffer=&Fr_LSdu2;
	unsigned int  ndat1;
	int error=0;
	write_buffer->ibrh = 0;  // input buffer number
	write_buffer->stxrh= 1;  // set transmission request
	write_buffer->ldsh = 1;  // load data section
	write_buffer->lhsh = 0;  // load header section
	write_buffer->ibsys = 0; // check for input buffer busy shadow
	write_buffer->ibsyh = 1; // check for input buffer busy host

    // wait for cycle start interrupt flag
    Fray_PST->SIR_UN.SIR_UL = 0xFFFFFFFF;            // clear all status int. flags
    while ((Fray_PST->SIR_UN.SIR_UL & 0x4) == 0x0);    // wait for CYCS interrupt flag
    Fray_PST->SIR_UN.SIR_UL = 0xFFFFFFFF;            // clear all status int. flags

	// write payload for buffers
	// buffer #0
	(Fray_PST->WRDS[0] = 0x0000001C);    // Data 1
    (Fray_PST->WRDS[1] = 0x000000CC);    // Data 2
	Fr_TransmitTxLPdu(Fray_PST, write_buffer);

	// buffer #8
	write_buffer->ibrh = 10;
	(Fray_PST->WRDS[0] = 0xFF);    		 // Data 1
    (Fray_PST->WRDS[1] = 0xFFFF);   	 // Data 2
	(Fray_PST->WRDS[2] = 0xFFFFFF);      // Data 3
    (Fray_PST->WRDS[3] = 0xFFFFFFFF);    // Data 4
	(Fray_PST->WRDS[4] = 0xFFFFFF00);    // Data 5
    (Fray_PST->WRDS[5] = 0xFFFF0000);    // Data 6
	Fr_TransmitTxLPdu(Fray_PST, write_buffer);

	 // check received frames
    ndat1 = Fray_PST->NDAT1_UN.NDAT1_UL;

    // check if a message is received in buffer 2 from node B
    if ((ndat1 & 0x4) != 0)
    {
      read_buffer->obrs=2;  // output buffer number
	  read_buffer->rdss=1;  // read data section
	  read_buffer->rhss=0;  // read header section
      // Transfer message buffer 1 data to output buffer registers
      Fr_ReceiveRxLPdu(Fray_PST, read_buffer);
      if (Fray_PST->RDDS[1] != 0x87654321) error++; 
	}
	return error;
}

