#include "configure.h"

//*****************************************************************************
//
// Configure the UART and its pins.  This must be called before UARTprintf().
//
//*****************************************************************************
void
ConfigureUART(void)
{
    //
    // Enable the GPIO Peripheral used by the UART.
    //
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);

    //
    // Enable UART0
    //
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);

    //
    // Configure GPIO Pins for UART mode.
    //
    GPIOPinConfigure(GPIO_PA0_U0RX);
    GPIOPinConfigure(GPIO_PA1_U0TX);
    GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);

    //
    // Use the internal 16MHz oscillator as the UART clock source.
    //
    UARTClockSourceSet(UART0_BASE, UART_CLOCK_PIOSC);

    //
    // Initialize the UART for console I/O.
    //
    UARTStdioConfig(0, 115200, 16000000);
}

void ConfigureGPIO(void){

    //
    // Enable the GPIO port that is used for the on-board LED.
    //
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);

    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOD);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);

    //
    // Enable the GPIO pins for the LED (PF1 & PF2 & PF3).
    //
    GPIOPinTypeGPIOOutput(GPIO_PORTF_BASE, GPIO_PIN_1 | GPIO_PIN_2 | GPIO_PIN_3);

    //Enable the GPIO pins for the OLED (PD3 & PE1 & PE2 & PE3).
    GPIOPinTypeGPIOOutput(GPIO_PORTD_BASE, GPIO_PIN_3);
    GPIOPinTypeGPIOOutput(GPIO_PORTE_BASE, GPIO_PIN_1 | GPIO_PIN_2 | GPIO_PIN_3);


}

void ConfigureTIMERs(void){
	   //
	    // Enable the peripherals used by this example.
	    //
	    SysCtlPeripheralEnable(SYSCTL_PERIPH_TIMER0);
	    SysCtlPeripheralEnable(SYSCTL_PERIPH_TIMER1);

	    //
	    // Enable processor interrupts.
	    //
	    IntMasterEnable();

	    //
	    // Configure the two 32-bit periodic timers.
	    //
	    TimerConfigure(TIMER0_BASE, TIMER_CFG_PERIODIC);
	    TimerConfigure(TIMER1_BASE, TIMER_CFG_PERIODIC);
	    TimerLoadSet(TIMER0_BASE, TIMER_A, SysCtlClockGet());
	    TimerLoadSet(TIMER1_BASE, TIMER_A, SysCtlClockGet() / 2);

	    //
	    // Setup the interrupts for the timer timeouts.
	    //
	    IntEnable(INT_TIMER0A);
	    IntEnable(INT_TIMER1A);
	    TimerIntEnable(TIMER0_BASE, TIMER_TIMA_TIMEOUT);
	    TimerIntEnable(TIMER1_BASE, TIMER_TIMA_TIMEOUT);

	    //
	    // Enable the timers.
	    //
	    TimerEnable(TIMER0_BASE, TIMER_A);
	    TimerEnable(TIMER1_BASE, TIMER_A);
}

void ConfigureADCs(void){

    SysCtlPeripheralEnable(SYSCTL_PERIPH_ADC0);
    ADCSequenceConfigure(ADC0_BASE, 1, ADC_TRIGGER_PROCESSOR, 0);
    ADCSequenceStepConfigure(ADC0_BASE, 1, 0, ADC_CTL_TS);
    ADCSequenceStepConfigure(ADC0_BASE, 1, 1, ADC_CTL_TS);
    ADCSequenceStepConfigure(ADC0_BASE, 1, 2, ADC_CTL_TS);
    ADCSequenceStepConfigure(ADC0_BASE, 1, 3, ADC_CTL_TS|ADC_CTL_IE|ADC_CTL_END);
    ADCSequenceEnable(ADC0_BASE, 1);

}



