#include "oled.h"

const unsigned char  F6x8[][6] =
{
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },   // sp -0
    { 0x00, 0x00, 0x00, 0x2f, 0x00, 0x00 },   // !
    { 0x00, 0x00, 0x07, 0x00, 0x07, 0x00 },   // "
    { 0x00, 0x14, 0x7f, 0x14, 0x7f, 0x14 },   // #
    { 0x00, 0x24, 0x2a, 0x7f, 0x2a, 0x12 },   // $
    { 0x00, 0x62, 0x64, 0x08, 0x13, 0x23 },   // %
    { 0x00, 0x36, 0x49, 0x55, 0x22, 0x50 },   // &
    { 0x00, 0x00, 0x05, 0x03, 0x00, 0x00 },   // '
    { 0x00, 0x00, 0x1c, 0x22, 0x41, 0x00 },   // (
    { 0x00, 0x00, 0x41, 0x22, 0x1c, 0x00 },   // )
    { 0x00, 0x14, 0x08, 0x3E, 0x08, 0x14 },   // * -10
    { 0x00, 0x08, 0x08, 0x3E, 0x08, 0x08 },   // +
    { 0x00, 0x00, 0x00, 0xA0, 0x60, 0x00 },   // ,
    { 0x00, 0x08, 0x08, 0x08, 0x08, 0x08 },   // -
    { 0x00, 0x00, 0x60, 0x60, 0x00, 0x00 },   // .
    { 0x00, 0x20, 0x10, 0x08, 0x04, 0x02 },   // /
    { 0x00, 0x3E, 0x51, 0x49, 0x45, 0x3E },   // 0 -16
    { 0x00, 0x00, 0x42, 0x7F, 0x40, 0x00 },   // 1
    { 0x00, 0x42, 0x61, 0x51, 0x49, 0x46 },   // 2
    { 0x00, 0x21, 0x41, 0x45, 0x4B, 0x31 },   // 3
    { 0x00, 0x18, 0x14, 0x12, 0x7F, 0x10 },   // 4 -20
    { 0x00, 0x27, 0x45, 0x45, 0x45, 0x39 },   // 5
    { 0x00, 0x3C, 0x4A, 0x49, 0x49, 0x30 },   // 6
    { 0x00, 0x01, 0x71, 0x09, 0x05, 0x03 },   // 7
    { 0x00, 0x36, 0x49, 0x49, 0x49, 0x36 },   // 8
    { 0x00, 0x06, 0x49, 0x49, 0x29, 0x1E },   // 9
    { 0x00, 0x00, 0x36, 0x36, 0x00, 0x00 },   // :
    { 0x00, 0x00, 0x56, 0x36, 0x00, 0x00 },   // ;
    { 0x00, 0x08, 0x14, 0x22, 0x41, 0x00 },   // <
    { 0x00, 0x14, 0x14, 0x14, 0x14, 0x14 },   // =
    { 0x00, 0x00, 0x41, 0x22, 0x14, 0x08 },   // > -30
    { 0x00, 0x02, 0x01, 0x51, 0x09, 0x06 },   // ?
    { 0x00, 0x32, 0x49, 0x59, 0x51, 0x3E },   // @
    { 0x00, 0x7C, 0x12, 0x11, 0x12, 0x7C },   // A
    { 0x00, 0x7F, 0x49, 0x49, 0x49, 0x36 },   // B
    { 0x00, 0x3E, 0x41, 0x41, 0x41, 0x22 },   // C
    { 0x00, 0x7F, 0x41, 0x41, 0x22, 0x1C },   // D
    { 0x00, 0x7F, 0x49, 0x49, 0x49, 0x41 },   // E
    { 0x00, 0x7F, 0x09, 0x09, 0x09, 0x01 },   // F
    { 0x00, 0x3E, 0x41, 0x49, 0x49, 0x7A },   // G
    { 0x00, 0x7F, 0x08, 0x08, 0x08, 0x7F },   // H -40
    { 0x00, 0x00, 0x41, 0x7F, 0x41, 0x00 },   // I
    { 0x00, 0x20, 0x40, 0x41, 0x3F, 0x01 },   // J
    { 0x00, 0x7F, 0x08, 0x14, 0x22, 0x41 },   // K
    { 0x00, 0x7F, 0x40, 0x40, 0x40, 0x40 },   // L
    { 0x00, 0x7F, 0x02, 0x0C, 0x02, 0x7F },   // M
    { 0x00, 0x7F, 0x04, 0x08, 0x10, 0x7F },   // N
    { 0x00, 0x3E, 0x41, 0x41, 0x41, 0x3E },   // O
    { 0x00, 0x7F, 0x09, 0x09, 0x09, 0x06 },   // P
    { 0x00, 0x3E, 0x41, 0x51, 0x21, 0x5E },   // Q
    { 0x00, 0x7F, 0x09, 0x19, 0x29, 0x46 },   // R -50
    { 0x00, 0x46, 0x49, 0x49, 0x49, 0x31 },   // S
    { 0x00, 0x01, 0x01, 0x7F, 0x01, 0x01 },   // T
    { 0x00, 0x3F, 0x40, 0x40, 0x40, 0x3F },   // U
    { 0x00, 0x1F, 0x20, 0x40, 0x20, 0x1F },   // V
    { 0x00, 0x3F, 0x40, 0x38, 0x40, 0x3F },   // W
    { 0x00, 0x63, 0x14, 0x08, 0x14, 0x63 },   // X
    { 0x00, 0x07, 0x08, 0x70, 0x08, 0x07 },   // Y
    { 0x00, 0x61, 0x51, 0x49, 0x45, 0x43 },   // Z
    { 0x00, 0x00, 0x7F, 0x41, 0x41, 0x00 },   // [
    { 0x00, 0x55, 0x2A, 0x55, 0x2A, 0x55 },   // 55 -60
    { 0x00, 0x00, 0x41, 0x41, 0x7F, 0x00 },   // ]
    { 0x00, 0x04, 0x02, 0x01, 0x02, 0x04 },   // ^
    { 0x00, 0x40, 0x40, 0x40, 0x40, 0x40 },   // _
    { 0x00, 0x00, 0x01, 0x02, 0x04, 0x00 },   // '
    { 0x00, 0x20, 0x54, 0x54, 0x54, 0x78 },   // a
    { 0x00, 0x7F, 0x48, 0x44, 0x44, 0x38 },   // b
    { 0x00, 0x38, 0x44, 0x44, 0x44, 0x20 },   // c
    { 0x00, 0x38, 0x44, 0x44, 0x48, 0x7F },   // d
    { 0x00, 0x38, 0x54, 0x54, 0x54, 0x18 },   // e
    { 0x00, 0x08, 0x7E, 0x09, 0x01, 0x02 },   // f -70
    { 0x00, 0x18, 0xA4, 0xA4, 0xA4, 0x7C },   // g
    { 0x00, 0x7F, 0x08, 0x04, 0x04, 0x78 },   // h
    { 0x00, 0x00, 0x44, 0x7D, 0x40, 0x00 },   // i
    { 0x00, 0x40, 0x80, 0x84, 0x7D, 0x00 },   // j
    { 0x00, 0x7F, 0x10, 0x28, 0x44, 0x00 },   // k
    { 0x00, 0x00, 0x41, 0x7F, 0x40, 0x00 },   // l
    { 0x00, 0x7C, 0x04, 0x18, 0x04, 0x78 },   // m
    { 0x00, 0x7C, 0x08, 0x04, 0x04, 0x78 },   // n
    { 0x00, 0x38, 0x44, 0x44, 0x44, 0x38 },   // o
    { 0x00, 0xFC, 0x24, 0x24, 0x24, 0x18 },   // p -80
    { 0x00, 0x18, 0x24, 0x24, 0x18, 0xFC },   // q
    { 0x00, 0x7C, 0x08, 0x04, 0x04, 0x08 },   // r
    { 0x00, 0x48, 0x54, 0x54, 0x54, 0x20 },   // s
    { 0x00, 0x04, 0x3F, 0x44, 0x40, 0x20 },   // t
    { 0x00, 0x3C, 0x40, 0x40, 0x20, 0x7C },   // u
    { 0x00, 0x1C, 0x20, 0x40, 0x20, 0x1C },   // v
    { 0x00, 0x3C, 0x40, 0x30, 0x40, 0x3C },   // w
    { 0x00, 0x44, 0x28, 0x10, 0x28, 0x44 },   // x
    { 0x00, 0x1C, 0xA0, 0xA0, 0xA0, 0x7C },   // y
    { 0x00, 0x44, 0x64, 0x54, 0x4C, 0x44 },   // z -90
    { 0x14, 0x14, 0x14, 0x14, 0x14, 0x14 },   // horiz lines
    { 0xFF, 0xC1, 0xAE, 0xB6, 0xBA, 0xC1 },   // 0v(inverted)-92
    { 0xFF, 0xFF, 0xBD, 0x80, 0xBF, 0xFF },   // 1v -93
    { 0xFF, 0xBD, 0x9E, 0xAE, 0xB6, 0xB9 },   // 2v
    { 0xFF, 0xDE, 0xBE, 0xBA, 0xB4, 0xCE },   // 3v
    { 0xFF, 0xE7, 0xEB, 0xED, 0x80, 0xEF },   // 4v
    { 0xFF, 0xD8, 0xBA, 0xBA, 0xBA, 0xC6 },   // 5v
    { 0xFF, 0xC3, 0xB5, 0xB6, 0xB6, 0xCF },   // 6v
    { 0xFF, 0xFE, 0x8E, 0xF6, 0xFA, 0xFC },   // 7v
    { 0xFF, 0xC9, 0xB6, 0xB6, 0xB6, 0xC9 },   // 8v
    { 0xFF, 0xF9, 0xB6, 0xB6, 0xD6, 0xE1 }    // 9v
};


void LCD_WrDat(unsigned char data)
{
  unsigned char i=8;
  oledDC_1;;
  oledSCL_0;;

  while(i--)
  {
    if(data&0x80){oledSDA_1;}
   else{oledSDA_0;}
   oledSCL_1;
    oledSCL_0;;
    data<<=1;
  }
}

void LCD_WrCmd(unsigned char cmd)
{

 unsigned char i=8;
 oledDC_0;;
 oledSCL_0;;
  while(i--)
  {
    if(cmd&0x80){oledSDA_1;}
    else{oledSDA_0;;}
  oledSCL_1;;
  ;;;

  oledSCL_0;;
    cmd<<=1;;
  }

}
void LCD_Set_Pos(unsigned char x, unsigned char y)
{
  LCD_WrCmd(0xb0+y);
  LCD_WrCmd(((x&0xf0)>>4)|0x10);
  LCD_WrCmd((x&0x0f)|0x01);
}

void LCD_Fill(unsigned char bmp_dat)
{
	unsigned char y,x;

	for(y=0;y<8;y++)
	{
		LCD_WrCmd(0xb0+y);
		LCD_WrCmd(0x01);
		LCD_WrCmd(0x10);
		for(x=0;x<X_WIDTH;x++)
			LCD_WrDat(bmp_dat);
	}
}

void LCD_CLS(void)
{
	unsigned char y,x;
	for(y=0;y<8;y++)
	{
		LCD_WrCmd(0xb0+y);
		LCD_WrCmd(0x01);
		LCD_WrCmd(0x10);
		for(x=0;x<X_WIDTH;x++)
			LCD_WrDat(0);
	}
}


void LCD_Init(void)
{
  oledSCL_1;
  oledRST_0;
  //__delay_cycles(500);
  SysCtlDelay(ROM_SysCtlClockGet()/3/200000);
  oledRST_1;

    LCD_WrCmd(0xae);//--turn off oled panel
    LCD_WrCmd(0x00);//---set low column address
    LCD_WrCmd(0x10);//---set high column address
    LCD_WrCmd(0x40);//--set start line address  Set Mapping RAM Display Start Line (0x00~0x3F)
    LCD_WrCmd(0x81);//--set contrast control register
    LCD_WrCmd(0xcf); // Set SEG Output Current Brightness
    LCD_WrCmd(0xa1);//--Set SEG/Column Mapping     0xa0ҷ 0xa1
    LCD_WrCmd(0xc8);//Set COM/Row Scan Direction   0xc0· 0xc8
    LCD_WrCmd(0xa6);//--set normal display
    LCD_WrCmd(0xa8);//--set multiplex ratio(1 to 64)
    LCD_WrCmd(0x3f);//--1/64 duty
    LCD_WrCmd(0xd3);//-set display offset	Shift Mapping RAM Counter (0x00~0x3F)
    LCD_WrCmd(0x00);//-not offset
    LCD_WrCmd(0xd5);//--set display clock divide ratio/oscillator frequency
    LCD_WrCmd(0x80);//--set divide ratio, Set Clock as 100 Frames/Sec
    LCD_WrCmd(0xd9);//--set pre-charge period
    LCD_WrCmd(0xf1);//Set Pre-Charge as 15 Clocks & Discharge as 1 Clock
    LCD_WrCmd(0xda);//--set com pins hardware configuration
    LCD_WrCmd(0x12);
    LCD_WrCmd(0xdb);//--set vcomh
    LCD_WrCmd(0x40);//Set VCOM Deselect Level
    LCD_WrCmd(0x20);//-Set Page Addressing Mode (0x00/0x01/0x02)
    LCD_WrCmd(0x02);//
    LCD_WrCmd(0x8d);//--set Charge Pump enable/disable
    LCD_WrCmd(0x14);//--set(0x10) disable
    LCD_WrCmd(0xa4);// Disable Entire Display On (0xa4/0xa5)
    LCD_WrCmd(0xa6);// Disable Inverse Display On (0xa6/a7)
    LCD_WrCmd(0xaf);//--turn on oled panel
    LCD_Fill(0x00);  //ʼ
    LCD_Set_Pos(0,0);
  }

//==============================================================
//LCD_P6x8Str(unsigned char x,unsigned char y,unsigned char *p)
//дһ׼ASCIIַ
//ʾλãx,yyΪҳΧ07Ҫʾַ
//أ
//==============================================================
void LCD_P6x8Str(unsigned char x,unsigned char y,const char ch[])
{
  unsigned char c=0,i=0,j=0;
  while (ch[j]!='\0')
  {
    c =ch[j]-32;
    if(x>126){x=0;y++;}
    LCD_Set_Pos(x,y);
  	for(i=0;i<6;i++)
  	  LCD_WrDat(F6x8[c][i]);
  	x+=6;
  	j++;
  }
}

void LCD_P6x8Char(unsigned char x,unsigned char y,const char ch)
{
   unsigned char c=0,i=0;
    c =ch-32;
    LCD_Set_Pos(x,y);
  	for(i=0;i<6;i++)
  	  LCD_WrDat(F6x8[c][i]);

}

void LCD_P6x8Num(unsigned char x,unsigned char y,const char ch)
{
   unsigned char c=0,i=0;
    c =ch+16;
    LCD_Set_Pos(x,y);
  	for(i=0;i<6;i++)
  	  LCD_WrDat(F6x8[c][i]);

}


void LCD_P6x8Int(unsigned char x,unsigned char y,const int32_t data)
{
  unsigned char c=0,i=0;
  unsigned char carry_lost=0;
  int32_t data_invert=0;
  int32_t data_temp=data;
  if(data_temp<0){
	  LCD_P6x8Str(x,y,"-");
	  x+=6;
	  data_temp=-data_temp;
  }
  if(data_temp==0){
 	  LCD_P6x8Str(x,y,"0");
 	  x+=6;
   }
  while (data_temp){
	  data_invert*=10;
	  data_invert+=(data_temp%10);
	  if (!data_invert) carry_lost++;
	  data_temp/=10;
  }

      while (data_invert)
  {
    LCD_Set_Pos(x,y);
    c =data_invert%10+16;
    for(i=0;i<6;i++)
  	  LCD_WrDat(F6x8[c][i]);
    data_invert/=10;
    x+=6;
  }
  while(carry_lost)
  {
	  LCD_Set_Pos(x,y);
	  c =0+16;
	  for(i=0;i<6;i++)
	  	 LCD_WrDat(F6x8[c][i]);
	  x+=6;
	  carry_lost--;
  }
}

void LCD_P6x8Int_5(unsigned char x,unsigned char y,const int32_t data,unsigned char invert)
{
	int32_t temp = data;
	unsigned char i = 0;
	LCD_P6x8Str(x,y,"     ");
	if (invert>=5){
		if (!temp) LCD_P6x8Num(x+24,y,0);
		while (temp){
			LCD_P6x8Num(x+24-i*6,y,temp%10);
			i++;
			temp/=10;
		}
	}
	else{
		for (i=0;i<5;i++){
			if (i==invert) LCD_P6x8Num(x+24-i*6,y,temp%10+76);
			else LCD_P6x8Num(x+24-i*6,y,temp%10);
			temp/=10;
		}

	}
}

//==============================================================
//LCD_P8x16Str(unsigned char x,unsigned char y,unsigned char *p)
//дһ׼ASCIIַ
//ʾλãx,yyΪҳΧ07Ҫʾַ
//أ
//==============================================================


//==============================================================
// void LCD_PutPixel(unsigned char x,unsigned char y)
//һ㣨x,y
//ʵֵ(x,y),xķΧ0127yķΧ064
//أ
//==============================================================

void LCD_PutPixel(unsigned char x,unsigned char y)
{
	unsigned char data1;  //data1ǰ

    LCD_Set_Pos(x,y>>3);
	data1 = 0x01<<(y%8);
	LCD_WrCmd(0xb0+(y>>3));
	LCD_WrCmd(((x&0xf0)>>4)|0x10);
	LCD_WrCmd((x&0x0f)|0x00);
	LCD_WrDat(data1);

}


void show_time(unsigned char x,unsigned char y,const uint32_t time)
{
	LCD_P6x8Num(x+18,y,time/60%60/10);
	LCD_P6x8Num(x+24,y,time/60%10);
	LCD_P6x8Char(x+30,y,':');
	LCD_P6x8Num(x+36,y,time%60/10);
	LCD_P6x8Num(x+42,y,time%60%10);
}

void show_duty(unsigned char x,unsigned char y,const uint32_t duty)
{
	uint32_t temp = duty;
	LCD_P6x8Num(x,y,temp/1000);
	LCD_P6x8Num(x+6,y,temp%1000/100);
	LCD_P6x8Char(x+12,y,'.');
	LCD_P6x8Num(x+18,y,temp%100/10);
	LCD_P6x8Char(x+24,y,' ');
	LCD_P6x8Char(x+30,y,'%');
}

void show_voltage(unsigned char x,unsigned char y,const int16_t voltage)
{
	LCD_P6x8Num(x,y,voltage/1000);
	LCD_P6x8Char(x+6,y,'.');
	LCD_P6x8Num(x+12,y,voltage%1000/100);
	LCD_P6x8Num(x+18,y,voltage%100/10);
	LCD_P6x8Num(x+24,y,voltage%10);
}
