/*
 * oled.h
 *
 *  Created on: 2013-7-31
 *      Author: Administrator
 */

#ifndef OLED_H_
#define OLED_H_

#include "includes.h"

#define XLevelL		0x00
#define XLevelH		0x10
#define XLevel		((XLevelH&0x0F)*16+XLevelL)
#define Max_Column	128
#define Max_Row		64
#define	Brightness	0xCF

#define X_WIDTH 128
#define Y_WIDTH 64

extern const unsigned char  F6x8[][6];
extern const unsigned char F8X16[];
extern const unsigned char F14x16_Idx[];
extern const unsigned char F14x16[];

#define oledSCL_1  GPIOPinWrite(GPIO_PORTD_BASE, GPIO_PIN_3, GPIO_PIN_3);
#define oledSCL_0  GPIOPinWrite(GPIO_PORTD_BASE, GPIO_PIN_3, ~GPIO_PIN_3);
#define oledSDA_1  GPIOPinWrite(GPIO_PORTE_BASE, GPIO_PIN_1, GPIO_PIN_1);
#define oledSDA_0  GPIOPinWrite(GPIO_PORTE_BASE, GPIO_PIN_1, ~GPIO_PIN_1);
#define oledRST_1  GPIOPinWrite(GPIO_PORTE_BASE, GPIO_PIN_2, GPIO_PIN_2);
#define oledRST_0  GPIOPinWrite(GPIO_PORTE_BASE, GPIO_PIN_2, ~GPIO_PIN_2);
#define oledDC_1   GPIOPinWrite(GPIO_PORTE_BASE, GPIO_PIN_3, GPIO_PIN_3);
#define oledDC_0   GPIOPinWrite(GPIO_PORTE_BASE, GPIO_PIN_3, ~GPIO_PIN_3);

void LCD_WrDat(unsigned char data);
void LCD_WrCmd(unsigned char cmd);
void LCD_Set_Pos(unsigned char x, unsigned char y);
void LCD_Fill(unsigned char bmp_data);
void LCD_CLS(void);
void LCD_Init(void);
void LCD_PutPixel(unsigned char x,unsigned char y);
void LCD_P6x8Char(unsigned char x,unsigned char y,const char ch);//invert----> +76
void LCD_P6x8Num(unsigned char x,unsigned char y,const char ch);
void LCD_P6x8Str(unsigned char x,unsigned char y,const char ch[]);
void LCD_P6x8Int(unsigned char x,unsigned char y,const int32_t data);

void LCD_P6x8Int_5(unsigned char x,unsigned char y,const int32_t data,unsigned char invert);

void show_time(unsigned char x,unsigned char y,const uint32_t time);
void show_duty(unsigned char x,unsigned char y,const uint32_t duty);
void show_voltage(unsigned char x,unsigned char y,const int16_t voltage);

#endif /* OLED_H_ */
