//*****************************************************************************
//
// timers.c - Timers example.
//
// Copyright (c) 2012-2013 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 2.0.1.11577 of the EK-TM4C123GXL Firmware Package.
//
//*****************************************************************************
#include "includes.h"
//*****************************************************************************
//
//! \addtogroup example_list
//! <h1>Timer (timers)</h1>
//!
//! This example application demonstrates the use of the timers to generate
//! periodic interrupts.  One timer is set up to interrupt once per second and
//! the other to interrupt twice per second; each interrupt handler will toggle
//! its own indicator on the display.
//!
//! UART0, connected to the Virtual Serial Port and running at 115,200, 8-N-1,
//! is used to display messages from this application.
//
//*****************************************************************************

//*****************************************************************************
//
// Flags that contain the current value of the interrupt indicator as displayed
// on the UART.
//
//*****************************************************************************
uint32_t g_ui32Flags;
uint32_t Power_On_time = 0;
uint32_t Main_Loop_Count = 0;
uint32_t RGB_led_state = 0;
uint32_t ui32ADC0Value[4] = {0,0,0,0};
volatile uint32_t ui32TempAvg;
volatile uint32_t ui32TempValueC;

//*****************************************************************************
//
// This example application demonstrates the use of the timers to generate
// periodic interrupts.
//
//*****************************************************************************
int
main(void)
{
    //
    // Enable lazy stacking for interrupt handlers.  This allows floating-point
    // instructions to be used within interrupt handlers, but at the expense of
    // extra stack usage.
    //
    //FPULazyStackingEnable();

    //
    // Setup the system clock to run at 80 Mhz from PLL with crystal reference
    //
    SysCtlClockSet(SYSCTL_SYSDIV_2_5|SYSCTL_USE_PLL|SYSCTL_XTAL_16MHZ|SYSCTL_OSC_MAIN);

    //
    // Initialize the UART and write status.
    //
    ConfigureUART();

    UARTprintf("\033[2JTimers example\n");
    UARTprintf("T1: 0  T2: 0");

    ConfigureGPIO();

    ConfigureADCs();

    ConfigureTIMERs();


    LCD_Init();
    LCD_CLS();
    LCD_P6x8Str(0,0,"Tiva LaunchPad");
    //LCD_P6x8Str(0,1,"--TM4C123GH6PM");
    LCD_P6x8Str(0,1,"-parameters-");
    LCD_P6x8Str(79,1,"-status-");


    //
    // Loop forever while the timers run.
    //
    while(1)
    {
    	//show power-on time
    	show_time(79,0,Power_On_time);

    	//show internal temperature of the core
    	/*ADCIntClear(ADC0_BASE, 1);
    	ADCProcessorTrigger(ADC0_BASE, 1);
 	    while(!ADCIntStatus(ADC0_BASE, 1, false)){}
 	    ADCSequenceDataGet(ADC0_BASE, 1, ui32ADC0Value);
 	    ui32TempAvg = (ui32ADC0Value[0] + ui32ADC0Value[1] + ui32ADC0Value[2] + ui32ADC0Value[3] + 2)/4;
 	    ui32TempValueC = (1475 - ((2475 * ui32TempAvg)) / 4096)/10;*/
 	    //LCD_P6x8Int(85,2,Main_Loop_Count);

 	    //show main loops
    	Main_Loop_Count++;
    	if (Main_Loop_Count > 9999999) Main_Loop_Count = 0;
        LCD_P6x8Int(85,7,Main_Loop_Count);
    }
}
