/*
 * UART_Event.c
 *
 *  Created on: 20151225
 *      Author: Lenovo
 */
#include "MSP430G2553.h"
#include "UART_Global.h"
#include "UART_FIFO.h"
#include "UART_Event.h"

#define LED1_ON P1DIR |=BIT0;P1OUT|=BIT0
#define LED1_OFF P1DIR |=BIT0;P1OUT&=~BIT0
#define LED2_ON P1DIR |=BIT6;P1OUT |=BIT6
#define LED2_OFF P1DIR|=BIT6;P1OUT&=~BIT6

const unsigned char Out_DELETE[]="\x8 \x8";
const unsigned char String1[]="LED1_ON LED1OFF LED2_ON LED2_OFF\r\n";
const unsigned char String2[]="Please input Command:\r\n";
const unsigned char String3[]="Are you crazy?\r\n";
const unsigned char String4[]="I was born for these!\r\n";
const unsigned char String5[]="I have got it!\r\n";
const unsigned char String6[]="It is easy for me!\r\n";
const unsigned char String7[]="As your wish!\r\n";
void Command_match();

void UART_OnTx(void)
{
	unsigned char Temp=0;
	if(Tx_FIFO_DataNum>0)
	{
		Tx_FIFO_ReadChar(&Temp);
		UCA0TXBUF=Temp;
	}
}
void UART_OnRx(void)
{
	unsigned char Temp=0;
	Temp=UCA0RXBUF;
	if(Temp==0x0d)
	{
		Tx_FIFO_WriteChar('\r');
		Tx_FIFO_WriteChar('\n');
	}
	else if(Temp==0x08||Temp==0x7f)
	{
		UART_SendString(Out_DELETE);
	}
	else
		Tx_FIFO_WriteChar(Temp);
	if(Temp==0x0d)
	{
		if(Rx_FIFO_DataNum>0)
		{
			Command_match();
			Rx_FIFO_Clear();
		}
		else{
			UART_SendString(String1);
			UART_SendString(String2);
		}
	}
	else if(Temp==0x08||Temp==0x07)
	{
		if(Rx_FIFO_DataNum>0)
		{
			_disable_interrupts();
			Rx_FIFO_DataNum--;
			if(Rx_FIFO_IndexW>0)
				Rx_FIFO_IndexW--;
			_enable_interrupts();


		}

	}
	else
	{
		Rx_FIFO_WriteChar(Temp);
	}
}

void UART_SendString(const unsigned char *Ptr)
{
	while(*Ptr)
	{
		Tx_FFIO_WriteChar(*Ptr++);
	}
}

void Command_match()
{
	unsigned char Command_Num=0;
	if((Rx_FIFO[0]=='L')&&(Rx_FIFO[1]=='E')&&(Rx_FIFO[2]=='D')&&(Rx_FIFO[4]=='_')&&(Rx_FIFO[2]=='O'))
	{
		if((Rx_FIFO[3]=='1')&&(Rx_FIFO[6]=='N'))
			Command_Num=1;
		if((Rx_FIFO[3]=='1')&&(Rx_FIFO[6]=='F')&&(Rx_FIFO[7]=='F'))
			Command_Num=2;
		if((Rx_FIFO[3]=='2')&&(Rx_FIFO[6]=='N'))
			Command_Num=3;
		if((Rx_FIFO[3]=='2')&&(Rx_FIFO[6]=='F')&&(Rx_FIFO[7]=='F'))
			Command_Num=4;
	}

	switch(Command_Num)
	{
	case 0:UART_SendString(String3);break;
	case 1:LED1_ON;UART_SendString(String4);break;
	case 2:LED1_OFF;UART_SendString(String5);break;
	case 3:LED2_ON;UART_SendString(String6);break;
	case 4:LED2_OFF;UART_SendString(String7);break;
	default:break;
	}
}
