/*
 * UART_init.c
 *
 *  Created on: 20151225
 *      Author: Lenovo
 */
#include "MSP430G2553.h"
#include "UART_Event.h"

void USCI_A0_init(void)
{
	P1SEL=BIT1+BIT2;
	P1SEL2=BIT1+BIT2;

	UCA0CTL1 |=UCSSEL_1;

	UCA0BR0=0X03;
	UCA0BR1=0X00;
	UCA0MCTL=UCBRS1+UCBRS0;
	UCA0CTL1 &=~UCSWRST;
	IE2 |=UCA0RXIE + UCA0TXIE;
	_enable_interrupts();
}

#pragma vector=USCIAB0TX_VECTOR
__interrupt void USCI0TX_ISR(void)
{
	IFG2&=~UCA0TXIFG;
	UART_OnTx();
}

#pragma vector=USCIAB0RX_VECTOR
__interrupt void USCI0RX_ISR(void)
{
	IFG2&=~UCA0RXIFG;
	UART_OnRx();
}
