//*****************************************************************************
//
// images.c - Data for the images used by the application.
//
// Copyright (c) 2009-2012 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 9107 of the DK-LM3S9B96 Firmware Package.
//
//*****************************************************************************

#include "grlib/grlib.h"

//*****************************************************************************
//
// 120 pixel wide image of the stacked TI logo.
//
//*****************************************************************************
const unsigned char g_pucTILogoStack120[] =
{
    IMAGE_FMT_4BPP_COMP,
    120, 0,
    42, 0,

    15,
    0x20, 0x1f, 0x23,
    0x4f, 0x4d, 0x4d,
    0x24, 0x1c, 0xed,
    0x7a, 0x78, 0x76,
    0x3b, 0x53, 0xf0,
    0x58, 0x76, 0xf3,
    0xaa, 0xa7, 0xa5,
    0x82, 0x9e, 0xf7,
    0xcb, 0xc9, 0xc8,
    0xa2, 0xb9, 0xfa,
    0xc0, 0xd1, 0xfc,
    0xe3, 0xe2, 0xe1,
    0xd5, 0xe2, 0xfd,
    0xf0, 0xef, 0xef,
    0xe6, 0xee, 0xfe,
    0xff, 0xff, 0xff,

    0x1f, 0xff, 0xff, 0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x87, 0x02, 0xf4, 0x22, 0x22, 0x7f, 0x07, 0x07, 0x77, 0xe0, 0x2f, 0x07,
    0x07, 0xff, 0xff, 0xf4, 0x22, 0x22, 0x1f, 0x7f, 0xf5, 0x2a, 0x07, 0x07,
    0x77, 0x2f, 0x07, 0x81, 0x07, 0xf4, 0x22, 0x22, 0x7f, 0xf2, 0x2c, 0x07,
    0xf8, 0x07, 0x77, 0x2f, 0x07, 0x07, 0xf4, 0x22, 0x22, 0x1f, 0x9f, 0xf9,
    0xaf, 0x07, 0x07, 0x77, 0x2f, 0x07, 0x80, 0x07, 0xf4, 0x22, 0x22, 0x25,
    0xa2, 0x7a, 0x22, 0x00, 0x22, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x6f,
    0xf8, 0x07, 0xbf, 0x77, 0x2f, 0x07, 0xf4, 0x22, 0x22, 0x00, 0x29, 0x72,
    0x97, 0x22, 0x22, 0xff, 0xff, 0x66, 0x0f, 0xf8, 0x03, 0xf8, 0x6f, 0x07,
    0xbf, 0x77, 0x2f, 0x80, 0x07, 0xf4, 0x22, 0x22, 0x2e, 0x52, 0xc5, 0x22,
    0x40, 0x22, 0x01, 0xfb, 0x06, 0xf8, 0x11, 0x11, 0x3b, 0x00, 0x11, 0x8f,
    0x61, 0x8f, 0xf1, 0x3f, 0xff, 0x80, 0x3e, 0x01, 0x8f, 0x03, 0xdb, 0xb7,
    0x6f, 0x23, 0xf4, 0x01, 0x22, 0x25, 0xff, 0x22, 0xff, 0x92, 0x22, 0x01,
    0x00, 0xfb, 0x06, 0xfd, 0x03, 0xdb, 0x3f, 0x60, 0x6f, 0x00, 0x16, 0xff,
    0x80, 0x0d, 0xfb, 0x0b, 0xf3, 0x1f, 0xf0, 0x03, 0xdb, 0xb7, 0x6f, 0xff,
    0xff, 0xf5, 0x45, 0x00, 0x55, 0x52, 0x22, 0x29, 0xff, 0x22, 0xff, 0x52,
    0x00, 0x22, 0x7f, 0xff, 0xff, 0xfb, 0x06, 0xfd, 0x08, 0x00, 0xff, 0xff,
    0xf1, 0x03, 0x1f, 0xff, 0x18, 0x03, 0x5e, 0xf8, 0xb1, 0xff, 0xe9, 0xd4,
    0xa7, 0x5f, 0xff, 0x00, 0xff, 0xf5, 0x22, 0x22, 0x22, 0x22, 0x24, 0x9a,
    0x00, 0x25, 0xc4, 0x22, 0x22, 0x2e, 0xff, 0xff, 0xfb, 0x00, 0x06, 0xfd,
    0x00, 0x10, 0x6f, 0xff, 0x00, 0xff, 0x00, 0xfd, 0x0f, 0x30, 0xff, 0x10,
    0x00, 0x6f, 0xff, 0x3c, 0xff, 0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0xff, 0x42,
    0x00, 0x22, 0x22, 0x22, 0x22, 0x77, 0x27, 0x72, 0x22, 0x00, 0x22, 0x2e,
    0xff, 0xff, 0xfb, 0x06, 0xfd, 0x06, 0x00, 0xf8, 0xbf, 0xf8, 0x00, 0x3f,
    0xf3, 0x06, 0x10, 0x0f, 0x8f, 0xfd, 0x61, 0x0b, 0x01, 0xe9, 0xd4, 0xa7,
    0x80, 0x5f, 0xff, 0xf5, 0x22, 0x22, 0x22, 0x22, 0xc5, 0x00, 0x2c, 0x42,
    0x22, 0x22, 0x2e, 0xff, 0xff, 0xfb, 0x00, 0x06, 0xff, 0x08, 0xff, 0xfd,
    0xf0, 0xf6, 0x0b, 0x04, 0xf1, 0x66, 0x80, 0x38, 0x8f, 0xa1, 0xff, 0xff,
    0xf0, 0xe9, 0xd4, 0xa7, 0x5f, 0xff, 0xff, 0x22, 0x22, 0x08, 0x22, 0x22,
    0xf2, 0x2e, 0xd1, 0x2c, 0xff, 0xff, 0x00, 0xf6, 0x03, 0xf8, 0x00, 0x33,
    0x06, 0x01, 0xff, 0x00, 0x00, 0x30, 0xff, 0xf1, 0x06, 0x01, 0x30, 0x0f,
    0xf8, 0x02, 0xe2, 0xc6, 0x87, 0x3d, 0x52, 0x22, 0x22, 0x00, 0x22, 0xfc,
    0xcf, 0xf4, 0x22, 0x22, 0x4f, 0xff, 0x00, 0xff, 0xfb, 0xbb, 0xf8, 0x88,
    0x68, 0x8d, 0x88, 0x00, 0xfd, 0x88, 0x88, 0xff, 0xf8, 0x8b, 0xd8, 0x68,
    0xf8, 0x03, 0xdb, 0xb7, 0x6f, 0x23, 0xe2, 0x29, 0xfa, 0x02, 0x24, 0xff,
    0xff, 0xf4, 0x22, 0x7f, 0x01, 0xf8, 0x7c, 0xb8, 0x07, 0x07, 0x77, 0x2f,
    0x07, 0xff, 0xff, 0x01, 0xcf, 0xff, 0x42, 0x7e, 0xee, 0xe2, 0x2f, 0x02,
    0x3f, 0xf6, 0x03, 0x07, 0x07, 0x77, 0x2f, 0x07, 0x02, 0x08, 0xa2, 0x22,
    0x22, 0x22, 0x03, 0xfb, 0x06, 0xfb, 0x00, 0xff, 0xfd, 0xbb, 0xff, 0x8b,
    0xff, 0xdb, 0xdd, 0x08, 0xbd, 0xfd, 0xdb, 0xdf, 0xa9, 0xdb, 0xdd, 0xdf,
    0x00, 0xff, 0xff, 0xdb, 0xdb, 0xdb, 0xbb, 0xfb, 0xdf, 0x00, 0xff, 0xbb,
    0xfb, 0xbf, 0xdb, 0xff, 0xf8, 0xbf, 0x18, 0xff, 0xff, 0xff, 0xe9, 0xd4,
    0xff, 0xff, 0xf4, 0x10, 0x22, 0x22, 0x2c, 0x73, 0xfb, 0x06, 0xf0, 0x08,
    0x00, 0xff, 0x06, 0xb0, 0x10, 0x0b, 0x01, 0x00, 0x10, 0x00, 0xb0, 0x01,
    0x00, 0x8f, 0x00, 0xff, 0xd0, 0x88, 0x00, 0x00, 0xff, 0xf3, 0x03, 0xf0,
    0x01, 0x10, 0x86, 0x00, 0x01, 0xff, 0x30, 0x60, 0x10, 0x00, 0x3f, 0x01,
    0x06, 0x10, 0x8f, 0xff, 0xff, 0xff, 0xe9, 0xd4, 0xff, 0x08, 0xfa, 0x22,
    0x22, 0x2f, 0x7b, 0xfb, 0x06, 0xf3, 0x00, 0x00, 0xbf, 0x0f, 0x13, 0xff,
    0x86, 0xbf, 0x03, 0x00, 0xf8, 0xd0, 0x3f, 0xf0, 0x0f, 0x03, 0xff, 0xf0,
    0x00, 0xdf, 0x00, 0x6f, 0xf0, 0x06, 0xf1, 0x0f, 0xff, 0x00, 0xbd, 0x00,
    0x3f, 0x61, 0x8f, 0xf0, 0xbf, 0x81, 0x03, 0x3f, 0xf8, 0x8f, 0xff, 0xff,
    0xff, 0xe9, 0xd4, 0x04, 0xff, 0xff, 0x52, 0x22, 0x4f, 0x7b, 0xfb, 0x06,
    0x00, 0xf1, 0x61, 0x0f, 0x1d, 0x30, 0x16, 0xff, 0xff, 0x00, 0x01, 0xff,
    0xf0, 0x3f, 0xf0, 0x1f, 0x03, 0xff, 0x00, 0xf0, 0xdd, 0x13, 0x0f, 0x33,
    0x06, 0xf1, 0x0b, 0x00, 0x83, 0xf8, 0x16, 0x06, 0x81, 0xff, 0xd0, 0x8f,
    0x03, 0xf3, 0x01, 0x6f, 0xff, 0xff, 0xff, 0xe9, 0xd4, 0x88, 0xa1, 0xf5,
    0x22, 0x2f, 0x73, 0xfb, 0x06, 0xf1, 0x00, 0x8f, 0x01, 0x0b, 0xf3, 0x00,
    0x06, 0xff, 0x01, 0x00, 0xff, 0xf0, 0x01, 0x03, 0xff, 0x03, 0xff, 0xf0,
    0x00, 0xdd, 0x1b, 0x08, 0x1d, 0x06, 0xf1, 0x03, 0x10, 0x00, 0xf8, 0x0f,
    0x30, 0x13, 0xff, 0xd0, 0x8f, 0xff, 0x03, 0x30, 0x00, 0x3f, 0xff, 0xff,
    0xff, 0xe9, 0xd4, 0x90, 0xa1, 0xc7, 0x7f, 0x7b, 0xfb, 0x06, 0xf1, 0x6f,
    0x00, 0xb0, 0x0b, 0xff, 0xff, 0x10, 0xff, 0x01, 0xff, 0x00, 0xf0, 0x3f,
    0x10, 0xff, 0x03, 0xff, 0xf0, 0xdd, 0x00, 0x0f, 0x00, 0x6f, 0x06, 0xf1,
    0x0f, 0xff, 0xf8, 0x00, 0x0f, 0xf1, 0x03, 0xff, 0xd0, 0x8f, 0xfd, 0xff,
    0x9c, 0xa1, 0xff, 0xff, 0xe9, 0xd4, 0xa7, 0xff, 0xfb, 0x00, 0x06, 0xf1,
    0x6f, 0xf8, 0x0d, 0x16, 0xff, 0x11, 0x00, 0xff, 0x01, 0xff, 0xf0, 0x3f,
    0xd0, 0x0f, 0x10, 0x00, 0xff, 0x80, 0xfb, 0x0f, 0x60, 0xff, 0x06, 0xf1,
    0x08, 0x0f, 0xfd, 0x6b, 0x0f, 0x61, 0xd0, 0x8f, 0xf0, 0x03, 0x3f, 0xf1,
    0x0f, 0xff, 0xff, 0xff, 0xe9, 0xd4, 0x80, 0xa7, 0xff, 0xf3, 0x03, 0xf0,
    0x3f, 0xff, 0x3b, 0x00, 0x60, 0x00, 0x1f, 0xfb, 0x01, 0xbf, 0x80, 0x1f,
    0x00, 0xf6, 0x03, 0xf1, 0x00, 0x08, 0xf6, 0x0f, 0xf3, 0x80, 0xc2, 0x00,
    0x66, 0x0b, 0xff, 0xb3, 0xff, 0x60, 0x00, 0x3f, 0xf6, 0x00, 0x01, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfc, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07,
};

//*****************************************************************************
//
// 240 pixel wide image of the horizontal TI logo.
//
//*****************************************************************************
const unsigned char g_pucTILogoHoriz240[] =
{
    IMAGE_FMT_4BPP_COMP,
    240, 0,
    55, 0,

    15,
    0x20, 0x1f, 0x23,
    0x46, 0x44, 0x44,
    0x24, 0x1d, 0xed,
    0x68, 0x65, 0x64,
    0x84, 0x81, 0x7f,
    0x46, 0x62, 0xf2,
    0x99, 0x97, 0x94,
    0x6c, 0x8a, 0xf5,
    0xaf, 0xad, 0xab,
    0x8f, 0xaa, 0xf9,
    0xc6, 0xc4, 0xc2,
    0xd9, 0xd7, 0xd6,
    0xbd, 0xcf, 0xfc,
    0xe9, 0xe8, 0xe7,
    0xdc, 0xe7, 0xfe,
    0xff, 0xff, 0xff,

    0x1f, 0xff, 0xff, 0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x03,
    0x0f, 0x77, 0x77, 0x77, 0xcf, 0x07, 0x07, 0x77, 0x2f, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x81, 0x06, 0x22, 0x22, 0x22, 0x9f,
    0xff, 0xee, 0x07, 0xff, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xf0, 0x07, 0x07, 0x07, 0x04, 0x22, 0x22, 0x22, 0x9f, 0x1f, 0xfe, 0x22,
    0x9f, 0x07, 0x07, 0x77, 0x2f, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x03, 0x01, 0x22, 0x22, 0x22, 0x9f, 0xf9, 0x22, 0xef, 0x07,
    0xff, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf0, 0x07, 0x07,
    0x07, 0x03, 0x22, 0x22, 0x22, 0x9f, 0x3f, 0xfe, 0x99, 0x07, 0x07, 0x77,
    0x2f, 0x07, 0x07, 0xfe, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x04, 0x22,
    0x00, 0x22, 0x22, 0x59, 0xf9, 0x9c, 0xf7, 0x77, 0x77, 0x80, 0x03, 0xf8,
    0x46, 0x66, 0x66, 0x66, 0x66, 0x4f, 0xe7, 0x07, 0xbf, 0x1c, 0x64, 0xdf,
    0x37, 0x07, 0x77, 0xf8, 0x2f, 0x07, 0x07, 0x07, 0x07, 0xff, 0x22, 0x22,
    0x00, 0x22, 0x22, 0xf2, 0x27, 0xc2, 0x22, 0x22, 0xef, 0x80, 0x02, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xef, 0x07, 0xbf, 0x73, 0x10, 0x3f,
    0x07, 0x7f, 0x37, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x01, 0x22, 0x22, 0x22,
    0x02, 0x25, 0xf2, 0x2e, 0x72, 0x22, 0x22, 0x03, 0x83, 0x03, 0xff, 0xff,
    0x00, 0x4f, 0xff, 0xb3, 0x07, 0xbf, 0x9f, 0x13, 0x60, 0x0f, 0x3f, 0x07,
    0x77, 0x2f, 0x07, 0xe0, 0x07, 0x07, 0x07, 0xff, 0xff, 0x22, 0x22, 0x22,
    0x02, 0x5c, 0xc2, 0x2f, 0x75, 0x22, 0x22, 0x03, 0xdf, 0x00, 0xff, 0xff,
    0x00, 0x4f, 0xfb, 0xda, 0xbb, 0xbb, 0x00, 0xbb, 0xfa, 0xab, 0xba, 0xdf,
    0xba, 0xb8, 0xdf, 0x12, 0xff, 0xdb, 0xbf, 0x39, 0xa8, 0xaf, 0x39, 0xff,
    0x00, 0xff, 0x60, 0x0f, 0xfa, 0xbd, 0xff, 0xff, 0xfa, 0x00, 0xda, 0xdf,
    0xfd, 0x88, 0xff, 0xff, 0xdd, 0xdd, 0x00, 0xdd, 0xdd, 0xbf, 0xbb, 0xdd,
    0xdd, 0xdf, 0xff, 0x00, 0xfa, 0xbd, 0xbb, 0xff, 0xfa, 0xbb, 0xbd, 0xbd,
    0x28, 0xbf, 0xff, 0x51, 0xad, 0x69, 0xdd, 0xdf, 0xbb, 0x02, 0xdd, 0xff,
    0xff, 0xbb, 0xbb, 0xfb, 0xa9, 0xbf, 0x1e, 0xff, 0xfb, 0x8a, 0x41, 0x29,
    0xd4, 0xa6, 0x22, 0x05, 0x22, 0x29, 0xff, 0x72, 0x2f, 0xc9, 0xef, 0x15,
    0x01, 0x00, 0x4f, 0xfa, 0x00, 0x00, 0x00, 0x00, 0xd9, 0x00, 0xff, 0xd0,
    0x01, 0xdf, 0xff, 0x00, 0x0b, 0xff, 0x04, 0xff, 0xa0, 0x00, 0x00, 0x0d,
    0x12, 0x60, 0x0f, 0x00, 0xf6, 0x00, 0x0f, 0xff, 0xf3, 0x00, 0xff, 0x10,
    0x00, 0x00, 0x00, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x80, 0x31, 0x00,
    0x1d, 0xf8, 0x00, 0x0a, 0xff, 0xf8, 0x00, 0x00, 0xad, 0x00, 0x03, 0xff,
    0xff, 0xf1, 0x00, 0x40, 0x0f, 0x6a, 0x0f, 0xd0, 0x00, 0xaf, 0xff, 0xa0,
    0x24, 0x0b, 0x60, 0x11, 0x01, 0xfd, 0x81, 0xaf, 0xff, 0x30, 0xff, 0xff,
    0xe9, 0xd4, 0xff, 0xff, 0xc7, 0x99, 0x00, 0x99, 0x99, 0x22, 0x22, 0x2c,
    0xff, 0x22, 0x2f, 0x08, 0xfc, 0x22, 0x22, 0x7f, 0x25, 0x00, 0x4f, 0xff,
    0x00, 0x40, 0x1f, 0xdd, 0xd1, 0x3f, 0xd0, 0x03, 0xff, 0x02, 0xf0, 0x4f,
    0xff, 0xfd, 0x00, 0x04, 0x69, 0xbf, 0x20, 0xd6, 0x08, 0x12, 0x60, 0x0f,
    0xff, 0x10, 0x01, 0x00, 0xff, 0xff, 0x0a, 0xf3, 0x06, 0xff, 0xa0, 0x1f,
    0x00, 0x0a, 0xf6, 0x00, 0xfd, 0x33, 0xf1, 0x01, 0xdb, 0x00, 0xa0, 0x00,
    0xff, 0x30, 0x3f, 0xff, 0xff, 0x11, 0x00, 0xff, 0x60, 0x00, 0xff, 0xff,
    0xd0, 0x00, 0xaf, 0x00, 0xf3, 0x01, 0xfd, 0xdb, 0x04, 0xf8, 0x00, 0x0d,
    0x00, 0xff, 0xf1, 0x1f, 0x06, 0xfb, 0x00, 0xaf, 0x60, 0x0b, 0xf0, 0x08,
    0xff, 0x80, 0x01, 0xff, 0xe9, 0xd4, 0x00, 0xff, 0xff, 0xc2, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x00, 0x2c, 0xef, 0x22, 0x7f, 0xe7, 0x22, 0x22, 0x29,
    0x80, 0x25, 0x00, 0x4f, 0xff, 0x40, 0x1f, 0xff, 0xff, 0x00, 0x8f, 0xf8,
    0x00, 0x8f, 0x10, 0xff, 0xff, 0xf4, 0x00, 0x06, 0x00, 0xff, 0xf8, 0x04,
    0xff, 0xff, 0xb6, 0x80, 0x12, 0x60, 0x0f, 0xff, 0x00, 0x00, 0x3f, 0xff,
    0x00, 0x0a, 0xf0, 0x0f, 0xff, 0xff, 0x46, 0xbf, 0xf8, 0x00, 0x00, 0xff,
    0xf4, 0xf1, 0x03, 0xff, 0xf8, 0x00, 0x00, 0xbf, 0x30, 0x3f, 0xff, 0xff,
    0x11, 0xff, 0x60, 0x00, 0x10, 0x6f, 0xff, 0x30, 0x00, 0xaf, 0xf3, 0x03,
    0x00, 0xff, 0xff, 0xfa, 0xf8, 0x00, 0x00, 0xff, 0xf1, 0x00, 0x1f, 0x6f,
    0xff, 0x00, 0xdf, 0xfa, 0xa0, 0x0f, 0x2c, 0xff, 0xff, 0x01, 0xff, 0xe9,
    0xd4, 0xff, 0xff, 0x08, 0xf5, 0x22, 0x22, 0x22, 0xe9, 0x5f, 0x22, 0xe7,
    0xa0, 0xb9, 0x25, 0x25, 0x00, 0x4f, 0xff, 0x40, 0x3f, 0x00, 0xff, 0xfb,
    0xff, 0xff, 0x30, 0x08, 0x0d, 0xff, 0x00, 0xff, 0xf0, 0x6f, 0x00, 0xaf,
    0xfa, 0x00, 0x6d, 0x80, 0x24, 0x60, 0x0f, 0xff, 0x06, 0x80, 0x04, 0xff,
    0x08, 0x0a, 0xf0, 0x03, 0xbf, 0x79, 0xf8, 0x00, 0xff, 0x10, 0xff, 0xf1,
    0x03, 0xc9, 0xbf, 0x30, 0x3f, 0xff, 0x08, 0xff, 0x11, 0xff, 0x60, 0x09,
    0x08, 0x00, 0xaf, 0x00, 0xf3, 0x03, 0xff, 0xfd, 0xbf, 0xf6, 0x0f, 0x00,
    0x00, 0x0f, 0xf1, 0x1f, 0xff, 0xff, 0x00, 0xdf, 0xff, 0x03, 0xf0, 0x04,
    0xbf, 0xff, 0xff, 0xff, 0xe9, 0xd4, 0x80, 0xa3, 0x52, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x9c, 0x28, 0x22, 0xf5, 0xc1, 0x25, 0x15, 0x00, 0x4f, 0xff,
    0x00, 0x40, 0x03, 0x33, 0x06, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x8f, 0xff,
    0xff, 0x80, 0xff, 0x00, 0x3f, 0xff, 0x08, 0x00, 0x00, 0x01, 0x6f, 0x12,
    0x60, 0x0f, 0xff, 0x00, 0x04, 0xf3, 0x00, 0x6f, 0x0a, 0xf4, 0x00, 0x00,
    0x00, 0x03, 0xff, 0xff, 0xf8, 0x00, 0xff, 0xff, 0xf1, 0x00, 0x03, 0xff,
    0xd0, 0x03, 0xff, 0x30, 0x3f, 0xff, 0x00, 0xff, 0x11, 0xff, 0x60, 0xf0,
    0x08, 0xf6, 0x0f, 0x00, 0x00, 0xaf, 0xf3, 0x00, 0x33, 0x30, 0x8f, 0xf6,
    0x00, 0x0f, 0xa0, 0x01, 0xf1, 0x0f, 0xff, 0xff, 0x00, 0x00, 0xdf, 0xff,
    0xf3, 0x00, 0x00, 0x04, 0xff, 0xff, 0x70, 0xff, 0xe9, 0xd4, 0xa2, 0xf5,
    0x22, 0x22, 0x22, 0x05, 0x22, 0x22, 0xe9, 0x22, 0xf2, 0xc1, 0x25, 0x1d,
    0x00, 0x00, 0x4f, 0xff, 0x40, 0x01, 0x01, 0x06, 0xff, 0x00, 0xff, 0xf4,
    0x00, 0x6f, 0xff, 0xff, 0x11, 0xff, 0x24, 0x80, 0x0d, 0xb1, 0x00, 0x01,
    0x12, 0x60, 0x0f, 0x00, 0xff, 0x03, 0xff, 0x10, 0x08, 0x0a, 0xff, 0x80,
    0x00, 0x00, 0x00, 0x0d, 0xff, 0xf8, 0x00, 0xff, 0xff, 0x00, 0xf1, 0x00,
    0x00, 0x00, 0xbf, 0xff, 0x30, 0x3f, 0x00, 0xff, 0xff, 0x11, 0xff, 0x60,
    0xf3, 0x01, 0xf0, 0x00, 0x6f, 0x00, 0xaf, 0xf3, 0x00, 0x10, 0x10, 0x8f,
    0x00, 0xf6, 0x0f, 0xf8, 0x00, 0x43, 0x1f, 0xff, 0xff, 0x00, 0x00, 0xdf,
    0xff, 0xff, 0x60, 0x00, 0x00, 0x0f, 0x1c, 0xff, 0xff, 0xff, 0xe9, 0xd4,
    0xa2, 0x22, 0x22, 0x02, 0x22, 0x22, 0x22, 0xf5, 0x22, 0xf2, 0xc1, 0x25,
    0x80, 0x25, 0x00, 0x4f, 0xff, 0x40, 0x3f, 0xff, 0xfa, 0x00, 0xff, 0xff,
    0xa0, 0x40, 0x0b, 0xff, 0xfd, 0x01, 0x00, 0x44, 0x30, 0x06, 0xff, 0xff,
    0xfd, 0xa3, 0x00, 0x40, 0xaf, 0x09, 0x60, 0x0f, 0xff, 0x03, 0xff, 0xf1,
    0x00, 0x00, 0x0a, 0xff, 0xff, 0xfb, 0x40, 0x03, 0xff, 0x00, 0xf8, 0x00,
    0xff, 0xff, 0xf1, 0x03, 0xfa, 0x00, 0x00, 0x6f, 0xff, 0x30, 0x3f, 0xff,
    0xff, 0x11, 0xff, 0x00, 0x60, 0xfb, 0x00, 0x30, 0xff, 0x00, 0xaf, 0xf3,
    0x00, 0x03, 0xff, 0xfd, 0xbf, 0xf6, 0x0f, 0xff, 0x60, 0x00, 0x00, 0x1f,
    0xff, 0xff, 0x00, 0xdf, 0xff, 0xff, 0x0f, 0xff, 0xfa, 0x40, 0x04, 0xd1,
    0xb9, 0xd4, 0xa2, 0x00, 0x72, 0x22, 0x22, 0x22, 0x22, 0xf7, 0x79, 0xf9,
    0x08, 0x52, 0x22, 0x22, 0x25, 0x25, 0x00, 0x4f, 0xff, 0x20, 0x40, 0x1f,
    0x02, 0x03, 0xf1, 0x00, 0xff, 0xf4, 0x00, 0x03, 0x11, 0x30, 0x00, 0xf8,
    0xdf, 0xff, 0xff, 0x20, 0x10, 0x8f, 0x09, 0x60, 0x0f, 0xff, 0x03, 0xff,
    0x00, 0xff, 0x00, 0x0a, 0xfa, 0xff, 0xff, 0xf8, 0x00, 0x80, 0xe9, 0xff,
    0xff, 0xf1, 0x03, 0xff, 0x80, 0x08, 0x00, 0xff, 0x30, 0x3f, 0xff, 0xff,
    0x01, 0xff, 0x60, 0x00, 0xff, 0x10, 0x03, 0xff, 0x00, 0xaf, 0xf3, 0x03,
    0x00, 0xff, 0xff, 0xff, 0xf6, 0x0f, 0xff, 0xf3, 0x00, 0x01, 0x1f, 0xff,
    0xff, 0x00, 0xdf, 0xff, 0xab, 0x91, 0xf0, 0x6a, 0x51, 0xd4, 0xa2, 0xe2,
    0x22, 0x5c, 0x72, 0x42, 0x25, 0x59, 0x72, 0x22, 0x27, 0xcf, 0x25, 0x00,
    0x00, 0x4f, 0xff, 0x40, 0x3f, 0xff, 0xff, 0x4b, 0xf3, 0x00, 0x0f, 0xff,
    0x00, 0x3f, 0xf0, 0x4f, 0xff, 0xfa, 0x01, 0x00, 0xd8, 0x0f, 0xff, 0xff,
    0x10, 0xaf, 0x09, 0x00, 0x60, 0x0f, 0xff, 0x04, 0xff, 0xff, 0xd0, 0x0a,
    0x00, 0xf0, 0x8f, 0xff, 0xf8, 0x03, 0xff, 0xf8, 0x00, 0x01, 0xff, 0xff,
    0xf1, 0x03, 0xff, 0xf0, 0x00, 0x42, 0x80, 0x39, 0x60, 0xff, 0xa0, 0x0d,
    0xff, 0x00, 0xaf, 0x02, 0xf3, 0x03, 0xff, 0xff, 0xf4, 0xf8, 0x71, 0x10,
    0x00, 0x1f, 0xff, 0xff, 0x00, 0xdf, 0xff, 0xb0, 0xbf, 0x03, 0xff, 0xf4,
    0x04, 0xff, 0xff, 0xff, 0xe9, 0xd4, 0x82, 0xa2, 0xf9, 0x25, 0xff, 0xf5,
    0x25, 0x59, 0x22, 0x40, 0x27, 0x36, 0xfd, 0x00, 0x3f, 0xff, 0x30, 0x04,
    0x00, 0x44, 0x40, 0x0f, 0x60, 0x6f, 0xff, 0x40, 0x08, 0x00, 0x80, 0xaf,
    0xff, 0xff, 0x00, 0x3f, 0x00, 0x36, 0x20, 0x60, 0x03, 0x02, 0x40, 0x0d,
    0xff, 0x01, 0xff, 0x00, 0xff, 0xfb, 0x08, 0xf1, 0x00, 0x68, 0x30, 0x0d,
    0x00, 0xff, 0xf6, 0x00, 0xff, 0xff, 0xf1, 0x01, 0xff, 0x00, 0xfa, 0x00,
    0x1f, 0xf0, 0x00, 0x68, 0x60, 0x0d, 0x00, 0xff, 0x30, 0xff, 0xf0, 0x1f,
    0xfd, 0x00, 0x8f, 0x00, 0xf1, 0x00, 0x44, 0x44, 0x01, 0xf4, 0x0f, 0xff,
    0x00, 0xff, 0xf0, 0x0f, 0xff, 0xfd, 0x00, 0xbf, 0xff, 0x0b, 0xf0, 0x01,
    0x68, 0x30, 0x91, 0xff, 0xe9, 0xd4, 0x80, 0xa5, 0xfe, 0x22, 0x7c, 0xcc,
    0xee, 0x22, 0xcf, 0x80, 0x36, 0xf3, 0x01, 0x08, 0xf8, 0x01, 0x10, 0x00,
    0x00, 0x00, 0xa6, 0x00, 0x3f, 0xfd, 0x11, 0x10, 0x00, 0x00, 0x3f, 0xff,
    0xf6, 0x01, 0x06, 0x46, 0x00, 0x00, 0x42, 0x6f, 0x01, 0xf8, 0x01, 0x01,
    0xf6, 0xba, 0x48, 0x00, 0xf6, 0x43, 0x00, 0x03, 0xff, 0xff, 0xa0, 0x10,
    0x00, 0x3f, 0xff, 0x60, 0x10, 0x6f, 0xff, 0x80, 0x00, 0x00, 0xff, 0x40,
    0x00, 0x01, 0xdf, 0xf8, 0x00, 0x4f, 0x00, 0xf4, 0x8f, 0xf3, 0x01, 0x1d,
    0x80, 0x11, 0x00, 0x00, 0x00, 0x0b, 0xd0, 0x01, 0xff, 0xff, 0xfb, 0x3f,
    0x00, 0xff, 0xd1, 0x01, 0x1d, 0xff, 0xf4, 0x61, 0x00, 0x0e, 0x04, 0xff,
    0xff, 0xff, 0xe9, 0xd4, 0xa7, 0x52, 0x0f, 0x22, 0x22, 0x22, 0x2e, 0x37,
    0x07, 0x77, 0x2f, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x83, 0x05, 0xe2, 0x22, 0x22, 0x22, 0x9f, 0x07, 0x07, 0xff, 0x77, 0x2f,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xe1, 0x07, 0x07, 0x05, 0xf5, 0x22,
    0x22, 0x22, 0x07, 0xff, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xf0, 0x07, 0x07, 0x07, 0x06, 0xfe, 0x22, 0x22, 0x22, 0xff, 0x07, 0x07,
    0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x92, 0x22, 0x22, 0xff, 0x07, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07,
    0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf9, 0x22, 0x22, 0x7f, 0xef, 0x07,
    0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0xfc, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0xf7, 0x55, 0x7f, 0xef, 0x07, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xfe, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
};

//*****************************************************************************
//
// 80x30 red button in the pressed state
//
//*****************************************************************************
const unsigned char g_pucRedBtn80x30Down[] =
{
    IMAGE_FMT_8BPP_COMP,
    80, 0,
    30, 0,

    90,
    0x00, 0x00, 0x40,
    0x00, 0x00, 0x41,
    0x00, 0x00, 0x45,
    0x00, 0x00, 0x4c,
    0x00, 0x00, 0x4d,
    0x00, 0x00, 0x4f,
    0x00, 0x00, 0x55,
    0x00, 0x00, 0x5f,
    0x00, 0x00, 0x60,
    0x00, 0x00, 0x62,
    0x00, 0x00, 0x6b,
    0x00, 0x00, 0x6e,
    0x00, 0x00, 0x74,
    0x00, 0x00, 0x7a,
    0x00, 0x00, 0x7b,
    0x00, 0x00, 0x7e,
    0x00, 0x00, 0x80,
    0x00, 0x00, 0x8c,
    0x00, 0x00, 0x91,
    0x00, 0x00, 0x97,
    0x00, 0x00, 0xa1,
    0x00, 0x00, 0xa5,
    0x00, 0x00, 0xa6,
    0x00, 0x00, 0xa7,
    0x00, 0x00, 0xae,
    0x00, 0x00, 0xb0,
    0x00, 0x00, 0xb5,
    0x00, 0x00, 0xb6,
    0x00, 0x00, 0xb8,
    0x00, 0x00, 0xb9,
    0x00, 0x00, 0xc8,
    0x00, 0x00, 0xd1,
    0x00, 0x00, 0xd6,
    0x00, 0x00, 0xdb,
    0x00, 0x00, 0xe1,
    0x00, 0x00, 0xe2,
    0x00, 0x00, 0xe5,
    0x00, 0x00, 0xec,
    0x00, 0x00, 0xee,
    0x00, 0x00, 0xf2,
    0x00, 0x00, 0xf5,
    0x00, 0x00, 0xff,
    0x02, 0x02, 0xff,
    0x0a, 0x0a, 0xff,
    0x0c, 0x0c, 0xff,
    0x0d, 0x0d, 0xff,
    0x10, 0x10, 0xff,
    0x12, 0x12, 0xff,
    0x15, 0x15, 0xff,
    0x1c, 0x1c, 0xff,
    0x1e, 0x1e, 0xff,
    0x28, 0x28, 0xff,
    0x2a, 0x2a, 0xff,
    0x2b, 0x2b, 0xff,
    0x31, 0x31, 0xff,
    0x36, 0x36, 0xff,
    0x38, 0x38, 0xff,
    0x39, 0x39, 0xff,
    0x3a, 0x3a, 0xff,
    0x3c, 0x3c, 0xff,
    0x3d, 0x3d, 0xff,
    0x40, 0x40, 0xff,
    0x49, 0x49, 0xff,
    0x4a, 0x4a, 0xff,
    0x4b, 0x4b, 0xff,
    0x4d, 0x4d, 0xff,
    0x58, 0x58, 0xff,
    0x5a, 0x5a, 0xff,
    0x5b, 0x5b, 0xff,
    0x5e, 0x5e, 0xff,
    0x61, 0x61, 0xff,
    0x6a, 0x6a, 0xff,
    0x6c, 0x6c, 0xff,
    0x70, 0x70, 0xff,
    0x73, 0x73, 0xff,
    0x76, 0x76, 0xff,
    0x77, 0x77, 0xff,
    0x82, 0x82, 0xff,
    0x85, 0x85, 0xff,
    0x86, 0x86, 0xff,
    0x87, 0x87, 0xff,
    0x8b, 0x8b, 0xff,
    0x8f, 0x8f, 0xff,
    0x95, 0x95, 0xff,
    0x97, 0x97, 0xff,
    0x99, 0x99, 0xff,
    0x9a, 0x9a, 0xff,
    0x9d, 0x9d, 0xff,
    0xa0, 0xa0, 0xff,
    0xa4, 0xa4, 0xff,
    0xa5, 0xa5, 0xff,

    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x8f, 0x03, 0x04,
    0x0c, 0x16, 0x07, 0x07, 0x77, 0x2f, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x01,
    0x02, 0x07, 0x10, 0x20, 0x17, 0x1f, 0x01, 0x03, 0x08, 0x0a, 0x0a, 0x0a,
    0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x80, 0x02, 0x0d,
    0x13, 0x1b, 0x20, 0x28, 0x01, 0x05, 0x03, 0x09, 0x0e, 0x13, 0x15, 0x15,
    0x15, 0xe9, 0xd4, 0xfe, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x02, 0x1a,
    0x00, 0x1f, 0x25, 0x2a, 0x30, 0x06, 0x0b, 0x11, 0x18, 0x0f, 0x1f, 0x23,
    0x23, 0x23, 0xe9, 0xd4, 0xa7, 0x5f, 0xf8, 0x17, 0x07, 0x07, 0x07, 0x02,
    0x27, 0x2c, 0x32, 0x00, 0x34, 0x36, 0x08, 0x0f, 0x14, 0x1e, 0x26, 0x29,
    0x3f, 0x29, 0x29, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xe0, 0x07, 0x07,
    0x02, 0x2e, 0x33, 0x37, 0x3b, 0x3c, 0x07, 0x08, 0x0f, 0x14, 0x1e, 0x26,
    0x07, 0x07, 0x77, 0xf8, 0x2f, 0x07, 0x07, 0x07, 0x05, 0x2e, 0x33, 0x37,
    0x01, 0x3b, 0x3c, 0x08, 0x0f, 0x14, 0x1e, 0x26, 0x07, 0xfe, 0x07, 0x77,
    0x2f, 0x07, 0x07, 0x07, 0x05, 0x2e, 0x00, 0x33, 0x37, 0x3b, 0x3c, 0x08,
    0x0f, 0x14, 0x1e, 0x7f, 0x26, 0x07, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07,
    0x80, 0x05, 0x2e, 0x33, 0x37, 0x3b, 0x3c, 0x08, 0x0f, 0x1f, 0x14, 0x1e,
    0x26, 0x07, 0x07, 0x77, 0x2f, 0x07, 0xe0, 0x07, 0x07, 0x05, 0x2e, 0x33,
    0x37, 0x3b, 0x3c, 0x07, 0x08, 0x0f, 0x14, 0x1e, 0x26, 0x07, 0x07, 0x77,
    0xf8, 0x2f, 0x07, 0x07, 0x07, 0x05, 0x2e, 0x33, 0x37, 0x01, 0x3b, 0x3c,
    0x08, 0x0f, 0x14, 0x1e, 0x26, 0x07, 0xfe, 0x07, 0x77, 0x2f, 0x07, 0x07,
    0x07, 0x05, 0x2e, 0x00, 0x33, 0x37, 0x3b, 0x3c, 0x08, 0x0f, 0x14, 0x1e,
    0x7f, 0x26, 0x07, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x80, 0x05, 0x2e,
    0x33, 0x37, 0x3b, 0x3c, 0x08, 0x0f, 0x1f, 0x14, 0x1e, 0x26, 0x07, 0x07,
    0x77, 0x2f, 0x07, 0xe0, 0x07, 0x07, 0x05, 0x2e, 0x33, 0x37, 0x3b, 0x3c,
    0x07, 0x08, 0x0f, 0x14, 0x1e, 0x26, 0x07, 0x07, 0x77, 0xf8, 0x2f, 0x07,
    0x07, 0x07, 0x05, 0x2e, 0x33, 0x37, 0x01, 0x3b, 0x3c, 0x08, 0x0f, 0x14,
    0x1e, 0x26, 0x07, 0xfe, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x05, 0x2e,
    0x00, 0x33, 0x37, 0x3b, 0x3c, 0x08, 0x0f, 0x14, 0x1e, 0x7f, 0x26, 0x07,
    0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x80, 0x05, 0x2e, 0x33, 0x37, 0x3b,
    0x3c, 0x08, 0x0f, 0x1f, 0x14, 0x1e, 0x26, 0x07, 0x07, 0x77, 0x2f, 0x07,
    0xe0, 0x07, 0x07, 0x05, 0x2e, 0x33, 0x37, 0x3b, 0x3c, 0x07, 0x08, 0x0f,
    0x14, 0x1e, 0x26, 0x07, 0x07, 0x77, 0xf8, 0x2f, 0x07, 0x07, 0x07, 0x05,
    0x2e, 0x33, 0x37, 0x01, 0x3b, 0x3c, 0x08, 0x0f, 0x14, 0x1e, 0x26, 0x07,
    0xfe, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x05, 0x2e, 0x00, 0x33, 0x37,
    0x3b, 0x3c, 0x08, 0x0f, 0x14, 0x1e, 0x7f, 0x26, 0x07, 0x07, 0x77, 0x2f,
    0x07, 0x07, 0x07, 0x80, 0x05, 0x2e, 0x33, 0x37, 0x3b, 0x3c, 0x08, 0x0f,
    0x1f, 0x14, 0x1e, 0x26, 0x07, 0x07, 0x77, 0x2f, 0x07, 0xe0, 0x07, 0x07,
    0x05, 0x2e, 0x33, 0x37, 0x3b, 0x3c, 0x07, 0x08, 0x0f, 0x14, 0x1e, 0x26,
    0x07, 0x07, 0x77, 0xf8, 0x2f, 0x07, 0x07, 0x07, 0x05, 0x2e, 0x33, 0x37,
    0x01, 0x3b, 0x3c, 0x08, 0x0f, 0x14, 0x1e, 0x26, 0x07, 0xfe, 0x07, 0x77,
    0x2f, 0x07, 0x07, 0x07, 0x05, 0x2e, 0x00, 0x33, 0x37, 0x3b, 0x3c, 0x08,
    0x0f, 0x14, 0x1e, 0x7f, 0x26, 0x07, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07,
    0x80, 0x05, 0x2e, 0x33, 0x37, 0x3b, 0x3c, 0x0b, 0x12, 0x03, 0x1d, 0x23,
    0x2b, 0x31, 0x31, 0x31, 0xe9, 0xd4, 0xfe, 0xa7, 0x5f, 0x17, 0x07, 0x07,
    0x07, 0x02, 0x35, 0x00, 0x3d, 0x40, 0x41, 0x3e, 0x11, 0x1c, 0x24, 0x2f,
    0x0f, 0x3a, 0x3f, 0x3f, 0x3f, 0xe9, 0xd4, 0xa7, 0x5f, 0xf8, 0x17, 0x07,
    0x07, 0x07, 0x02, 0x42, 0x47, 0x49, 0x00, 0x48, 0x46, 0x19, 0x22, 0x2e,
    0x3a, 0x45, 0x48, 0x3f, 0x48, 0x48, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07,
    0xe0, 0x07, 0x07, 0x02, 0x4c, 0x4f, 0x51, 0x4e, 0x4c, 0x00, 0x21, 0x2d,
    0x38, 0x44, 0x4b, 0x4d, 0x4d, 0x4d, 0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0x17,
    0x07, 0x07, 0x07, 0x80, 0x02, 0x51, 0x54, 0x57, 0x55, 0x51, 0x2d, 0x39,
    0x03, 0x43, 0x4a, 0x50, 0x52, 0x52, 0x52, 0xe9, 0xd4, 0xfe, 0xa7, 0x5f,
    0x17, 0x07, 0x07, 0x07, 0x02, 0x53, 0x00, 0x58, 0x5a, 0x59, 0x56,
};

//*****************************************************************************
//
// 80x30 red button in the unpressed state
//
//*****************************************************************************
const unsigned char g_pucRedBtn80x30Up[] =
{
    IMAGE_FMT_8BPP_COMP,
    80, 0,
    30, 0,

    90,
    0x00, 0x00, 0x40,
    0x00, 0x00, 0x41,
    0x00, 0x00, 0x45,
    0x00, 0x00, 0x4c,
    0x00, 0x00, 0x4d,
    0x00, 0x00, 0x4f,
    0x00, 0x00, 0x55,
    0x00, 0x00, 0x5f,
    0x00, 0x00, 0x60,
    0x00, 0x00, 0x62,
    0x00, 0x00, 0x6b,
    0x00, 0x00, 0x6e,
    0x00, 0x00, 0x74,
    0x00, 0x00, 0x7a,
    0x00, 0x00, 0x7b,
    0x00, 0x00, 0x7e,
    0x00, 0x00, 0x80,
    0x00, 0x00, 0x8c,
    0x00, 0x00, 0x91,
    0x00, 0x00, 0x97,
    0x00, 0x00, 0xa1,
    0x00, 0x00, 0xa5,
    0x00, 0x00, 0xa6,
    0x00, 0x00, 0xa7,
    0x00, 0x00, 0xae,
    0x00, 0x00, 0xb0,
    0x00, 0x00, 0xb5,
    0x00, 0x00, 0xb6,
    0x00, 0x00, 0xb8,
    0x00, 0x00, 0xb9,
    0x00, 0x00, 0xc8,
    0x00, 0x00, 0xd1,
    0x00, 0x00, 0xd6,
    0x00, 0x00, 0xdb,
    0x00, 0x00, 0xe1,
    0x00, 0x00, 0xe2,
    0x00, 0x00, 0xe5,
    0x00, 0x00, 0xec,
    0x00, 0x00, 0xee,
    0x00, 0x00, 0xf2,
    0x00, 0x00, 0xf5,
    0x00, 0x00, 0xff,
    0x02, 0x02, 0xff,
    0x0a, 0x0a, 0xff,
    0x0c, 0x0c, 0xff,
    0x0d, 0x0d, 0xff,
    0x10, 0x10, 0xff,
    0x12, 0x12, 0xff,
    0x15, 0x15, 0xff,
    0x1c, 0x1c, 0xff,
    0x1e, 0x1e, 0xff,
    0x28, 0x28, 0xff,
    0x2a, 0x2a, 0xff,
    0x2b, 0x2b, 0xff,
    0x31, 0x31, 0xff,
    0x36, 0x36, 0xff,
    0x38, 0x38, 0xff,
    0x39, 0x39, 0xff,
    0x3a, 0x3a, 0xff,
    0x3c, 0x3c, 0xff,
    0x3d, 0x3d, 0xff,
    0x40, 0x40, 0xff,
    0x49, 0x49, 0xff,
    0x4a, 0x4a, 0xff,
    0x4b, 0x4b, 0xff,
    0x4d, 0x4d, 0xff,
    0x58, 0x58, 0xff,
    0x5a, 0x5a, 0xff,
    0x5b, 0x5b, 0xff,
    0x5e, 0x5e, 0xff,
    0x61, 0x61, 0xff,
    0x6a, 0x6a, 0xff,
    0x6c, 0x6c, 0xff,
    0x70, 0x70, 0xff,
    0x73, 0x73, 0xff,
    0x76, 0x76, 0xff,
    0x77, 0x77, 0xff,
    0x82, 0x82, 0xff,
    0x85, 0x85, 0xff,
    0x86, 0x86, 0xff,
    0x87, 0x87, 0xff,
    0x8b, 0x8b, 0xff,
    0x8f, 0x8f, 0xff,
    0x95, 0x95, 0xff,
    0x97, 0x97, 0xff,
    0x99, 0x99, 0xff,
    0x9a, 0x9a, 0xff,
    0x9d, 0x9d, 0xff,
    0xa0, 0xa0, 0xff,
    0xa4, 0xa4, 0xff,
    0xa5, 0xa5, 0xff,

    0x00, 0x56, 0x59, 0x5a, 0x58, 0x53, 0x52, 0x52, 0x52, 0xff, 0xe9, 0xd4,
    0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x80, 0x02, 0x50, 0x4a, 0x43, 0x39,
    0x2d, 0x51, 0x55, 0x03, 0x57, 0x54, 0x51, 0x4d, 0x4d, 0x4d, 0xe9, 0xd4,
    0xfe, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x02, 0x4b, 0x00, 0x44, 0x38,
    0x2d, 0x21, 0x4c, 0x4e, 0x51, 0x4f, 0x0f, 0x4c, 0x48, 0x48, 0x48, 0xe9,
    0xd4, 0xa7, 0x5f, 0xf8, 0x17, 0x07, 0x07, 0x07, 0x02, 0x45, 0x3a, 0x2e,
    0x00, 0x22, 0x19, 0x46, 0x48, 0x49, 0x47, 0x42, 0x3f, 0x3f, 0x3f, 0x3f,
    0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xe0, 0x07, 0x07, 0x02, 0x3a, 0x2f,
    0x24, 0x1c, 0x11, 0x00, 0x3e, 0x41, 0x40, 0x3d, 0x35, 0x31, 0x31, 0x31,
    0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x80, 0x02, 0x2b,
    0x23, 0x1d, 0x12, 0x0b, 0x3c, 0x3b, 0x03, 0x37, 0x33, 0x2e, 0x29, 0x29,
    0x29, 0xe9, 0xd4, 0xfe, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x02, 0x26,
    0x00, 0x1e, 0x14, 0x0f, 0x08, 0x3c, 0x3b, 0x37, 0x33, 0x7f, 0x2e, 0x07,
    0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x80, 0x05, 0x26, 0x1e, 0x14, 0x0f,
    0x08, 0x3c, 0x3b, 0x1f, 0x37, 0x33, 0x2e, 0x07, 0x07, 0x77, 0x2f, 0x07,
    0xe0, 0x07, 0x07, 0x05, 0x26, 0x1e, 0x14, 0x0f, 0x08, 0x07, 0x3c, 0x3b,
    0x37, 0x33, 0x2e, 0x07, 0x07, 0x77, 0xf8, 0x2f, 0x07, 0x07, 0x07, 0x05,
    0x26, 0x1e, 0x14, 0x01, 0x0f, 0x08, 0x3c, 0x3b, 0x37, 0x33, 0x2e, 0x07,
    0xfe, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x05, 0x26, 0x00, 0x1e, 0x14,
    0x0f, 0x08, 0x3c, 0x3b, 0x37, 0x33, 0x7f, 0x2e, 0x07, 0x07, 0x77, 0x2f,
    0x07, 0x07, 0x07, 0x80, 0x05, 0x26, 0x1e, 0x14, 0x0f, 0x08, 0x3c, 0x3b,
    0x1f, 0x37, 0x33, 0x2e, 0x07, 0x07, 0x77, 0x2f, 0x07, 0xe0, 0x07, 0x07,
    0x05, 0x26, 0x1e, 0x14, 0x0f, 0x08, 0x07, 0x3c, 0x3b, 0x37, 0x33, 0x2e,
    0x07, 0x07, 0x77, 0xf8, 0x2f, 0x07, 0x07, 0x07, 0x05, 0x26, 0x1e, 0x14,
    0x01, 0x0f, 0x08, 0x3c, 0x3b, 0x37, 0x33, 0x2e, 0x07, 0xfe, 0x07, 0x77,
    0x2f, 0x07, 0x07, 0x07, 0x05, 0x26, 0x00, 0x1e, 0x14, 0x0f, 0x08, 0x3c,
    0x3b, 0x37, 0x33, 0x7f, 0x2e, 0x07, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07,
    0x80, 0x05, 0x26, 0x1e, 0x14, 0x0f, 0x08, 0x3c, 0x3b, 0x1f, 0x37, 0x33,
    0x2e, 0x07, 0x07, 0x77, 0x2f, 0x07, 0xe0, 0x07, 0x07, 0x05, 0x26, 0x1e,
    0x14, 0x0f, 0x08, 0x07, 0x3c, 0x3b, 0x37, 0x33, 0x2e, 0x07, 0x07, 0x77,
    0xf8, 0x2f, 0x07, 0x07, 0x07, 0x05, 0x26, 0x1e, 0x14, 0x01, 0x0f, 0x08,
    0x3c, 0x3b, 0x37, 0x33, 0x2e, 0x07, 0xfe, 0x07, 0x77, 0x2f, 0x07, 0x07,
    0x07, 0x05, 0x26, 0x00, 0x1e, 0x14, 0x0f, 0x08, 0x3c, 0x3b, 0x37, 0x33,
    0x7f, 0x2e, 0x07, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x80, 0x05, 0x26,
    0x1e, 0x14, 0x0f, 0x08, 0x3c, 0x3b, 0x1f, 0x37, 0x33, 0x2e, 0x07, 0x07,
    0x77, 0x2f, 0x07, 0xe0, 0x07, 0x07, 0x05, 0x26, 0x1e, 0x14, 0x0f, 0x08,
    0x07, 0x3c, 0x3b, 0x37, 0x33, 0x2e, 0x07, 0x07, 0x77, 0xf8, 0x2f, 0x07,
    0x07, 0x07, 0x05, 0x26, 0x1e, 0x14, 0x01, 0x0f, 0x08, 0x3c, 0x3b, 0x37,
    0x33, 0x2e, 0x07, 0xfe, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x05, 0x26,
    0x00, 0x1e, 0x14, 0x0f, 0x08, 0x3c, 0x3b, 0x37, 0x33, 0x7f, 0x2e, 0x07,
    0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x80, 0x05, 0x26, 0x1e, 0x14, 0x0f,
    0x08, 0x3c, 0x3b, 0x1f, 0x37, 0x33, 0x2e, 0x07, 0x07, 0x77, 0x2f, 0x07,
    0xe0, 0x07, 0x07, 0x05, 0x26, 0x1e, 0x14, 0x0f, 0x08, 0x07, 0x3c, 0x3b,
    0x37, 0x33, 0x2e, 0x07, 0x07, 0x77, 0xf8, 0x2f, 0x07, 0x07, 0x07, 0x05,
    0x26, 0x1e, 0x14, 0x00, 0x0f, 0x08, 0x36, 0x34, 0x32, 0x2c, 0x27, 0x23,
    0x3f, 0x23, 0x23, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xe0, 0x07, 0x07,
    0x02, 0x1f, 0x18, 0x11, 0x0b, 0x06, 0x00, 0x30, 0x2a, 0x25, 0x1f, 0x1a,
    0x15, 0x15, 0x15, 0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07,
    0x80, 0x02, 0x13, 0x0e, 0x09, 0x05, 0x01, 0x28, 0x20, 0x03, 0x1b, 0x13,
    0x0d, 0x0a, 0x0a, 0x0a, 0xe9, 0xd4, 0xfe, 0xa7, 0x5f, 0x17, 0x07, 0x07,
    0x07, 0x02, 0x08, 0x00, 0x03, 0x00, 0x00, 0x00, 0x1f, 0x17, 0x10, 0x07,
    0x7f, 0x02, 0xc1, 0xa9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xe3, 0x07, 0x07,
    0x07, 0x16, 0x0c, 0x04, 0x07, 0x07, 0xfe, 0x77, 0x2f, 0x07, 0x07, 0x07,
    0x07, 0x03,
};

const unsigned char g_pucFPGACameraImage[] =
{
    IMAGE_FMT_4BPP_COMP,
    200, 0,
    42, 0,

    15,
    0x09, 0x09, 0x0c,
    0x32, 0x31, 0x33,
    0x00, 0x00, 0xff,
    0x36, 0x36, 0xb7,
    0x28, 0x28, 0xe7,
    0x62, 0x61, 0x64,
    0x4e, 0x4e, 0x93,
    0x84, 0x83, 0x87,
    0x73, 0x73, 0xec,
    0xa0, 0xa0, 0xa1,
    0xb7, 0xb6, 0xb6,
    0xae, 0xae, 0xf5,
    0xd4, 0xd3, 0xd4,
    0xd3, 0xd3, 0xf7,
    0xee, 0xed, 0xee,
    0xff, 0xff, 0xff,

    0x1f, 0xff, 0xff, 0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xe2, 0x07, 0x07, 0x03, 0xfd, 0xbb, 0xde, 0x03, 0xfe, 0x7f, 0xdf, 0x07,
    0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x80, 0x07, 0xff, 0xff, 0x42, 0x22,
    0x22, 0x22, 0x22, 0x01, 0x2b, 0xeb, 0x22, 0x22, 0x24, 0x48, 0xee, 0x01,
    0x51, 0xe8, 0x81, 0x8d, 0x02, 0xf8, 0x4e, 0xef, 0x03, 0xff, 0xdb, 0xb7,
    0x6f, 0x27, 0x07, 0x07, 0x07, 0x07, 0x01, 0x42, 0x22, 0x22, 0x22, 0x22,
    0x26, 0xcb, 0xd2, 0x09, 0x28, 0xef, 0xff, 0xfb, 0x92, 0x23, 0xcf, 0x01,
    0x3f, 0xf2, 0x29, 0xd2, 0xb9, 0xd4, 0xa7, 0x5f, 0x17, 0xf0, 0x07, 0x07,
    0x07, 0x05, 0x42, 0x46, 0x66, 0x66, 0x00, 0x66, 0x67, 0xab, 0x22, 0x36,
    0x63, 0x42, 0x22, 0x00, 0x8c, 0xff, 0xb2, 0x22, 0x36, 0x55, 0x63, 0x27,
    0x47, 0xae, 0x01, 0xb2, 0x23, 0xaf, 0x03, 0xdb, 0xb7, 0xfc, 0x6f, 0x27,
    0x07, 0x07, 0x07, 0x07, 0x42, 0x25, 0x00, 0x9a, 0xaa, 0xaa, 0xaa, 0xeb,
    0x22, 0x67, 0x9a, 0x00, 0x96, 0x22, 0x3a, 0xee, 0x22, 0x26, 0x59, 0xac,
    0x13, 0xca, 0x77, 0xce, 0x42, 0x22, 0x9e, 0x03, 0xdb, 0xfe, 0xb7, 0x6f,
    0x27, 0x07, 0x07, 0x07, 0x07, 0x42, 0x00, 0x47, 0xce, 0xee, 0xee, 0xef,
    0xfb, 0x22, 0x69, 0x00, 0xee, 0xec, 0x32, 0x29, 0xc8, 0x22, 0x65, 0xae,
    0x00, 0xef, 0xfe, 0xed, 0xef, 0xff, 0xff, 0xfd, 0x24, 0x3f, 0x22, 0x6c,
    0x03, 0xdb, 0xb7, 0x6f, 0x27, 0x07, 0xe2, 0x07, 0x07, 0x07, 0x42, 0x47,
    0xcf, 0x01, 0xfb, 0x00, 0x22, 0x6a, 0xef, 0xff, 0x82, 0x27, 0xc2, 0x23,
    0x21, 0x5a, 0xef, 0x04, 0xf8, 0x23, 0x42, 0x3a, 0xad, 0xff, 0x7c, 0xa7,
    0x5f, 0x17, 0x07, 0x07, 0x07, 0x04, 0x10, 0x42, 0x47, 0xcf, 0x01, 0xfb,
    0x22, 0x6a, 0xef, 0x02, 0xff, 0x82, 0x25, 0xb2, 0x23, 0x7c, 0x05, 0xf2,
    0x0c, 0x26, 0x32, 0x27, 0xef, 0xa5, 0x6d, 0xff, 0xff, 0x06, 0xfc, 0x75,
    0x55, 0x51, 0x9f, 0x5f, 0x11, 0x50, 0x08, 0x0a, 0xf9, 0x00, 0x5f, 0x7f,
    0xff, 0xff, 0x70, 0x70, 0x05, 0x17, 0x57, 0x09, 0x42, 0x24, 0x44, 0x44,
    0x00, 0x4e, 0xef, 0xfb, 0x22, 0x6a, 0xef, 0xfd, 0x22, 0x08, 0x37, 0x82,
    0x25, 0xae, 0x05, 0xb2, 0x45, 0x92, 0x30, 0x23, 0xaf, 0xa5, 0x6d, 0xff,
    0xff, 0x90, 0x00, 0x02, 0x00, 0x00, 0x5f, 0xf5, 0x55, 0xcf, 0x47, 0x50,
    0x08, 0x0a, 0xf9, 0x00, 0x5f, 0x07, 0xff, 0xff, 0x70, 0x70, 0x05, 0x9f,
    0x57, 0x09, 0x42, 0x22, 0x22, 0x22, 0x00, 0x29, 0xef, 0xfb, 0x22, 0x6a,
    0xed, 0xb2, 0x22, 0x00, 0x67, 0x82, 0x25, 0xaf, 0xff, 0xfb, 0x88, 0x88,
    0x43, 0xbe, 0x49, 0x37, 0xc4, 0x24, 0xae, 0x02, 0xe2, 0x80, 0xc5, 0xfc,
    0x00, 0x00, 0x01, 0x00, 0x5f, 0xf1, 0x20, 0x00, 0xcf, 0x47, 0x50, 0x0a,
    0xf9, 0x00, 0x5f, 0x87, 0x07, 0xff, 0xff, 0x95, 0x19, 0x9f, 0x57, 0x09,
    0x00, 0x42, 0x26, 0x66, 0x66, 0x69, 0xcf, 0xfb, 0x22, 0x00, 0x22, 0x22,
    0x22, 0x23, 0x5a, 0x82, 0x25, 0xcf, 0x00, 0xff, 0xf8, 0x22, 0x22, 0x8c,
    0xef, 0xfd, 0x22, 0x0e, 0x69, 0xd8, 0x22, 0x7c, 0x02, 0xe2, 0xc5, 0xf5,
    0x00, 0x00, 0x5c, 0xec, 0xcc, 0xef, 0xf1, 0x00, 0xcf, 0x02, 0xee, 0xee,
    0xff, 0xff, 0xec, 0xcc, 0x11, 0x50, 0x03, 0x0a, 0xf9, 0x00, 0x5f, 0xfe,
    0xee, 0x82, 0x01, 0xee, 0xc1, 0x39, 0x89, 0xcf, 0x8b, 0x63, 0x3b, 0x42,
    0x00, 0x45, 0x9a, 0xaa, 0xac, 0xef, 0xfb, 0x22, 0x22, 0x00, 0x22, 0x24,
    0x65, 0x9e, 0x82, 0x25, 0xcf, 0xff, 0x00, 0xfb, 0x83, 0x22, 0x39, 0xef,
    0xf8, 0x22, 0x5a, 0x1c, 0xed, 0x22, 0x3a, 0x02, 0xe2, 0xc5, 0xf1, 0x00,
    0x40, 0xaf, 0xd2, 0x01, 0x11, 0x11, 0x07, 0xff, 0xe7, 0x00, 0x11, 0x11,
    0x17, 0xef, 0xff, 0x50, 0x0a, 0xf9, 0x14, 0x00, 0x5f, 0xe5, 0x79, 0x17,
    0x01, 0xa1, 0x11, 0x83, 0xc2, 0xfa, 0x51, 0x11, 0x11, 0x1a, 0x91, 0x79,
    0xc0, 0xd4, 0x31, 0x42, 0x47, 0xce, 0xee, 0xee, 0xff, 0x00, 0xfb, 0x22,
    0x36, 0x66, 0x55, 0x7a, 0xcf, 0xb2, 0x00, 0x26, 0xaf, 0xff, 0xfe, 0xca,
    0x22, 0x39, 0xef, 0x01, 0xf4, 0x23, 0x7c, 0xfe, 0x42, 0x29, 0xef, 0x01,
    0xc1, 0xe9, 0xd4, 0xff, 0xff, 0xf1, 0x01, 0xcf, 0xd3, 0x00, 0x00, 0x00,
    0x07, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x50, 0x0a, 0xf9,
    0x00, 0x5f, 0xf0, 0x84, 0xa9, 0x00, 0x5f, 0xff, 0xf7, 0xca, 0x05, 0xff,
    0x43, 0x90, 0x39, 0x0a, 0xff, 0xff, 0xff, 0xe9, 0xd4, 0x88, 0xa1, 0x42,
    0x47, 0xcf, 0x71, 0xfb, 0x22, 0x67, 0x00, 0x9a, 0xac, 0xee, 0xff, 0xe2,
    0x23, 0xae, 0xff, 0x00, 0xff, 0xee, 0x22, 0x39, 0xef, 0xb2, 0x23, 0x38,
    0x1c, 0x88, 0x42, 0x26, 0x32, 0x19, 0xd4, 0xff, 0xff, 0x20, 0xf1, 0x00,
    0x7a, 0xf1, 0x01, 0x11, 0x51, 0x19, 0x00, 0xf7, 0x00, 0x05, 0x55, 0x10,
    0x07, 0xff, 0x50, 0x00, 0x0a, 0xf9, 0x00, 0x5f, 0xf5, 0x11, 0x51, 0x51,
    0x00, 0x00, 0x07, 0xff, 0xa0, 0x00, 0x15, 0x15, 0x10, 0x00, 0x05, 0xfe,
    0x00, 0x01, 0x51, 0x51, 0x1c, 0xff, 0x38, 0xff, 0xff, 0xe9, 0xd4, 0xa1,
    0x42, 0x47, 0xcf, 0x80, 0x71, 0xfb, 0x22, 0x69, 0xee, 0xef, 0xff, 0xff,
    0x10, 0xf4, 0x22, 0x7c, 0x09, 0x22, 0x39, 0xef, 0x82, 0x03, 0x22, 0x22,
    0x22, 0x22, 0x23, 0xae, 0x01, 0x19, 0x82, 0xd4, 0xff, 0xff, 0xf1, 0x00,
    0x5f, 0xd3, 0xcf, 0x00, 0xff, 0xff, 0xe1, 0x00, 0xaf, 0xff, 0x90, 0x01,
    0x0c, 0xff, 0x50, 0x0a, 0xf9, 0x63, 0xa2, 0x70, 0x05, 0x87, 0xc9, 0x05,
    0xfa, 0x00, 0x1e, 0x82, 0x62, 0xc6, 0x04, 0xff, 0xff, 0x42, 0x47, 0xcf,
    0x59, 0xfb, 0x22, 0x28, 0x6a, 0xef, 0xcb, 0x4a, 0xc9, 0x22, 0x39, 0xed,
    0x01, 0x22, 0x36, 0x66, 0x66, 0x64, 0x22, 0x9e, 0x01, 0xc0, 0x19, 0xd4,
    0xff, 0xff, 0xf7, 0x01, 0x01, 0x7a, 0x00, 0xef, 0xff, 0xf1, 0x01, 0xcf,
    0xff, 0xff, 0xc0, 0x00, 0x01, 0xef, 0xff, 0xc1, 0x01, 0xef, 0x50, 0x0a,
    0x00, 0xf9, 0x00, 0x5f, 0xff, 0xfc, 0x99, 0xcf, 0xe1, 0x80, 0xa1, 0x09,
    0xff, 0xff, 0x70, 0x07, 0xf9, 0x00, 0x0e, 0x7f, 0xff, 0xff, 0xff, 0xe9,
    0xd4, 0xa4, 0x42, 0x21, 0x47, 0xcf, 0x59, 0xfb, 0x22, 0x6a, 0xef, 0x21,
    0x00, 0xfe, 0x82, 0x22, 0x8d, 0xef, 0xb4, 0x22, 0x39, 0x00, 0xe8, 0x22,
    0x67, 0xaa, 0xaa, 0xa8, 0x22, 0x6c, 0xf0, 0x01, 0x19, 0xd4, 0x11, 0x50,
    0x00, 0x00, 0x09, 0x00, 0xff, 0xf1, 0x00, 0xcf, 0xff, 0xff, 0xc0, 0x01,
    0x00, 0xef, 0xff, 0xe1, 0x00, 0xef, 0x50, 0x0a, 0xf9, 0x00, 0x00, 0x5f,
    0xff, 0x70, 0x00, 0x01, 0x11, 0x01, 0x00, 0xef, 0x10, 0x0a, 0xff, 0xff,
    0x70, 0x05, 0xf9, 0x07, 0x00, 0x1e, 0xff, 0xff, 0xff, 0xe9, 0xd4, 0xa4,
    0x10, 0x42, 0x47, 0xcf, 0x59, 0xfb, 0x22, 0x6a, 0xef, 0x80, 0x22, 0xc4,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x69, 0x00, 0xe4, 0x24, 0x5a, 0xee, 0xfe,
    0xec, 0x22, 0x49, 0xe0, 0x63, 0x42, 0xc4, 0xe7, 0x50, 0x00, 0x00, 0x9f,
    0x00, 0xf1, 0x01, 0xcf, 0xff, 0xff, 0xc1, 0x01, 0xef, 0x00, 0xff, 0xc1,
    0x00, 0xef, 0x50, 0x0a, 0xf9, 0x00, 0x01, 0x5f, 0xf9, 0x00, 0x00, 0x00,
    0x01, 0x01, 0xa1, 0x00, 0xff, 0xff, 0x70, 0x05, 0xfc, 0x00, 0x01, 0x59,
    0x0c, 0xaf, 0xff, 0xff, 0xff, 0xe9, 0xd3, 0xfe, 0xbb, 0x02, 0xbe, 0xff,
    0xff, 0x42, 0x47, 0xcf, 0x69, 0xfb, 0x10, 0x22, 0x6a, 0xef, 0x32, 0xfc,
    0x74, 0x22, 0x22, 0x02, 0x24, 0x35, 0x7a, 0xb2, 0x23, 0x7c, 0x01, 0x42,
    0x70, 0x27, 0x2a, 0x4a, 0xcd, 0xff, 0xfe, 0x91, 0x00, 0x12, 0x1f, 0xf1,
    0x00, 0x51, 0xc0, 0x01, 0xe2, 0xef, 0x00, 0x50, 0x0a, 0xf9, 0x00, 0x5f,
    0xf1, 0x00, 0x5c, 0x20, 0xaa, 0x91, 0xa2, 0xff, 0xff, 0x70, 0x05, 0xff,
    0x00, 0x50, 0x00, 0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xc0, 0xe9, 0xd1,
    0xfb, 0x42, 0x22, 0x22, 0x4b, 0xef, 0x11, 0xe9, 0x79, 0xef, 0x71, 0xfe,
    0xc7, 0x7c, 0xca, 0x00, 0xff, 0xff, 0xda, 0x76, 0x66, 0x55, 0x79, 0xce,
    0x11, 0xec, 0x77, 0xae, 0x59, 0xe9, 0x79, 0xcf, 0x63, 0xc1, 0x3b, 0xb4,
    0xfc, 0x00, 0x1e, 0xf1, 0x01, 0x51, 0x00, 0xc0, 0x01, 0xaa, 0xaa, 0x10,
    0x05, 0xff, 0x50, 0x00, 0x0a, 0xf9, 0x00, 0x5f, 0xc1, 0x01, 0xef, 0xff,
    0x00, 0xe1, 0x01, 0xef, 0x10, 0x0a, 0xff, 0xff, 0x70, 0x00, 0x05, 0xff,
    0xf9, 0x11, 0x00, 0x00, 0x1e, 0xff, 0x30, 0xff, 0xff, 0xe9, 0xd1, 0x82,
    0x22, 0x22, 0x22, 0x04, 0x23, 0xae, 0xee, 0xce, 0xef, 0x72, 0xec, 0xce,
    0x80, 0x44, 0xfe, 0xcc, 0xaa, 0xac, 0xce, 0xef, 0xfe, 0x5c, 0xcc, 0x5a,
    0xee, 0xd3, 0x44, 0xbd, 0xfe, 0x10, 0x00, 0x1c, 0xf1, 0x00, 0xcf, 0xff,
    0xff, 0xc0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0x50, 0x0a, 0xf9,
    0x00, 0x00, 0x5f, 0xc0, 0x01, 0xff, 0xff, 0xc1, 0x01, 0x00, 0xef, 0x50,
    0x0a, 0xff, 0xff, 0x70, 0x05, 0xff, 0x00, 0xff, 0xfe, 0xc5, 0x10, 0x09,
    0xff, 0xff, 0xff, 0x80, 0xe9, 0xff, 0xff, 0xf8, 0x22, 0x26, 0x55, 0x56,
    0x33, 0x37, 0xae, 0x8e, 0x4e, 0xff, 0xee, 0x77, 0x2f, 0x80, 0x07, 0xff,
    0xfc, 0x10, 0x1e, 0xf1, 0x01, 0xcf, 0x00, 0xff, 0xff, 0xc0, 0x01, 0x11,
    0x00, 0x00, 0x7f, 0x00, 0xff, 0x50, 0x0a, 0xf9, 0x00, 0x5f, 0xa1, 0x01,
    0x00, 0xef, 0xff, 0xc1, 0x01, 0xef, 0x50, 0x0a, 0xff, 0x00, 0xff, 0x70,
    0x05, 0xff, 0xff, 0xff, 0xff, 0x50, 0x60, 0x07, 0xd2, 0xb2, 0xd2, 0x24,
    0x57, 0x9c, 0xcc, 0x3f, 0xaa, 0xcf, 0x8e, 0x4e, 0x87, 0x3f, 0x07, 0x01,
    0x00, 0xfc, 0x10, 0x1e, 0xf1, 0x00, 0xcf, 0xff, 0xff, 0x00, 0xc1, 0x01,
    0xff, 0xca, 0xae, 0xff, 0xff, 0x50, 0x0c, 0x0a, 0xf9, 0x00, 0x5f, 0xa1,
    0x81, 0xef, 0x50, 0x01, 0x0a, 0xff, 0xff, 0x70, 0x05, 0xff, 0xff, 0xd1,
    0x60, 0x07, 0xd2, 0xb2, 0x82, 0x26, 0x7a, 0xef, 0xff, 0x02, 0xee, 0xef,
    0xff, 0xff, 0xbb, 0xbf, 0x6b, 0xfd, 0x0b, 0xbd, 0xef, 0xff, 0xeb, 0xab,
    0xfb, 0xb1, 0x69, 0x26, 0xfe, 0xbb, 0x59, 0xbb, 0xdf, 0x1b, 0xdb, 0xff,
    0x00, 0xee, 0xef, 0xf7, 0x00, 0x1f, 0xf5, 0x00, 0x7f, 0x04, 0xee, 0xef,
    0xf1, 0x01, 0x9f, 0x89, 0xff, 0x50, 0x00, 0x0a, 0xf9, 0x00, 0x5f, 0xe1,
    0x00, 0xaf, 0xff, 0x00, 0x70, 0x01, 0xff, 0x10, 0x0a, 0xff, 0xff, 0x70,
    0x00, 0x05, 0xff, 0xee, 0xee, 0xfe, 0x10, 0x09, 0xff, 0x20, 0xff, 0xff,
    0xe9, 0xff, 0xff, 0x22, 0x35, 0xae, 0x80, 0xaa, 0xfb, 0x82, 0x22, 0x22,
    0x8d, 0xef, 0xff, 0x00, 0xb2, 0x8b, 0x42, 0x22, 0x48, 0xd8, 0x22, 0x22,
    0x00, 0x8e, 0xff, 0xff, 0xf8, 0x22, 0x22, 0x28, 0xcf, 0x00, 0xff, 0xb2,
    0x2c, 0x82, 0x22, 0x8e, 0xf8, 0x42, 0x2c, 0x22, 0x24, 0x71, 0xff, 0xe9,
    0xd1, 0xf7, 0x11, 0x00, 0x51, 0x10, 0x00, 0x7f, 0xf9, 0x00, 0x01, 0x11,
    0x20, 0x19, 0xf7, 0xd9, 0x11, 0x17, 0xff, 0x50, 0x0a, 0x05, 0xf9, 0x00,
    0x5f, 0xf5, 0x00, 0x41, 0x07, 0xa1, 0x00, 0xff, 0xff, 0x70, 0x05, 0xfe,
    0x11, 0x11, 0x11, 0x04, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xe9, 0xff, 0xfb,
    0x10, 0x22, 0x67, 0xcf, 0xaa, 0xf8, 0x22, 0x44, 0x42, 0x00, 0x24, 0xce,
    0xff, 0xb2, 0x22, 0x24, 0x42, 0x22, 0x01, 0x42, 0x44, 0x22, 0x28, 0xcf,
    0xfe, 0x42, 0xb1, 0x00, 0x4a, 0xef, 0xb2, 0x24, 0x24, 0x42, 0x7c, 0xe2,
    0x42, 0x22, 0x71, 0xee, 0xff, 0xff, 0xff, 0xe9, 0xff, 0x00, 0xff, 0xf1,
    0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0x0c, 0x50, 0x00, 0x00, 0x07, 0xda,
    0xa1, 0x10, 0x0a, 0x04, 0xf9, 0x00, 0x5f, 0xfe, 0x10, 0x41, 0x5f, 0xff,
    0x01, 0x50, 0x0a, 0xff, 0xff, 0x70, 0x05, 0xfc, 0x41, 0x04, 0x00, 0x9f,
    0xff, 0xff, 0xff, 0xe9, 0xff, 0xf8, 0x10, 0x22, 0x6a, 0xef, 0xaa, 0xfe,
    0x46, 0x57, 0x76, 0x04, 0x22, 0x6c, 0xff, 0xb2, 0x24, 0xc9, 0x26, 0x77,
    0x00, 0x72, 0x24, 0xae, 0xf8, 0x22, 0x65, 0x77, 0x62, 0x00, 0x24, 0xcf,
    0xb2, 0x22, 0x67, 0x77, 0x9c, 0xf8, 0x00, 0x65, 0x57, 0x74, 0x24, 0xae,
    0xff, 0xff, 0xff, 0x80, 0xe9, 0xff, 0xff, 0xf5, 0x01, 0x11, 0x11, 0x9f,
    0x00, 0xff, 0xff, 0xf7, 0x11, 0x11, 0x07, 0xff, 0xf7, 0x00, 0x51, 0x11,
    0x11, 0x05, 0xff, 0x50, 0x0a, 0xf9, 0x00, 0x00, 0x5f, 0xff, 0xe7, 0x11,
    0x01, 0x19, 0xef, 0x80, 0xa1, 0xff, 0xff, 0x70, 0x07, 0xfe, 0x10, 0x11,
    0x04, 0x11, 0x5a, 0xff, 0xff, 0xff, 0xe9, 0xff, 0xff, 0x20, 0xf8, 0x22,
    0xad, 0xca, 0xac, 0xcc, 0x42, 0x4a, 0x00, 0xef, 0xb2, 0x25, 0x7a, 0xcc,
    0x42, 0x35, 0x9c, 0x00, 0xc8, 0x22, 0x7c, 0xd2, 0x26, 0x5a, 0xcc, 0xc8,
    0x00, 0x22, 0x9c, 0xb2, 0x23, 0x59, 0xcc, 0xce, 0xfe, 0x00, 0xaa, 0xcc,
    0xc9, 0x22, 0x7c, 0xff, 0xff, 0xff, 0xfe, 0xe9, 0xd4, 0xa7, 0x5f, 0x17,
    0x07, 0x07, 0xf8, 0x20, 0x22, 0x5c, 0x04, 0xfe, 0xed, 0xbb, 0x82, 0x49,
    0x00, 0xef, 0xb2, 0x25, 0xae, 0xff, 0x42, 0x39, 0xcf, 0x00, 0xeb, 0x22,
    0x7c, 0x82, 0x45, 0x9e, 0xff, 0xfc, 0x04, 0x22, 0x6c, 0xb2, 0x25, 0x9c,
    0x01, 0xee, 0xeb, 0x1f, 0xbd, 0x22, 0x6a, 0xc1, 0xa9, 0xd4, 0xa7, 0x5f,
    0xe2, 0x17, 0x07, 0x07, 0xf8, 0x22, 0x5c, 0x04, 0xd8, 0x00, 0x22, 0x22,
    0x22, 0x47, 0xcf, 0xb2, 0x25, 0xcf, 0x00, 0xff, 0x42, 0x39, 0xef, 0xfb,
    0x22, 0x5c, 0x42, 0x81, 0x81, 0x22, 0x22, 0x6a, 0xb2, 0x25, 0xaf, 0x01,
    0x7f, 0xb4, 0xaa, 0xc1, 0xa9, 0xd4, 0xa7, 0x5f, 0x17, 0xc4, 0x07, 0x07,
    0xfb, 0x22, 0x6a, 0x03, 0xfd, 0x22, 0x00, 0x23, 0x33, 0x22, 0x47, 0xcf,
    0xb2, 0x25, 0xcf, 0x00, 0xff, 0x42, 0x39, 0xef, 0xfb, 0x22, 0x7c, 0x42,
    0x02, 0x24, 0x44, 0x44, 0x44, 0x44, 0x5a, 0x7a, 0xff, 0x00, 0xf8, 0x22,
    0x43, 0x33, 0x22, 0x6a, 0xef, 0xff, 0x3f, 0xff, 0xff, 0xe9, 0xd4, 0xa7,
    0x5f, 0x17, 0x07, 0x84, 0x06, 0xfe, 0x22, 0x3a, 0xef, 0x02, 0xe2, 0x24,
    0x00, 0x57, 0x99, 0x62, 0x47, 0xcf, 0xb2, 0x27, 0xcf, 0x00, 0xff, 0x42,
    0x39, 0xef, 0xfb, 0x22, 0x5c, 0x42, 0x00, 0x45, 0x57, 0x77, 0x77, 0x77,
    0x9c, 0xb2, 0x25, 0x00, 0xcf, 0xff, 0xff, 0x82, 0x23, 0x57, 0x99, 0x22,
    0x07, 0x6a, 0xef, 0xff, 0xff, 0xff, 0xe9, 0xd4, 0xa7, 0xf1, 0x5f, 0x17,
    0x07, 0x07, 0x42, 0x27, 0xef, 0x02, 0x00, 0xb2, 0x25, 0x7a, 0xce, 0x82,
    0x47, 0xcf, 0xb2, 0x00, 0x25, 0xcf, 0xff, 0x42, 0x39, 0xef, 0xfb, 0x22,
    0x00, 0x5c, 0x82, 0x27, 0xae, 0xcc, 0xcc, 0xcc, 0xee, 0x80, 0x7a, 0xff,
    0x42, 0x35, 0x9c, 0xee, 0x22, 0x6a, 0x0f, 0xef, 0xff, 0xff, 0xff, 0xe9,
    0xd4, 0xa7, 0x5f, 0xe0, 0x17, 0x07, 0x07, 0xb2, 0x24, 0xae, 0xff, 0xff,
    0x00, 0xed, 0xff, 0x82, 0x45, 0xae, 0xff, 0x82, 0x47, 0x00, 0xcf, 0xb2,
    0x25, 0xcf, 0xff, 0x42, 0x39, 0xef, 0x02, 0xfb, 0x22, 0x7c, 0xb2, 0x23,
    0xaf, 0x0b, 0x27, 0x00, 0xcf, 0xff, 0xff, 0x22, 0x69, 0xcf, 0xff, 0x22,
    0x3f, 0x6a, 0xef, 0x82, 0x62, 0xc6, 0x87, 0x3f, 0x07, 0xc0, 0x07, 0x03,
    0xf3, 0x22, 0x48, 0xef, 0xdb, 0x22, 0x00, 0xcf, 0x82, 0x27, 0xcf, 0xfd,
    0x22, 0x47, 0xcf, 0x00, 0xb2, 0x25, 0xcf, 0xff, 0x42, 0x39, 0xef, 0xfb,
    0x00, 0x22, 0x5c, 0xe4, 0x22, 0x8c, 0xff, 0xe8, 0xbe, 0x40, 0xff, 0x7a,
    0xff, 0x42, 0x3a, 0xef, 0xe8, 0x22, 0x07, 0x6a, 0xef, 0xff, 0xff, 0xff,
    0xe9, 0xd4, 0xa7, 0xf0, 0x5f, 0x17, 0x07, 0x07, 0xfd, 0x42, 0x22, 0x22,
    0x00, 0x22, 0x22, 0x7c, 0xe4, 0x22, 0x88, 0x42, 0x42, 0x00, 0x26, 0xcf,
    0xb2, 0x27, 0xcf, 0xff, 0x42, 0x39, 0x00, 0xef, 0xfb, 0x22, 0x5c, 0xfc,
    0x42, 0x22, 0x44, 0x00, 0x22, 0x4a, 0xef, 0xb2, 0x25, 0xcf, 0xff, 0xff,
    0x00, 0x82, 0x24, 0x88, 0x22, 0x22, 0x49, 0xef, 0xff, 0x3f, 0xff, 0xff,
    0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x80, 0x07, 0xfe, 0xc6, 0x22, 0x22,
    0x22, 0x35, 0x7c, 0x00, 0xec, 0x42, 0x22, 0x23, 0x73, 0x24, 0xae, 0xb2,
    0x00, 0x25, 0xcf, 0xff, 0x42, 0x39, 0xef, 0xfb, 0x22, 0x00, 0x5c, 0xfe,
    0xc3, 0x22, 0x22, 0x23, 0x69, 0xef, 0x80, 0x7a, 0xff, 0xe8, 0x22, 0x22,
    0x47, 0x62, 0x26, 0xbf, 0xb9, 0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07,
    0x80, 0x07, 0xff, 0xfc, 0xa7, 0x66, 0x65, 0x79, 0xce, 0x00, 0xfe, 0xc7,
    0x66, 0x79, 0x9a, 0x76, 0xae, 0xec, 0x00, 0x79, 0xcf, 0xff, 0xe9, 0x7a,
    0xef, 0xfe, 0xc7, 0x00, 0x9c, 0xff, 0xec, 0x96, 0x66, 0x77, 0x9c, 0xef,
    0x80, 0x7a, 0xff, 0xfc, 0x96, 0x67, 0x79, 0xaa, 0x69, 0xbf, 0xb9, 0xff,
    0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x80, 0x07, 0xff, 0xff, 0xec, 0xaa,
    0xaa, 0xce, 0xef, 0x00, 0xff, 0xec, 0xca, 0xac, 0xee, 0xec, 0xce, 0xfe,
    0x04, 0xcc, 0xef, 0xff, 0xfe, 0xce, 0x61, 0xce, 0xff, 0x0e, 0xfe, 0xec,
    0xaa, 0xac, 0xd1, 0x79, 0x89, 0xaa, 0x0f, 0xcc, 0xee, 0xcc, 0xcf, 0xb9,
    0xa1, 0xd4, 0xa7, 0xfb, 0x5f, 0x17, 0x07, 0x07, 0x02, 0xef, 0xdb, 0xbe,
    0xb8, 0x07, 0xfe, 0xaf, 0xaa, 0x97,
};

const unsigned char g_pucStellarisWare[] =
{
    IMAGE_FMT_4BPP_COMP,
    143, 0,
    20, 0,

    7,
    0x00, 0x00, 0x00,
    0x22, 0x21, 0x24,
    0x4a, 0x48, 0x49,
    0x73, 0x72, 0x72,
    0x9d, 0x9b, 0x9b,
    0xbb, 0xb9, 0xb9,
    0xe4, 0xe3, 0xe2,
    0xff, 0xff, 0xff,

    0x00, 0x77, 0x64, 0x23, 0x23, 0x24, 0x77, 0x77, 0x77, 0xc1, 0xe9, 0xd4,
    0x72, 0x00, 0x57, 0x40, 0x03, 0x7f, 0x04, 0x77, 0x77, 0x74, 0x00, 0x37,
    0x0c, 0x42, 0x24, 0x01, 0x77, 0x74, 0x22, 0x57, 0x77, 0x32, 0x25, 0x1f,
    0x80, 0xbe, 0x73, 0x34, 0x36, 0x30, 0x74, 0x00, 0x00, 0x04, 0x00, 0x02,
    0x77, 0x32, 0x36, 0x1f, 0x72, 0x01, 0x10, 0x57, 0x40, 0x03, 0x97, 0x77,
    0x77, 0x73, 0x00, 0x40, 0x37, 0x24, 0x30, 0x03, 0x77, 0x72, 0x00, 0x47,
    0x18, 0x77, 0x10, 0x05, 0x1f, 0xbe, 0x75, 0x45, 0x23, 0x03, 0x10, 0x50,
    0x10, 0x11, 0x11, 0x03, 0x1f, 0x01, 0x04, 0x73, 0x00, 0x57, 0x50, 0x03,
    0x97, 0x77, 0x77, 0x12, 0x75, 0x22, 0x47, 0x24, 0x30, 0x03, 0x21, 0x47,
    0x18, 0x77, 0x20, 0x15, 0x1f, 0xbe, 0x75, 0x46, 0x33, 0x02, 0x30, 0x30,
    0x02, 0x56, 0x66, 0x66, 0x19, 0x76, 0x60, 0x66, 0x09, 0xb1, 0x77, 0x72,
    0x01, 0x47, 0x40, 0x48, 0x03, 0xb1, 0x66, 0x67, 0x79, 0x77, 0x76, 0x66,
    0x20, 0x66, 0x76, 0xcc, 0x77, 0x30, 0x04, 0x77, 0x73, 0x07, 0x00, 0x47,
    0x77, 0x20, 0x05, 0x1a, 0x22, 0x19, 0x61, 0x67, 0xe2, 0x11, 0x56, 0x50,
    0x11, 0x15, 0x6a, 0x00, 0x20, 0x11, 0x21, 0x20, 0x47, 0x76, 0x31, 0x11,
    0x00, 0x12, 0x36, 0x77, 0x72, 0x00, 0x57, 0x40, 0x03, 0x00, 0x77, 0x21,
    0x21, 0x21, 0x12, 0x47, 0x77, 0x77, 0x00, 0x75, 0x22, 0x11, 0x21, 0x21,
    0x37, 0x77, 0x52, 0x10, 0x11, 0x21, 0x11, 0x52, 0x73, 0x00, 0x47, 0x76,
    0x00, 0x20, 0x15, 0x75, 0x11, 0x11, 0x21, 0x13, 0x57, 0x00, 0x77, 0x77,
    0x63, 0x21, 0x11, 0x16, 0x76, 0x31, 0x00, 0x11, 0x12, 0x47, 0x77, 0x77,
    0x77, 0x70, 0x11, 0x40, 0x16, 0xd1, 0x77, 0x11, 0x10, 0x00, 0x00, 0x37,
    0x00, 0x72, 0x00, 0x00, 0x00, 0x02, 0x77, 0x72, 0x01, 0x0c, 0x47, 0x40,
    0x03, 0x77, 0x81, 0xa1, 0x77, 0x30, 0x88, 0x69, 0x10, 0x37, 0x74, 0x39,
    0x00, 0x57, 0x30, 0x00, 0x04, 0x77, 0x73, 0x00, 0x47, 0x77, 0x20, 0x15,
    0x80, 0x8b, 0x05, 0x77, 0x76, 0x10, 0x00, 0x00, 0x06, 0x40, 0x61, 0x29,
    0x03, 0x77, 0x77, 0x77, 0x70, 0x11, 0x40, 0x15, 0xd1, 0x77, 0x20, 0x12,
    0x22, 0x21, 0x47, 0x00, 0x30, 0x11, 0x23, 0x21, 0x10, 0x37, 0x73, 0x00,
    0x00, 0x57, 0x50, 0x03, 0x77, 0x32, 0x22, 0x22, 0x21, 0x04, 0x10, 0x47,
    0x75, 0x01, 0x02, 0xc9, 0x37, 0x61, 0x00, 0x01, 0x22, 0x22, 0x22, 0x57,
    0x40, 0x03, 0x77, 0x01, 0x73, 0x01, 0x47, 0x77, 0x20, 0x05, 0x75, 0x91,
    0x00, 0x11, 0x01, 0x67, 0x73, 0x01, 0x12, 0x22, 0x26, 0x00, 0x20, 0x11,
    0x23, 0x21, 0x10, 0x57, 0x77, 0x77, 0x00, 0x70, 0x11, 0x03, 0x77, 0x77,
    0x77, 0x77, 0x20, 0x40, 0x16, 0xd1, 0x10, 0x15, 0x77, 0x75, 0x00, 0x27,
    0x08, 0x72, 0x01, 0x57, 0x40, 0x63, 0x74, 0x00, 0x27, 0x10, 0x73, 0x00,
    0x27, 0xc9, 0x37, 0x50, 0x11, 0x67, 0x80, 0x09, 0x30, 0x04, 0x77, 0x73,
    0x00, 0x47, 0x77, 0x20, 0x20, 0x15, 0x1a, 0x72, 0x00, 0x57, 0x61, 0x01,
    0x04, 0x47, 0x77, 0x75, 0x10, 0x16, 0x59, 0x37, 0x77, 0x00, 0x77, 0x70,
    0x30, 0x10, 0x13, 0x56, 0x77, 0x76, 0x06, 0x20, 0x16, 0x77, 0x77, 0x76,
    0x61, 0xe1, 0x72, 0x00, 0x00, 0x57, 0x40, 0x03, 0x77, 0x77, 0x64, 0x46,
    0x42, 0x77, 0xa3, 0x77, 0x74, 0x00, 0x37, 0x82, 0x77, 0x40, 0x77, 0x51,
    0x73, 0x00, 0x47, 0x76, 0x20, 0x05, 0x08, 0x77, 0x77, 0x54, 0x56, 0x51,
    0x51, 0x02, 0x77, 0x00, 0x77, 0x74, 0x10, 0x27, 0x77, 0x75, 0x00, 0x27,
    0x00, 0x77, 0x77, 0x70, 0x72, 0x00, 0x00, 0x01, 0x47, 0x00, 0x77, 0x20,
    0x15, 0x77, 0x77, 0x75, 0x10, 0x26, 0x00, 0x77, 0x76, 0x10, 0x16, 0x72,
    0x01, 0x47, 0x41, 0x00, 0x03, 0x77, 0x73, 0x00, 0x00, 0x12, 0x11, 0x17,
    0x00, 0x72, 0x01, 0x57, 0x77, 0x74, 0x00, 0x37, 0x40, 0x01, 0x12, 0x67,
    0x77, 0x77, 0x77, 0x30, 0x04, 0x51, 0x00, 0x47, 0x77, 0x20, 0x15, 0x77,
    0x61, 0x00, 0x01, 0x02, 0x21, 0x10, 0x37, 0x50, 0x02, 0x77, 0x1a, 0x77,
    0x00, 0x75, 0x01, 0x27, 0x77, 0x77, 0x70, 0x77, 0x42, 0x00, 0x10, 0x10,
    0x04, 0x77, 0x20, 0x16, 0x77, 0x77, 0x10, 0x76, 0x10, 0x26, 0xe1, 0x16,
    0x73, 0x00, 0x57, 0x00, 0x40, 0x03, 0x77, 0x40, 0x10, 0x10, 0x00, 0x11,
    0x00, 0x16, 0x72, 0x00, 0x57, 0x77, 0x74, 0x00, 0x37, 0x02, 0x60, 0x01,
    0x13, 0x45, 0x77, 0x77, 0x51, 0x73, 0x02, 0x01, 0x47, 0x77, 0x20, 0x15,
    0x77, 0x21, 0x01, 0x04, 0x10, 0x37, 0x51, 0x02, 0x77, 0x19, 0x27, 0x77,
    0x40, 0x75, 0xe1, 0x77, 0x70, 0x77, 0x77, 0x65, 0x11, 0x42, 0x02, 0x1a,
    0x77, 0x75, 0x10, 0x26, 0xe1, 0x17, 0x00, 0x72, 0x01, 0x47, 0x40, 0x03,
    0x77, 0x20, 0x13, 0x20, 0x55, 0x55, 0xa2, 0x57, 0x77, 0x74, 0x00, 0x37,
    0x00, 0x73, 0x00, 0x00, 0x00, 0x25, 0x77, 0x30, 0x04, 0x00, 0x77, 0x72,
    0x00, 0x47, 0x77, 0x20, 0x05, 0x75, 0x00, 0x01, 0x14, 0x55, 0x62, 0x10,
    0x37, 0x50, 0x02, 0x00, 0x77, 0x77, 0x74, 0x10, 0x37, 0x77, 0x74, 0x00,
    0x00, 0x37, 0x77, 0x77, 0x70, 0x77, 0x77, 0x77, 0x51, 0x00, 0x01, 0x67,
    0x20, 0x16, 0x77, 0x77, 0x76, 0x10, 0x00, 0x15, 0x55, 0x52, 0x10, 0x27,
    0x72, 0x00, 0x57, 0x00, 0x50, 0x03, 0x76, 0x10, 0x16, 0x77, 0x76, 0x11,
    0x40, 0x16, 0xa1, 0x77, 0x74, 0x00, 0x37, 0x77, 0x42, 0x00, 0x10, 0x01,
    0x01, 0x77, 0x40, 0x03, 0x77, 0x73, 0x03, 0x00, 0x47, 0x76, 0x20, 0x15,
    0x73, 0x71, 0x51, 0x10, 0x51, 0x02, 0x77, 0x19, 0x25, 0x55, 0x41, 0x10,
    0x00, 0x37, 0x77, 0x77, 0x70, 0x77, 0x77, 0x77, 0x61, 0x00, 0x01, 0x67,
    0x20, 0x15, 0x77, 0x77, 0x75, 0x11, 0x00, 0x10, 0x00, 0x01, 0x00, 0x57,
    0x72, 0x01, 0x57, 0x00, 0x40, 0x03, 0x75, 0x10, 0x27, 0x77, 0x76, 0x10,
    0x40, 0x17, 0xa1, 0x77, 0x74, 0x00, 0x37, 0x77, 0x77, 0x00, 0x76, 0x31,
    0x10, 0x47, 0x30, 0x04, 0x77, 0x73, 0x06, 0x00, 0x47, 0x77, 0x20, 0x15,
    0xd2, 0xb1, 0x50, 0x00, 0x02, 0x77, 0x77, 0x74, 0x01, 0x10, 0x01, 0x01,
    0x00, 0x01, 0x67, 0x77, 0x77, 0x70, 0x77, 0x77, 0x77, 0x00, 0x62, 0x01,
    0x67, 0x20, 0x16, 0x77, 0x77, 0x76, 0x00, 0x01, 0x12, 0x11, 0x00, 0x14,
    0x77, 0x73, 0x00, 0x00, 0x57, 0x40, 0x03, 0x75, 0x10, 0x27, 0x77, 0x76,
    0x00, 0x11, 0x16, 0x72, 0x00, 0x57, 0x77, 0x74, 0x00, 0x11, 0x37, 0x77,
    0x77, 0x51, 0x37, 0x40, 0x03, 0x21, 0x0c, 0x47, 0x77, 0x20, 0x05, 0xd2,
    0x81, 0x51, 0x02, 0x00, 0x77, 0x77, 0x74, 0x01, 0x12, 0x11, 0x00, 0x15,
    0xa1, 0x01, 0x70, 0xe1, 0x61, 0x01, 0x77, 0x20, 0xa1, 0x00, 0x76, 0x10,
    0x26, 0x76, 0x45, 0x67, 0x77, 0x72, 0x0c, 0x01, 0x47, 0x41, 0x03, 0xa1,
    0x81, 0x17, 0x72, 0x00, 0x01, 0x57, 0x77, 0x74, 0x00, 0x37, 0x77, 0x77,
    0x02, 0x77, 0x73, 0x00, 0x47, 0x40, 0x03, 0xd1, 0x57, 0x18, 0x76, 0x20,
    0x15, 0xa1, 0x81, 0x37, 0x50, 0x02, 0x01, 0x77, 0x77, 0x74, 0x10, 0x37,
    0x65, 0x55, 0x09, 0x00, 0x77, 0x70, 0x77, 0x67, 0x77, 0x30, 0x02, 0x77,
    0x00, 0x20, 0x13, 0x76, 0x76, 0x77, 0x20, 0x15, 0x77, 0x00, 0x77, 0x76,
    0x77, 0x72, 0x00, 0x57, 0x40, 0x03, 0x01, 0x77, 0x10, 0x05, 0x77, 0x74,
    0x00, 0x27, 0xa1, 0x80, 0xc9, 0x37, 0x77, 0x67, 0x67, 0x62, 0x00, 0x47,
    0x00, 0x50, 0x02, 0x57, 0x73, 0x00, 0x47, 0x74, 0x10, 0x40, 0x16, 0x39,
    0x77, 0x62, 0x10, 0x57, 0x51, 0x02, 0x00, 0x77, 0x77, 0x75, 0x10, 0x16,
    0x77, 0x77, 0x76, 0x00, 0x77, 0x77, 0x77, 0x70, 0x31, 0x22, 0x21, 0x11,
    0x00, 0x04, 0x77, 0x40, 0x10, 0x22, 0x21, 0x47, 0x30, 0x00, 0x10, 0x22,
    0x22, 0x21, 0x37, 0x72, 0x01, 0x47, 0x00, 0x40, 0x03, 0x77, 0x30, 0x11,
    0x23, 0x21, 0x10, 0x00, 0x47, 0x72, 0x01, 0x57, 0x77, 0x74, 0x00, 0x37,
    0x00, 0x62, 0x12, 0x22, 0x11, 0x01, 0x67, 0x71, 0x01, 0x00, 0x12, 0x21,
    0x11, 0x22, 0x20, 0x10, 0x37, 0x76, 0x10, 0x10, 0x11, 0x32, 0x81, 0x50,
    0x02, 0x77, 0x77, 0x10, 0x77, 0x20, 0x11, 0x21, 0x57, 0x77, 0x77, 0x70,
    0x00, 0x20, 0x00, 0x10, 0x00, 0x27, 0x77, 0x72, 0x00, 0x18, 0x00, 0x00,
    0x37, 0xda, 0xd2, 0x57, 0x40, 0x03, 0x28, 0x77, 0x62, 0x79, 0x02, 0x49,
    0x57, 0x77, 0x74, 0x10, 0x00, 0x37, 0x60, 0x11, 0x04, 0x77, 0x75, 0x10,
    0x00, 0x00, 0x01, 0x11, 0x10, 0x00, 0x02, 0x67, 0x77, 0x00, 0x40, 0x01,
    0x00, 0x10, 0x05, 0x77, 0x50, 0x02, 0x00, 0x77, 0x77, 0x77, 0x61, 0x00,
    0x10, 0x00, 0x10, 0x00, 0x47, 0x77, 0x77, 0x70, 0x31, 0x11, 0x11, 0x24,
    0x84, 0x81, 0x42, 0x11, 0x11, 0x47, 0xda, 0x11, 0x37, 0x00, 0x73, 0x01,
    0x57, 0x41, 0x03, 0x77, 0x76, 0x32, 0x04, 0x11, 0x12, 0x47, 0x77, 0x72,
    0x59, 0x74, 0x00, 0x00, 0x37, 0x61, 0x11, 0x12, 0x13, 0x57, 0x77, 0x77,
    0x20, 0x63, 0x21, 0x01, 0x22, 0x46, 0x77, 0x77, 0x75, 0x00, 0x21, 0x11,
    0x12, 0x67, 0x77, 0x51, 0x12, 0x77, 0x08, 0x77, 0x77, 0x76, 0x32, 0x61,
    0x47, 0x77, 0x77, 0x00, 0x70,
};
