/*
 * UART_FIFO.c
 *
 *  Created on: 20151225
 *      Author: Lenovo
 */
#include "MSP430G2553.h"
#include "UART_Global.h"

char Rx_FIFO_WriteChar(unsigned char Data)
{
	if(Rx_FIFO_DataNum==RX_FIFO_SIZE) return 0;

	_disable_interrupts();
	Rx_FIFO_DataNum++;
	Rx_FIFO[Rx_FIFO_IndexW]=Data;
	Rx_FIFO_IndexW++;
	if(Rx_FIFO_IndexW>=RX_FIFO_SIZE)
		Rx_FIFO_IndexW=0;
	_enable_interrupts();
	return 1;
}

char Rx_FIFO_ReadChar(unsigned char *Chr)
{
	if(Rx_FIFO_DataNum==0) return 0;
	_disable_interrupts();
	Rx_FIFO_DataNum--;
	*Chr=Rx_FIFO[Rx_FIFO_IndexR];
	Rx_FIFO_IndexR++;
	if(Rx_FIFO_IndexR>=RX_FIFO_SIZE)
		Rx_FIFO_IndexR=0;
	_enable_interrupts();
	return 1;
}
void Rx_FIFO_Clear()
{
	_disable_interrupts();
	Rx_FIFO_DataNum=0;
	Rx_FIFO_IndexR=0;
	Rx_FIFO_IndexW=0;
	_enable_interrupts();
}

char Tx_FIFO_WriteChar(unsigned char Data)
{
	if(Tx_FIFO_DataNum==TX_FIFO_SIZE) return 0;

	_disable_interrupts();

	if((Tx_FIFO_DataNum==0)&&(!(UCA0STAT&UCBUSY)))
		IFG2 |=UCA0TXIFG;
	Tx_FIFO_DataNum++;
	Tx_FIFO[Tx_FIFO_IndexW]=Data;
	Tx_FIFO_IndexW++;
	if(Tx_FIFO_IndexW>=TX_FIFO_SIZE)
		Tx_FIFO_IndexW=0;
	_enable_interrupts();
	return (1);
}
char Tx_FIFO_ReadChar(unsigned char *Chr)
{
	if(Tx_FIFO_DataNum==0) return 0;
	_disable_interrupts();
	Tx_FIFO_DataNum--;
	*Chr=Tx_FIFO[Tx_FIFO_IndexR];
	Tx_FIFO_IndexR++;
	if(Tx_FIFO_IndexR>=TX_FIFO_SIZE)
		Tx_FIFO_IndexR=0;
	_enable_interrupts();
	return 1;
}

void Tx_FIFO_Clear()
{
	_disable_interrupts();
	Tx_FIFO_DataNum=0;
	Tx_FIFO_IndexR=0;
	Tx_FIFO_IndexW=0;
	_enable_interrupts();
}
